/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.vmanager.gb28181.play.PlayController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/v1/stream"})
public class ApiStreamController {
    private static final Logger logger = LoggerFactory.getLogger(ApiStreamController.class);
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private PlayController playController;

    @RequestMapping(value={"/start"})
    private DeferredResult<JSONObject> start(String serial, @RequestParam(required=false) Integer channel, @RequestParam(required=false) String code, @RequestParam(required=false) String cdn, @RequestParam(required=false) String audio, @RequestParam(required=false) String transport, @RequestParam(required=false) String checkchannelstatus, @RequestParam(required=false) String transportmode, @RequestParam(required=false) String timeout) {
        JSONObject result;
        JSONObject result2;
        DeferredResult resultDeferredResult = new DeferredResult();
        Device device = this.storager.queryVideoDevice(serial);
        if (device == null) {
            result2 = new JSONObject();
            result2.put("error", (Object)("device[ " + serial + " ]\u672a\u627e\u5230"));
            resultDeferredResult.setResult((Object)result2);
        } else if (device.getOnline() == 0) {
            result2 = new JSONObject();
            result2.put("error", (Object)("device[ " + code + " ]offline"));
            resultDeferredResult.setResult((Object)result2);
        }
        resultDeferredResult.onTimeout(() -> {
            logger.info("\u64ad\u653e\u7b49\u5f85\u8d85\u65f6");
            JSONObject result = new JSONObject();
            result.put("error", (Object)"timeout");
            resultDeferredResult.setResult((Object)result);
        });
        DeviceChannel deviceChannel = this.storager.queryChannel(serial, code);
        if (deviceChannel == null) {
            result = new JSONObject();
            result.put("error", (Object)("channel[ " + code + " ]\u672a\u627e\u5230"));
            resultDeferredResult.setResult((Object)result);
        } else if (deviceChannel.getStatus() == 0) {
            result = new JSONObject();
            result.put("error", (Object)("channel[ " + code + " ]offline"));
            resultDeferredResult.setResult((Object)result);
        }
        DeferredResult play = this.playController.play(serial, code);
        play.setResultHandler(o -> {
            ResponseEntity responseEntity = (ResponseEntity)o;
            StreamInfo streamInfo = (StreamInfo)JSON.parseObject((String)((String)responseEntity.getBody()), StreamInfo.class);
            JSONObject result = new JSONObject();
            result.put("StreamID", (Object)streamInfo.getStreamId());
            result.put("DeviceID", (Object)device.getDeviceId());
            result.put("ChannelID", (Object)code);
            result.put("ChannelName", (Object)deviceChannel.getName());
            result.put("ChannelCustomName", (Object)"");
            result.put("FLV", (Object)streamInfo.getFlv());
            result.put("WS_FLV", (Object)streamInfo.getWs_flv());
            result.put("RTMP", (Object)streamInfo.getRtmp());
            result.put("HLS", (Object)streamInfo.getHls());
            result.put("RTSP", (Object)streamInfo.getRtsp());
            result.put("CDN", (Object)"");
            result.put("SnapURL", (Object)"");
            result.put("Transport", (Object)device.getTransport());
            result.put("StartAt", (Object)"");
            result.put("Duration", (Object)"");
            result.put("SourceVideoCodecName", (Object)"");
            result.put("SourceVideoWidth", (Object)"");
            result.put("SourceVideoHeight", (Object)"");
            result.put("SourceVideoFrameRate", (Object)"");
            result.put("SourceAudioCodecName", (Object)"");
            result.put("SourceAudioSampleRate", (Object)"");
            result.put("AudioEnable", (Object)"");
            result.put("Ondemand", (Object)"");
            result.put("InBytes", (Object)"");
            result.put("InBitRate", (Object)"");
            result.put("OutBytes", (Object)"");
            result.put("NumOutputs", (Object)"");
            result.put("CascadeSize", (Object)"");
            result.put("RelaySize", (Object)"");
            result.put("ChannelPTZType", (Object)0);
            resultDeferredResult.setResult((Object)result);
        });
        return resultDeferredResult;
    }

    @RequestMapping(value={"/stop"})
    @ResponseBody
    private JSONObject stop(String serial, @RequestParam(required=false) Integer channel, @RequestParam(required=false) String code, @RequestParam(required=false) String check_outputs) {
        StreamInfo streamInfo = this.redisCatchStorage.queryPlayByDevice(serial, code);
        if (streamInfo == null) {
            JSONObject result = new JSONObject();
            result.put("error", (Object)"\u672a\u627e\u5230\u6d41\u4fe1\u606f");
            return result;
        }
        this.cmder.streamByeCmd(serial, code);
        this.redisCatchStorage.stopPlay(streamInfo);
        this.storager.stopPlay(streamInfo.getDeviceID(), streamInfo.getChannelId());
        return null;
    }

    @RequestMapping(value={"/touch"})
    @ResponseBody
    private JSONObject touch(String serial, String t, @RequestParam(required=false) Integer channel, @RequestParam(required=false) String code, @RequestParam(required=false) String autorestart, @RequestParam(required=false) String audio, @RequestParam(required=false) String cdn) {
        return null;
    }
}

