/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sip.RequestEvent;
import javax.sip.message.Request;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlUtil {
    private static Logger LOG = LoggerFactory.getLogger(XmlUtil.class);

    public static Element parseXml(String xml) {
        Document document = null;
        StringReader sr = new StringReader(xml);
        SAXReader saxReader = new SAXReader();
        try {
            document = saxReader.read((Reader)sr);
        }
        catch (DocumentException e) {
            LOG.error("\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        return null == document ? null : document.getRootElement();
    }

    public static String getText(Element em, String tag) {
        if (null == em) {
            return null;
        }
        Element e = em.element(tag);
        return null == e ? null : e.getText();
    }

    public static List<Map<String, Object>> listNodes(Element node, String nodeName) {
        if (null == node) {
            return null;
        }
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        List list = node.attributes();
        HashMap<String, String> map = null;
        for (Attribute attribute : list) {
            if (!nodeName.equals(node.getName())) continue;
            if (null == map) {
                map = new HashMap<String, String>();
                listMap.add(map);
            }
            map.put(attribute.getName(), attribute.getValue());
        }
        Iterator iterator = node.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            listMap.addAll(XmlUtil.listNodes((Element)e, (String)nodeName));
        }
        return listMap;
    }

    public static void node2Json(Element element, JSONObject json) {
        for (Object o : element.attributes()) {
            Attribute attr = (Attribute)o;
            if (StringUtils.isEmpty((Object)attr.getValue())) continue;
            json.put("@" + attr.getName(), (Object)attr.getValue());
        }
        List chdEl = element.elements();
        if (chdEl.isEmpty() && !StringUtils.isEmpty((Object)element.getText())) {
            json.put(element.getName(), (Object)element.getText());
        }
        for (Element e : chdEl) {
            if (!e.elements().isEmpty()) {
                JSONObject chdjson = new JSONObject();
                XmlUtil.node2Json((Element)e, (JSONObject)chdjson);
                Object o = json.get((Object)e.getName());
                if (o != null) {
                    JSONArray jsona = null;
                    if (o instanceof JSONObject) {
                        JSONObject jsono = (JSONObject)o;
                        json.remove((Object)e.getName());
                        jsona = new JSONArray();
                        jsona.add((Object)jsono);
                        jsona.add((Object)chdjson);
                    }
                    if (o instanceof JSONArray) {
                        jsona = (JSONArray)o;
                        jsona.add((Object)chdjson);
                    }
                    json.put(e.getName(), (Object)jsona);
                    continue;
                }
                if (chdjson.isEmpty()) continue;
                json.put(e.getName(), (Object)chdjson);
                continue;
            }
            for (Object o : element.attributes()) {
                Attribute attr = (Attribute)o;
                if (StringUtils.isEmpty((Object)attr.getValue())) continue;
                json.put("@" + attr.getName(), (Object)attr.getValue());
            }
            if (e.getText().isEmpty()) continue;
            json.put(e.getName(), (Object)e.getText());
        }
    }

    public static Element getRootElement(RequestEvent evt) throws DocumentException {
        return XmlUtil.getRootElement((RequestEvent)evt, (String)"gb2312");
    }

    public static Element getRootElement(RequestEvent evt, String charset) throws DocumentException {
        Request request = evt.getRequest();
        return XmlUtil.getRootElement((byte[])request.getRawContent(), (String)charset);
    }

    public static Element getRootElement(byte[] content, String charset) throws DocumentException {
        if (charset == null) {
            charset = "gb2312";
        }
        SAXReader reader = new SAXReader();
        reader.setEncoding(charset);
        Document xml = reader.read((InputStream)new ByteArrayInputStream(content));
        return xml.getRootElement();
    }
}

