/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.cmd;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.event.DeviceOffLineDetector;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.ResponseMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DeviceInfoResponseMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(DeviceInfoResponseMessageHandler.class);
    private final String cmdType = "DeviceInfo";
    @Autowired
    private ResponseMessageHandler responseMessageHandler;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private DeferredResultHolder deferredResultHolder;
    @Autowired
    private DeviceOffLineDetector offLineDetector;
    @Autowired
    private SipConfig config;
    @Autowired
    private EventPublisher publisher;

    public void afterPropertiesSet() throws Exception {
        this.responseMessageHandler.addHandler("DeviceInfo", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element rootElement) {
        this.logger.debug("\u63a5\u6536\u5230DeviceInfo\u5e94\u7b54\u6d88\u606f");
        try {
            rootElement = this.getRootElement(evt, device.getCharset());
            Element deviceIdElement = rootElement.element("DeviceID");
            String channelId = deviceIdElement.getTextTrim();
            String key = "CALLBACK_DEVICEINFO" + device.getDeviceId() + channelId;
            device.setName(XmlUtil.getText((Element)rootElement, (String)"DeviceName"));
            device.setManufacturer(XmlUtil.getText((Element)rootElement, (String)"Manufacturer"));
            device.setModel(XmlUtil.getText((Element)rootElement, (String)"Model"));
            device.setFirmware(XmlUtil.getText((Element)rootElement, (String)"Firmware"));
            if (StringUtils.isEmpty((Object)device.getStreamMode())) {
                device.setStreamMode("UDP");
            }
            this.storager.updateDevice(device);
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setData((Object)device);
            this.deferredResultHolder.invokeAllResult(msg);
            this.responseAck(evt, 200);
            if (this.offLineDetector.isOnline(device.getDeviceId())) {
                this.publisher.onlineEventPublish(device, "3");
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element rootElement) {
    }
}

