/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.gb28181.bean.BaiduPoint;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceAlarm;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.bean.GbStream;
import com.genersoft.iot.vmp.gb28181.bean.MobilePosition;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.RecordInfo;
import com.genersoft.iot.vmp.gb28181.bean.RecordItem;
import com.genersoft.iot.vmp.gb28181.event.DeviceOffLineDetector;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.callback.CheckForAllRecordsThread;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommanderFroPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.utils.DateUtil;
import com.genersoft.iot.vmp.gb28181.utils.NumericUtil;
import com.genersoft.iot.vmp.gb28181.utils.SipUtils;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.service.IDeviceAlarmService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.utils.GpsUtil;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import com.genersoft.iot.vmp.vmanager.gb28181.platform.bean.ChannelReduce;
import gov.nist.javax.sip.address.SipUri;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderAddress;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MessageRequestProcessor1
extends SIPRequestProcessorParent
implements InitializingBean,
ISIPRequestProcessor {
    public static volatile List<String> threadNameList = new ArrayList();
    private static final Logger logger = LoggerFactory.getLogger(MessageRequestProcessor1.class);
    private static Map<String, ISIPRequestProcessor> messageHandlerMap = new ConcurrentHashMap();
    private static final String CACHE_RECORDINFO_KEY = "CACHE_RECORDINFO_";
    private static final String MESSAGE_KEEP_ALIVE = "Keepalive";
    private static final String MESSAGE_CONFIG_DOWNLOAD = "ConfigDownload";
    private static final String MESSAGE_CATALOG = "Catalog";
    private static final String MESSAGE_DEVICE_INFO = "DeviceInfo";
    private static final String MESSAGE_ALARM = "Alarm";
    private static final String MESSAGE_RECORD_INFO = "RecordInfo";
    private static final String MESSAGE_MEDIA_STATUS = "MediaStatus";
    private static final String MESSAGE_BROADCAST = "Broadcast";
    private static final String MESSAGE_DEVICE_STATUS = "DeviceStatus";
    private static final String MESSAGE_DEVICE_CONTROL = "DeviceControl";
    private static final String MESSAGE_DEVICE_CONFIG = "DeviceConfig";
    private static final String MESSAGE_MOBILE_POSITION = "MobilePosition";
    private static final String MESSAGE_PRESET_QUERY = "PresetQuery";
    private String method = "MESSAGE1111";
    @Autowired
    private UserSetup userSetup;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private SipConfig config;
    @Autowired
    private SIPCommanderFroPlatform cmderFroPlatform;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private EventPublisher publisher;
    @Autowired
    private RedisUtil redis;
    @Autowired
    private DeferredResultHolder deferredResultHolder;
    @Autowired
    private DeviceOffLineDetector offLineDetector;
    @Autowired
    private IDeviceAlarmService deviceAlarmService;
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addRequestProcessor(this.method, (ISIPRequestProcessor)this);
    }

    public void process(RequestEvent evt) {
        try {
            Element rootElement = this.getRootElement(evt);
            String cmd = XmlUtil.getText((Element)rootElement, (String)"CmdType");
            if (MESSAGE_KEEP_ALIVE.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230KeepAlive\u6d88\u606f");
                this.processMessageKeepAlive(evt);
            } else if (MESSAGE_CONFIG_DOWNLOAD.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230ConfigDownload\u6d88\u606f");
                this.processMessageConfigDownload(evt);
            } else if (MESSAGE_CATALOG.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230Catalog\u6d88\u606f");
                this.processMessageCatalogList(evt);
            } else if (MESSAGE_DEVICE_INFO.equals(cmd)) {
                this.processMessageDeviceInfo(evt);
            } else if (MESSAGE_DEVICE_STATUS.equals(cmd)) {
                this.processMessageDeviceStatus(evt);
            } else if (MESSAGE_DEVICE_CONTROL.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230DeviceControl\u6d88\u606f");
                this.processMessageDeviceControl(evt);
            } else if (MESSAGE_DEVICE_CONFIG.equals(cmd)) {
                logger.info("\u63a5\u6536\u5230DeviceConfig\u6d88\u606f");
                this.processMessageDeviceConfig(evt);
            } else if (MESSAGE_ALARM.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230Alarm\u6d88\u606f");
                this.processMessageAlarm(evt);
            } else if (MESSAGE_RECORD_INFO.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230RecordInfo\u6d88\u606f");
                this.processMessageRecordInfo(evt);
            } else if (MESSAGE_MEDIA_STATUS.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230MediaStatus\u6d88\u606f");
                this.processMessageMediaStatus(evt);
            } else if (MESSAGE_MOBILE_POSITION.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230MobilePosition\u6d88\u606f");
                this.processMessageMobilePosition(evt);
            } else if (MESSAGE_PRESET_QUERY.equals(cmd)) {
                logger.debug("\u63a5\u6536\u5230PresetQuery\u6d88\u606f");
                this.processMessagePresetQuery(evt);
            } else if (MESSAGE_BROADCAST.equals(cmd)) {
                this.processMessageBroadcast(evt);
            } else {
                logger.debug("\u63a5\u6536\u5230\u6d88\u606f\uff1a" + cmd);
                this.responseAck(evt, 200);
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageMobilePosition(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406MobilePosition\u79fb\u52a8\u4f4d\u7f6e\u6d88\u606f\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            Element rootElement = this.getRootElement(evt, device.getCharset());
            MobilePosition mobilePosition = new MobilePosition();
            if (!StringUtils.isEmpty((Object)device.getName())) {
                mobilePosition.setDeviceName(device.getName());
            }
            mobilePosition.setDeviceId(deviceId);
            mobilePosition.setChannelId(XmlUtil.getText((Element)rootElement, (String)"DeviceID"));
            mobilePosition.setTime(XmlUtil.getText((Element)rootElement, (String)"Time"));
            mobilePosition.setLongitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Longitude")));
            mobilePosition.setLatitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Latitude")));
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Speed"))) {
                mobilePosition.setSpeed(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Speed")));
            } else {
                mobilePosition.setSpeed(0.0);
            }
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Direction"))) {
                mobilePosition.setDirection(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Direction")));
            } else {
                mobilePosition.setDirection(0.0);
            }
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Altitude"))) {
                mobilePosition.setAltitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Altitude")));
            } else {
                mobilePosition.setAltitude(0.0);
            }
            mobilePosition.setReportSource("Mobile Position");
            BaiduPoint bp = new BaiduPoint();
            bp = GpsUtil.Wgs84ToBd09((String)String.valueOf(mobilePosition.getLongitude()), (String)String.valueOf(mobilePosition.getLatitude()));
            logger.info("\u767e\u5ea6\u5750\u6807\uff1a" + bp.getBdLng() + ", " + bp.getBdLat());
            mobilePosition.setGeodeticSystem("BD-09");
            mobilePosition.setCnLng(bp.getBdLng());
            mobilePosition.setCnLat(bp.getBdLat());
            if (!this.userSetup.getSavePositionHistory().booleanValue()) {
                this.storager.clearMobilePositionsByDeviceId(deviceId);
            }
            this.storager.insertMobilePosition(mobilePosition);
            this.responseAck(evt, 200);
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageDeviceStatus(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406DeviceStatus\u8bbe\u5907\u72b6\u6001Message\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            Element rootElement = this.getRootElement(evt);
            String name = rootElement.getName();
            Element deviceIdElement = rootElement.element("DeviceID");
            String channelId = deviceIdElement.getText();
            if (name.equalsIgnoreCase("Query")) {
                logger.info("\u63a5\u6536\u5230DeviceStatus\u67e5\u8be2\u6d88\u606f");
                FromHeader fromHeader = (FromHeader)evt.getRequest().getHeader("From");
                String platformId = ((SipUri)fromHeader.getAddress().getURI()).getUser();
                if (platformId == null) {
                    this.responseAck(evt, 404);
                    return;
                }
                this.responseAck(evt, 200);
                String sn = rootElement.element("SN").getText();
                ParentPlatform parentPlatform = this.storager.queryParentPlatByServerGBId(platformId);
                this.cmderFroPlatform.deviceStatusResponse(parentPlatform, sn, fromHeader.getTag());
            } else {
                logger.info("\u63a5\u6536\u5230DeviceStatus\u5e94\u7b54\u6d88\u606f");
                if (this.storager.exists(deviceId)) {
                    this.responseAck(evt, 200);
                    JSONObject json = new JSONObject();
                    XmlUtil.node2Json((Element)rootElement, (JSONObject)json);
                    if (logger.isDebugEnabled()) {
                        logger.debug(json.toJSONString());
                    }
                    RequestMessage msg = new RequestMessage();
                    msg.setKey("CALLBACK_DEVICESTATUS" + deviceId + channelId);
                    msg.setData((Object)json);
                    this.deferredResultHolder.invokeAllResult(msg);
                    if (this.offLineDetector.isOnline(deviceId)) {
                        this.publisher.onlineEventPublish(device, "3");
                    }
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageDeviceControl(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406DeviceControl\u8bbe\u5907\u72b6\u6001Message\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            Element rootElement = this.getRootElement(evt);
            String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
            this.responseAck(evt, 200);
            if (rootElement.getName().equals("Response")) {
                JSONObject json = new JSONObject();
                XmlUtil.node2Json((Element)rootElement, (JSONObject)json);
                if (logger.isDebugEnabled()) {
                    logger.debug(json.toJSONString());
                }
                RequestMessage msg = new RequestMessage();
                String key = "CALLBACK_DEVICECONTROL" + deviceId + channelId;
                msg.setKey(key);
                msg.setData((Object)json);
                this.deferredResultHolder.invokeAllResult(msg);
            } else {
                String platformId = ((SipURI)((HeaderAddress)evt.getRequest().getHeader("From")).getAddress().getURI()).getUser();
                String targetGBId = ((SipURI)((HeaderAddress)evt.getRequest().getHeader("To")).getAddress().getURI()).getUser();
                if (!StringUtils.isEmpty((Object)XmlUtil.getText((Element)rootElement, (String)"TeleBoot")) && deviceId.equals(targetGBId)) {
                    logger.info("\u6267\u884c\u8fdc\u7a0b\u542f\u52a8\u672c\u5e73\u53f0\u547d\u4ee4");
                    ParentPlatform parentPlatform = this.storager.queryParentPlatByServerGBId(platformId);
                    this.cmderFroPlatform.unregister(parentPlatform, null, null);
                    Thread restartThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                    restartThread.setDaemon(false);
                    restartThread.start();
                }
                if (!StringUtils.isEmpty((Object)XmlUtil.getText((Element)rootElement, (String)"PTZCmd")) && !deviceId.equals(targetGBId)) {
                    String cmdString = XmlUtil.getText((Element)rootElement, (String)"PTZCmd");
                    Device deviceForPlatform = this.storager.queryVideoDeviceByPlatformIdAndChannelId(platformId, deviceId);
                    this.cmder.fronEndCmd(deviceForPlatform, deviceId, cmdString);
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageDeviceConfig(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406DeviceConfig\u8bbe\u5907\u72b6\u6001Message\u6d88\u606f\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            Element rootElement = this.getRootElement(evt);
            String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
            this.responseAck(evt, 200);
            if (rootElement.getName().equals("Response")) {
                JSONObject json = new JSONObject();
                XmlUtil.node2Json((Element)rootElement, (JSONObject)json);
                if (logger.isDebugEnabled()) {
                    logger.debug(json.toJSONString());
                }
                String key = "CALLBACK_DEVICECONFIG" + deviceId + channelId;
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)json);
                this.deferredResultHolder.invokeAllResult(msg);
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageConfigDownload(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406ConfigDownload\u8bbe\u5907\u72b6\u6001Message\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            Element rootElement = this.getRootElement(evt);
            String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
            String key = "CALLBACK_CONFIGDOWNLOAD" + deviceId + channelId;
            this.responseAck(evt, 200);
            if (rootElement.getName().equals("Response")) {
                JSONObject json = new JSONObject();
                XmlUtil.node2Json((Element)rootElement, (JSONObject)json);
                if (logger.isDebugEnabled()) {
                    logger.debug(json.toJSONString());
                }
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)json);
                this.deferredResultHolder.invokeAllResult(msg);
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessagePresetQuery(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406PresetQuery\u9884\u7f6e\u4f4d\u5217\u8868Message\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            Element rootElement = this.getRootElement(evt);
            String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
            String key = "CALLBACK_PRESETQUERY" + deviceId + channelId;
            this.responseAck(evt, 200);
            if (rootElement.getName().equals("Response")) {
                JSONObject json = new JSONObject();
                XmlUtil.node2Json((Element)rootElement, (JSONObject)json);
                if (logger.isDebugEnabled()) {
                    logger.debug(json.toJSONString());
                }
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)json);
                this.deferredResultHolder.invokeAllResult(msg);
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageDeviceInfo(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            ParentPlatform parentPlatform = this.storager.queryParentPlatByServerGBId(deviceId);
            Element rootElement = this.getRootElement(evt);
            String requestName = rootElement.getName();
            Element deviceIdElement = rootElement.element("DeviceID");
            String channelId = deviceIdElement.getTextTrim();
            String key = "CALLBACK_DEVICEINFO" + deviceId + channelId;
            if (device != null) {
                rootElement = this.getRootElement(evt, device.getCharset());
            }
            if (requestName.equals("Query")) {
                logger.info("\u63a5\u6536\u5230DeviceInfo\u67e5\u8be2\u6d88\u606f");
                FromHeader fromHeader = (FromHeader)evt.getRequest().getHeader("From");
                if (parentPlatform == null) {
                    this.responseAck(evt, 404);
                    return;
                }
                this.responseAck(evt, 200);
                String sn = rootElement.element("SN").getText();
                this.cmderFroPlatform.deviceInfoResponse(parentPlatform, sn, fromHeader.getTag());
            } else {
                logger.debug("\u63a5\u6536\u5230DeviceInfo\u5e94\u7b54\u6d88\u606f");
                if (device == null) {
                    logger.warn("\u5904\u7406DeviceInfo\u8bbe\u5907\u4fe1\u606fMessage\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                    this.responseAck(evt, 404);
                    return;
                }
                device.setName(XmlUtil.getText((Element)rootElement, (String)"DeviceName"));
                device.setManufacturer(XmlUtil.getText((Element)rootElement, (String)"Manufacturer"));
                device.setModel(XmlUtil.getText((Element)rootElement, (String)"Model"));
                device.setFirmware(XmlUtil.getText((Element)rootElement, (String)"Firmware"));
                if (StringUtils.isEmpty((Object)device.getStreamMode())) {
                    device.setStreamMode("UDP");
                }
                this.storager.updateDevice(device);
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)device);
                this.deferredResultHolder.invokeAllResult(msg);
                this.responseAck(evt, 200);
                if (this.offLineDetector.isOnline(deviceId)) {
                    this.publisher.onlineEventPublish(device, "3");
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageCatalogList(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            ParentPlatform parentPlatform = this.storager.queryParentPlatByServerGBId(deviceId);
            Element rootElement = this.getRootElement(evt);
            String name = rootElement.getName();
            Element deviceIdElement = rootElement.element("DeviceID");
            String channelId = deviceIdElement.getText();
            Element deviceListElement = rootElement.element("DeviceList");
            String key = "CALLBACK_CATALOG" + deviceId;
            FromHeader fromHeader = (FromHeader)evt.getRequest().getHeader("From");
            if (name.equalsIgnoreCase("Query")) {
                DeviceChannel deviceChannel;
                if (parentPlatform == null) {
                    this.responseAck(evt, 404);
                    return;
                }
                this.responseAck(evt, 200);
                Element snElement = rootElement.element("SN");
                String sn = snElement.getText();
                List channelReduces = this.storager.queryChannelListInParentPlatform(parentPlatform.getServerGBId());
                List gbStreams = this.storager.queryGbStreamListInPlatform(parentPlatform.getServerGBId());
                int size = channelReduces.size() + gbStreams.size();
                if (channelReduces.size() > 0) {
                    for (ChannelReduce channelReduce : channelReduces) {
                        deviceChannel = this.storager.queryChannel(channelReduce.getDeviceId(), channelReduce.getChannelId());
                        this.cmderFroPlatform.catalogQuery(deviceChannel, parentPlatform, sn, fromHeader.getTag(), size);
                    }
                }
                if (gbStreams.size() > 0) {
                    for (GbStream gbStream : gbStreams) {
                        deviceChannel = new DeviceChannel();
                        deviceChannel.setChannelId(gbStream.getGbId());
                        deviceChannel.setName(gbStream.getName());
                        deviceChannel.setLongitude(gbStream.getLongitude());
                        deviceChannel.setLatitude(gbStream.getLatitude());
                        deviceChannel.setDeviceId(parentPlatform.getDeviceGBId());
                        deviceChannel.setManufacture("wvp-pro");
                        deviceChannel.setStatus(gbStream.isStatus() ? 1 : 0);
                        deviceChannel.setRegisterWay(1);
                        deviceChannel.setCivilCode(this.config.getDomain());
                        deviceChannel.setModel("live");
                        deviceChannel.setOwner("wvp-pro");
                        deviceChannel.setParental(0);
                        deviceChannel.setSecrecy("0");
                        deviceChannel.setSecrecy("0");
                        this.cmderFroPlatform.catalogQuery(deviceChannel, parentPlatform, sn, fromHeader.getTag(), size);
                    }
                }
                if (size == 0) {
                    this.cmderFroPlatform.catalogQuery(null, parentPlatform, sn, fromHeader.getTag(), size);
                }
            } else {
                if (device == null) {
                    logger.warn("\u6536\u5230catalog\u8bbe\u5907\u76ee\u5f55\u5217\u8868\u8bf7\u6c42\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                    this.responseAck(evt, 404);
                    return;
                }
                deviceListElement = this.getRootElement(evt, device.getCharset()).element("DeviceList");
                Iterator deviceListIterator = deviceListElement.elementIterator();
                if (deviceListIterator != null) {
                    while (deviceListIterator.hasNext()) {
                        Element itemDevice = (Element)deviceListIterator.next();
                        Element channelDeviceElement = itemDevice.element("DeviceID");
                        if (channelDeviceElement == null) continue;
                        String channelDeviceId = channelDeviceElement.getText();
                        Element channdelNameElement = itemDevice.element("Name");
                        String channelName = channdelNameElement != null ? channdelNameElement.getTextTrim().toString() : "";
                        Element statusElement = itemDevice.element("Status");
                        String status = statusElement != null ? statusElement.getText().toString() : "ON";
                        DeviceChannel deviceChannel = new DeviceChannel();
                        deviceChannel.setName(channelName);
                        deviceChannel.setChannelId(channelDeviceId);
                        if (status.equals("ON") || status.equals("On") || status.equals("ONLINE")) {
                            deviceChannel.setStatus(1);
                        }
                        if (status.equals("OFF") || status.equals("Off") || status.equals("OFFLINE")) {
                            deviceChannel.setStatus(0);
                        }
                        deviceChannel.setManufacture(XmlUtil.getText((Element)itemDevice, (String)"Manufacturer"));
                        deviceChannel.setModel(XmlUtil.getText((Element)itemDevice, (String)"Model"));
                        deviceChannel.setOwner(XmlUtil.getText((Element)itemDevice, (String)"Owner"));
                        deviceChannel.setCivilCode(XmlUtil.getText((Element)itemDevice, (String)"CivilCode"));
                        deviceChannel.setBlock(XmlUtil.getText((Element)itemDevice, (String)"Block"));
                        deviceChannel.setAddress(XmlUtil.getText((Element)itemDevice, (String)"Address"));
                        if (XmlUtil.getText((Element)itemDevice, (String)"Parental") == null || XmlUtil.getText((Element)itemDevice, (String)"Parental") == "") {
                            deviceChannel.setParental(0);
                        } else {
                            deviceChannel.setParental(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Parental")));
                        }
                        deviceChannel.setParentId(XmlUtil.getText((Element)itemDevice, (String)"ParentID"));
                        if (XmlUtil.getText((Element)itemDevice, (String)"SafetyWay") == null || XmlUtil.getText((Element)itemDevice, (String)"SafetyWay") == "") {
                            deviceChannel.setSafetyWay(0);
                        } else {
                            deviceChannel.setSafetyWay(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"SafetyWay")));
                        }
                        if (XmlUtil.getText((Element)itemDevice, (String)"RegisterWay") == null || XmlUtil.getText((Element)itemDevice, (String)"RegisterWay") == "") {
                            deviceChannel.setRegisterWay(1);
                        } else {
                            deviceChannel.setRegisterWay(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"RegisterWay")));
                        }
                        deviceChannel.setCertNum(XmlUtil.getText((Element)itemDevice, (String)"CertNum"));
                        if (XmlUtil.getText((Element)itemDevice, (String)"Certifiable") == null || XmlUtil.getText((Element)itemDevice, (String)"Certifiable") == "") {
                            deviceChannel.setCertifiable(0);
                        } else {
                            deviceChannel.setCertifiable(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Certifiable")));
                        }
                        if (XmlUtil.getText((Element)itemDevice, (String)"ErrCode") == null || XmlUtil.getText((Element)itemDevice, (String)"ErrCode") == "") {
                            deviceChannel.setErrCode(0);
                        } else {
                            deviceChannel.setErrCode(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"ErrCode")));
                        }
                        deviceChannel.setEndTime(XmlUtil.getText((Element)itemDevice, (String)"EndTime"));
                        deviceChannel.setSecrecy(XmlUtil.getText((Element)itemDevice, (String)"Secrecy"));
                        deviceChannel.setIpAddress(XmlUtil.getText((Element)itemDevice, (String)"IPAddress"));
                        if (XmlUtil.getText((Element)itemDevice, (String)"Port") == null || XmlUtil.getText((Element)itemDevice, (String)"Port") == "") {
                            deviceChannel.setPort(0);
                        } else {
                            deviceChannel.setPort(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Port")));
                        }
                        deviceChannel.setPassword(XmlUtil.getText((Element)itemDevice, (String)"Password"));
                        if (NumericUtil.isDouble((String)XmlUtil.getText((Element)itemDevice, (String)"Longitude"))) {
                            deviceChannel.setLongitude(Double.parseDouble(XmlUtil.getText((Element)itemDevice, (String)"Longitude")));
                        } else {
                            deviceChannel.setLongitude(0.0);
                        }
                        if (NumericUtil.isDouble((String)XmlUtil.getText((Element)itemDevice, (String)"Latitude"))) {
                            deviceChannel.setLatitude(Double.parseDouble(XmlUtil.getText((Element)itemDevice, (String)"Latitude")));
                        } else {
                            deviceChannel.setLatitude(0.0);
                        }
                        if (XmlUtil.getText((Element)itemDevice, (String)"PTZType") == null || XmlUtil.getText((Element)itemDevice, (String)"PTZType") == "") {
                            deviceChannel.setPTZType(0);
                        } else {
                            deviceChannel.setPTZType(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"PTZType")));
                        }
                        deviceChannel.setHasAudio(true);
                        this.storager.updateChannel(device.getDeviceId(), deviceChannel);
                    }
                    RequestMessage msg = new RequestMessage();
                    msg.setKey(key);
                    msg.setData((Object)device);
                    this.deferredResultHolder.invokeAllResult(msg);
                    this.responseAck(evt, 200);
                    if (this.offLineDetector.isOnline(deviceId)) {
                        this.publisher.onlineEventPublish(device, "3");
                    }
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageAlarm(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406alarm\u8bbe\u5907\u62a5\u8b66\u4fe1\u606f\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            Element rootElement = this.getRootElement(evt, device.getCharset());
            Element deviceIdElement = rootElement.element("DeviceID");
            String channelId = deviceIdElement.getText().toString();
            String key = "CALLBACK_ALARM" + deviceId + channelId;
            this.responseAck(evt, 200);
            if (device.getCharset() != null) {
                rootElement = this.getRootElement(evt, device.getCharset());
            }
            if (rootElement.getName().equals("Notify")) {
                DeviceAlarm deviceAlarm = new DeviceAlarm();
                deviceAlarm.setDeviceId(deviceId);
                deviceAlarm.setChannelId(channelId);
                deviceAlarm.setAlarmPriority(XmlUtil.getText((Element)rootElement, (String)"AlarmPriority"));
                deviceAlarm.setAlarmMethod(XmlUtil.getText((Element)rootElement, (String)"AlarmMethod"));
                deviceAlarm.setAlarmTime(XmlUtil.getText((Element)rootElement, (String)"AlarmTime"));
                if (XmlUtil.getText((Element)rootElement, (String)"AlarmDescription") == null) {
                    deviceAlarm.setAlarmDescription("");
                } else {
                    deviceAlarm.setAlarmDescription(XmlUtil.getText((Element)rootElement, (String)"AlarmDescription"));
                }
                if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Longitude"))) {
                    deviceAlarm.setLongitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Longitude")));
                } else {
                    deviceAlarm.setLongitude(0.0);
                }
                if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Latitude"))) {
                    deviceAlarm.setLatitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Latitude")));
                } else {
                    deviceAlarm.setLatitude(0.0);
                }
                if (!StringUtils.isEmpty((Object)deviceAlarm.getAlarmMethod()) && deviceAlarm.getAlarmMethod().equals("4")) {
                    MobilePosition mobilePosition = new MobilePosition();
                    mobilePosition.setDeviceId(deviceAlarm.getDeviceId());
                    mobilePosition.setTime(deviceAlarm.getAlarmTime());
                    mobilePosition.setLongitude(deviceAlarm.getLongitude());
                    mobilePosition.setLatitude(deviceAlarm.getLatitude());
                    mobilePosition.setReportSource("GPS Alarm");
                    BaiduPoint bp = new BaiduPoint();
                    bp = GpsUtil.Wgs84ToBd09((String)String.valueOf(mobilePosition.getLongitude()), (String)String.valueOf(mobilePosition.getLatitude()));
                    logger.info("\u767e\u5ea6\u5750\u6807\uff1a" + bp.getBdLng() + ", " + bp.getBdLat());
                    mobilePosition.setGeodeticSystem("BD-09");
                    mobilePosition.setCnLng(bp.getBdLng());
                    mobilePosition.setCnLat(bp.getBdLat());
                    if (!this.userSetup.getSavePositionHistory().booleanValue()) {
                        this.storager.clearMobilePositionsByDeviceId(deviceId);
                    }
                    this.storager.insertMobilePosition(mobilePosition);
                }
                logger.debug("\u5b58\u50a8\u62a5\u8b66\u4fe1\u606f\u3001\u62a5\u8b66\u5206\u7c7b");
                this.deviceAlarmService.add(deviceAlarm);
                if (this.offLineDetector.isOnline(deviceId)) {
                    this.publisher.deviceAlarmEventPublish(deviceAlarm);
                }
            } else if (rootElement.getName().equals("Response")) {
                JSONObject json = new JSONObject();
                XmlUtil.node2Json((Element)rootElement, (JSONObject)json);
                if (logger.isDebugEnabled()) {
                    logger.debug(json.toJSONString());
                }
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)json);
                this.deferredResultHolder.invokeAllResult(msg);
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageKeepAlive(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            Element rootElement = this.getRootElement(evt);
            String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
            if (device != null) {
                this.responseAck(evt, 200);
                this.publisher.onlineEventPublish(device, "2");
            } else {
                logger.warn("\u6536\u5230[ " + deviceId + " ]\u5fc3\u8df3\u4fe1\u606f, \u4f46\u662f\u8bbe\u5907\u4e0d\u5b58\u5728, \u56de\u590d404");
                Response response = this.getMessageFactory().createResponse(404, evt.getRequest());
                ServerTransaction serverTransaction = this.getServerTransaction(evt);
                serverTransaction.sendResponse(response);
                if (serverTransaction.getDialog() != null) {
                    serverTransaction.getDialog().delete();
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageRecordInfo(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406DeviceInfo\u8bbe\u5907\u4fe1\u606fMessage\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            this.responseAck(evt, 200);
            String uuid = UUID.randomUUID().toString().replace("-", "");
            RecordInfo recordInfo = new RecordInfo();
            Element rootElement = this.getRootElement(evt);
            Element deviceIdElement = rootElement.element("DeviceID");
            String channelId = deviceIdElement.getText().toString();
            String key = "CALLBACK_RECORDINFO" + deviceId + channelId;
            if (device != null) {
                rootElement = this.getRootElement(evt, device.getCharset());
            }
            recordInfo.setDeviceId(deviceId);
            recordInfo.setChannelId(channelId);
            recordInfo.setName(XmlUtil.getText((Element)rootElement, (String)"Name"));
            if (XmlUtil.getText((Element)rootElement, (String)"SumNum") == null || XmlUtil.getText((Element)rootElement, (String)"SumNum") == "") {
                recordInfo.setSumNum(0);
            } else {
                recordInfo.setSumNum(Integer.parseInt(XmlUtil.getText((Element)rootElement, (String)"SumNum")));
            }
            String sn = XmlUtil.getText((Element)rootElement, (String)"SN");
            Element recordListElement = rootElement.element("RecordList");
            if (recordListElement == null || recordInfo.getSumNum() == 0) {
                logger.info("\u65e0\u5f55\u50cf\u6570\u636e");
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)recordInfo);
                this.deferredResultHolder.invokeAllResult(msg);
            } else {
                Iterator recordListIterator = recordListElement.elementIterator();
                ArrayList<RecordItem> recordList = new ArrayList<RecordItem>();
                if (recordListIterator != null) {
                    RecordItem record = new RecordItem();
                    logger.info("\u5904\u7406\u5f55\u50cf\u5217\u8868\u6570\u636e...");
                    while (recordListIterator.hasNext()) {
                        Element itemRecord = (Element)recordListIterator.next();
                        Element recordElement = itemRecord.element("DeviceID");
                        if (recordElement == null) {
                            logger.info("\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4e0b\u4e00\u4e2a...");
                            continue;
                        }
                        record = new RecordItem();
                        record.setDeviceId(XmlUtil.getText((Element)itemRecord, (String)"DeviceID"));
                        record.setName(XmlUtil.getText((Element)itemRecord, (String)"Name"));
                        record.setFilePath(XmlUtil.getText((Element)itemRecord, (String)"FilePath"));
                        record.setAddress(XmlUtil.getText((Element)itemRecord, (String)"Address"));
                        record.setStartTime(DateUtil.ISO8601Toyyyy_MM_dd_HH_mm_ss((String)XmlUtil.getText((Element)itemRecord, (String)"StartTime")));
                        record.setEndTime(DateUtil.ISO8601Toyyyy_MM_dd_HH_mm_ss((String)XmlUtil.getText((Element)itemRecord, (String)"EndTime")));
                        record.setSecrecy(itemRecord.element("Secrecy") == null ? 0 : Integer.parseInt(XmlUtil.getText((Element)itemRecord, (String)"Secrecy")));
                        record.setType(XmlUtil.getText((Element)itemRecord, (String)"Type"));
                        record.setRecorderId(XmlUtil.getText((Element)itemRecord, (String)"RecorderID"));
                        recordList.add(record);
                    }
                    recordInfo.setRecordList(recordList);
                }
                String cacheKey = CACHE_RECORDINFO_KEY + deviceId + sn;
                this.redis.set(cacheKey + "_" + uuid, recordList, 90L);
                if (!threadNameList.contains(cacheKey)) {
                    threadNameList.add(cacheKey);
                    CheckForAllRecordsThread chk = new CheckForAllRecordsThread(cacheKey, recordInfo);
                    chk.setName(cacheKey);
                    chk.setDeferredResultHolder(this.deferredResultHolder);
                    chk.setRedis(this.redis);
                    chk.setLogger(logger);
                    chk.start();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Start Thread " + cacheKey + ".");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Thread " + cacheKey + " already started.");
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageMediaStatus(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406DeviceInfo\u8bbe\u5907\u4fe1\u606fMessage\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            this.responseAck(evt, 200);
            Element rootElement = this.getRootElement(evt);
            String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
            String NotifyType = XmlUtil.getText((Element)rootElement, (String)"NotifyType");
            if (NotifyType.equals("121")) {
                logger.info("\u5a92\u4f53\u64ad\u653e\u5b8c\u6bd5\uff0c\u901a\u77e5\u5173\u6d41");
                StreamInfo streamInfo = this.redisCatchStorage.queryPlaybackByDevice(deviceId, "*");
                if (streamInfo != null) {
                    this.redisCatchStorage.stopPlayback(streamInfo);
                    this.cmder.streamByeCmd(streamInfo.getDeviceID(), streamInfo.getChannelId());
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processMessageBroadcast(RequestEvent evt) {
        try {
            String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                logger.warn("\u5904\u7406DeviceInfo\u8bbe\u5907\u4fe1\u606fMessage\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
                this.responseAck(evt, 404);
                return;
            }
            Element rootElement = this.getRootElement(evt);
            String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
            String key = "CALLBACK_BROADCAST" + deviceId + channelId;
            this.responseAck(evt, 200);
            if (rootElement.getName().equals("Response")) {
                JSONObject json = new JSONObject();
                XmlUtil.node2Json((Element)rootElement, (JSONObject)json);
                if (logger.isDebugEnabled()) {
                    logger.debug(json.toJSONString());
                }
                RequestMessage msg = new RequestMessage();
                msg.setKey(key);
                msg.setData((Object)json);
                this.deferredResultHolder.invokeAllResult(msg);
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }
}

