/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.bean.GbStream;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.SendRtpItem;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommanderFroPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.media.zlm.ZLMRTPServerFactory;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IPlayService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.vmanager.gb28181.play.bean.PlayResult;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import java.text.ParseException;
import java.util.Vector;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InviteRequestProcessor
extends SIPRequestProcessorParent
implements InitializingBean,
ISIPRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(InviteRequestProcessor.class);
    private String method = "INVITE";
    @Autowired
    private SIPCommanderFroPlatform cmderFroPlatform;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IPlayService playService;
    @Autowired
    private ZLMRTPServerFactory zlmrtpServerFactory;
    @Autowired
    private IMediaServerService mediaServerService;
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addRequestProcessor(this.method, (ISIPRequestProcessor)this);
    }

    public void process(RequestEvent evt) {
        try {
            Request request = evt.getRequest();
            SipURI sipURI = (SipURI)request.getRequestURI();
            String channelId = sipURI.getUser();
            String requesterId = null;
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            AddressImpl address = (AddressImpl)fromHeader.getAddress();
            SipUri uri = (SipUri)address.getURI();
            requesterId = uri.getUser();
            if (requesterId == null || channelId == null) {
                logger.info("\u65e0\u6cd5\u4eceFromHeader\u7684Address\u4e2d\u83b7\u53d6\u5230\u5e73\u53f0id\uff0c\u8fd4\u56de400");
                this.responseAck(evt, 400);
                return;
            }
            ParentPlatform platform = this.storager.queryParentPlatByServerGBId(requesterId);
            if (platform != null) {
                SendRtpItem sendRtpItem;
                DeviceChannel channel = this.storager.queryChannelInParentPlatform(requesterId, channelId);
                GbStream gbStream = this.storager.queryStreamInParentPlatform(requesterId, channelId);
                MediaServerItem mediaServerItem = null;
                if (channel != null && gbStream == null) {
                    if (channel.getStatus() == 0) {
                        logger.info("\u901a\u9053\u79bb\u7ebf\uff0c\u8fd4\u56de400");
                        this.responseAck(evt, 400, "channel [" + channel.getChannelId() + "] offline");
                        return;
                    }
                    this.responseAck(evt, 181);
                } else if (channel == null && gbStream != null) {
                    String mediaServerId = gbStream.getMediaServerId();
                    mediaServerItem = this.mediaServerService.getOne(mediaServerId);
                    if (mediaServerItem == null) {
                        logger.info("[ app={}, stream={} ]\u627e\u4e0d\u5230zlm {}\uff0c\u8fd4\u56de410", new Object[]{gbStream.getApp(), gbStream.getStream(), mediaServerId});
                        this.responseAck(evt, 410, "media server not found");
                        return;
                    }
                    Boolean streamReady = this.zlmrtpServerFactory.isStreamReady(mediaServerItem, gbStream.getApp(), gbStream.getStream());
                    if (!streamReady.booleanValue()) {
                        logger.info("[ app={}, stream={} ]\u901a\u9053\u79bb\u7ebf\uff0c\u8fd4\u56de400", (Object)gbStream.getApp(), (Object)gbStream.getStream());
                        this.responseAck(evt, 400, "channel [" + gbStream.getGbId() + "] offline");
                        return;
                    }
                    this.responseAck(evt, 181);
                } else {
                    logger.info("\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de404");
                    this.responseAck(evt, 404);
                    return;
                }
                String contentString = new String(request.getRawContent());
                int ssrcIndex = contentString.indexOf("y=");
                String ssrc = contentString.substring(ssrcIndex + 2, ssrcIndex + 12);
                String substring = contentString.substring(0, contentString.indexOf("y="));
                SessionDescription sdp = SdpFactory.getInstance().createSessionDescription(substring);
                Vector mediaDescriptions = sdp.getMediaDescriptions(true);
                int port = -1;
                boolean mediaTransmissionTCP = false;
                Boolean tcpActive = null;
                for (Object description : mediaDescriptions) {
                    String setup;
                    MediaDescription mediaDescription = (MediaDescription)description;
                    Media media = mediaDescription.getMedia();
                    Vector mediaFormats = media.getMediaFormats(false);
                    if (!mediaFormats.contains("96")) continue;
                    port = media.getMediaPort();
                    String protocol = media.getProtocol();
                    if (!"TCP/RTP/AVP".equals(protocol) || (setup = mediaDescription.getAttribute("setup")) == null) break;
                    mediaTransmissionTCP = true;
                    if ("active".equals(setup)) {
                        tcpActive = true;
                        break;
                    }
                    if (!"passive".equals(setup)) break;
                    tcpActive = false;
                    break;
                }
                if (port == -1) {
                    logger.info("\u4e0d\u652f\u6301\u7684\u5a92\u4f53\u683c\u5f0f\uff0c\u8fd4\u56de415");
                    this.responseAck(evt, 415);
                    return;
                }
                String username = sdp.getOrigin().getUsername();
                String addressStr = sdp.getOrigin().getAddress();
                logger.info("[\u4e0a\u7ea7\u70b9\u64ad]\u7528\u6237\uff1a{}\uff0c \u5730\u5740\uff1a{}:{}\uff0c ssrc\uff1a{}", new Object[]{username, addressStr, port, ssrc});
                Device device = null;
                if (channel != null) {
                    device = this.storager.queryVideoDeviceByPlatformIdAndChannelId(requesterId, channelId);
                    if (device == null) {
                        logger.warn("\u70b9\u64ad\u5e73\u53f0{}\u7684\u901a\u9053{}\u65f6\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f", (Object)requesterId, (Object)channel);
                        this.responseAck(evt, 500);
                        return;
                    }
                    mediaServerItem = this.playService.getNewMediaServerItem(device);
                    if (mediaServerItem == null) {
                        logger.warn("\u672a\u627e\u5230\u53ef\u7528\u7684zlm");
                        this.responseAck(evt, 486);
                        return;
                    }
                    sendRtpItem = this.zlmrtpServerFactory.createSendRtpItem(mediaServerItem, addressStr, port, ssrc, requesterId, device.getDeviceId(), channelId, mediaTransmissionTCP);
                    if (tcpActive != null) {
                        sendRtpItem.setTcpActive(tcpActive.booleanValue());
                    }
                    if (sendRtpItem == null) {
                        logger.warn("\u670d\u52a1\u5668\u7aef\u53e3\u8d44\u6e90\u4e0d\u8db3");
                        this.responseAck(evt, 486);
                        return;
                    }
                    this.redisCatchStorage.updateSendRTPSever(sendRtpItem);
                    PlayResult playResult = this.playService.play(mediaServerItem, device.getDeviceId(), channelId, (mediaServerItemInUSe, responseJSON) -> {
                        sendRtpItem.setStatus(1);
                        this.redisCatchStorage.updateSendRTPSever(sendRtpItem);
                        StringBuffer content = new StringBuffer(200);
                        content.append("v=0\r\n");
                        content.append("o=" + channelId + " 0 0 IN IP4 " + mediaServerItemInUSe.getSdpIp() + "\r\n");
                        content.append("s=Play\r\n");
                        content.append("c=IN IP4 " + mediaServerItemInUSe.getSdpIp() + "\r\n");
                        content.append("t=0 0\r\n");
                        content.append("m=video " + sendRtpItem.getLocalPort() + " RTP/AVP 96\r\n");
                        content.append("a=sendonly\r\n");
                        content.append("a=rtpmap:96 PS/90000\r\n");
                        content.append("y=" + ssrc + "\r\n");
                        content.append("f=\r\n");
                        try {
                            this.responseAck(evt, content.toString());
                        }
                        catch (SipException e) {
                            e.printStackTrace();
                        }
                        catch (InvalidArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }, event -> {
                        Response response = null;
                        try {
                            response = this.getMessageFactory().createResponse(event.statusCode, evt.getRequest());
                            ServerTransaction serverTransaction = this.getServerTransaction(evt);
                            serverTransaction.sendResponse(response);
                            if (serverTransaction.getDialog() != null) {
                                serverTransaction.getDialog().delete();
                            }
                        }
                        catch (ParseException | InvalidArgumentException | SipException e) {
                            e.printStackTrace();
                        }
                    });
                    if (logger.isDebugEnabled()) {
                        logger.debug(playResult.getResult().toString());
                    }
                } else if (gbStream != null) {
                    sendRtpItem = this.zlmrtpServerFactory.createSendRtpItem(mediaServerItem, addressStr, port, ssrc, requesterId, gbStream.getApp(), gbStream.getStream(), channelId, mediaTransmissionTCP);
                    if (tcpActive != null) {
                        sendRtpItem.setTcpActive(tcpActive.booleanValue());
                    }
                    if (sendRtpItem == null) {
                        logger.warn("\u670d\u52a1\u5668\u7aef\u53e3\u8d44\u6e90\u4e0d\u8db3");
                        this.responseAck(evt, 486);
                        return;
                    }
                    this.redisCatchStorage.updateSendRTPSever(sendRtpItem);
                    sendRtpItem.setStatus(1);
                    this.redisCatchStorage.updateSendRTPSever(sendRtpItem);
                    StringBuffer content = new StringBuffer(200);
                    content.append("v=0\r\n");
                    content.append("o=" + channelId + " 0 0 IN IP4 " + mediaServerItem.getSdpIp() + "\r\n");
                    content.append("s=Play\r\n");
                    content.append("c=IN IP4 " + mediaServerItem.getSdpIp() + "\r\n");
                    content.append("t=0 0\r\n");
                    content.append("m=video " + sendRtpItem.getLocalPort() + " RTP/AVP 96\r\n");
                    content.append("a=sendonly\r\n");
                    content.append("a=rtpmap:96 PS/90000\r\n");
                    content.append("y=" + ssrc + "\r\n");
                    content.append("f=\r\n");
                    try {
                        this.responseAck(evt, content.toString());
                    }
                    catch (SipException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Device device = this.storager.queryVideoDevice(requesterId);
                if (device != null) {
                    String contentString;
                    logger.info("\u6536\u5230\u8bbe\u5907" + requesterId + "\u7684\u8bed\u97f3\u5e7f\u64adInvite\u8bf7\u6c42");
                    this.responseAck(evt, 100);
                    String substring = contentString = new String(request.getRawContent());
                    String ssrc = "0000000404";
                    int ssrcIndex = contentString.indexOf("y=");
                    if (ssrcIndex > 0) {
                        substring = contentString.substring(0, ssrcIndex);
                        ssrc = contentString.substring(ssrcIndex + 2, ssrcIndex + 12);
                    }
                    if ((ssrcIndex = substring.indexOf("f=")) > 0) {
                        substring = contentString.substring(0, ssrcIndex);
                    }
                    SessionDescription sdp = SdpFactory.getInstance().createSessionDescription(substring);
                    Vector mediaDescriptions = sdp.getMediaDescriptions(true);
                    int port = -1;
                    boolean mediaTransmissionTCP = false;
                    Boolean tcpActive = null;
                    for (int i = 0; i < mediaDescriptions.size(); ++i) {
                        String setup;
                        MediaDescription mediaDescription = (MediaDescription)mediaDescriptions.get(i);
                        Media media = mediaDescription.getMedia();
                        Vector mediaFormats = media.getMediaFormats(false);
                        if (!mediaFormats.contains("8")) continue;
                        port = media.getMediaPort();
                        String protocol = media.getProtocol();
                        if (!"TCP/RTP/AVP".equals(protocol) || (setup = mediaDescription.getAttribute("setup")) == null) break;
                        mediaTransmissionTCP = true;
                        if ("active".equals(setup)) {
                            tcpActive = true;
                            break;
                        }
                        if (!"passive".equals(setup)) break;
                        tcpActive = false;
                        break;
                    }
                    if (port == -1) {
                        logger.info("\u4e0d\u652f\u6301\u7684\u5a92\u4f53\u683c\u5f0f\uff0c\u8fd4\u56de415");
                        this.responseAck(evt, 415);
                        return;
                    }
                    String username = sdp.getOrigin().getUsername();
                    String addressStr = sdp.getOrigin().getAddress();
                    logger.info("\u8bbe\u5907{}\u8bf7\u6c42\u8bed\u97f3\u6d41\uff0c\u5730\u5740\uff1a{}:{}\uff0cssrc\uff1a{}", new Object[]{username, addressStr, port, ssrc});
                } else {
                    logger.warn("\u6765\u81ea\u65e0\u6548\u8bbe\u5907/\u5e73\u53f0\u7684\u8bf7\u6c42");
                    this.responseAck(evt, 400);
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            logger.warn("sdp\u89e3\u6790\u9519\u8bef");
            e.printStackTrace();
        }
        catch (SdpParseException e) {
            e.printStackTrace();
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
    }
}

