/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl;

import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.SendRtpItem;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.ISIPCommander;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.media.zlm.ZLMRTPServerFactory;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import java.text.ParseException;
import java.util.HashMap;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.address.SipURI;
import javax.sip.header.HeaderAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ByeRequestProcessor
extends SIPRequestProcessorParent
implements InitializingBean,
ISIPRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(ByeRequestProcessor.class);
    private final String method = "BYE";
    @Autowired
    private ISIPCommander cmder;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private ZLMRTPServerFactory zlmrtpServerFactory;
    @Autowired
    private IMediaServerService mediaServerService;
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addRequestProcessor("BYE", (ISIPRequestProcessor)this);
    }

    public void process(RequestEvent evt) {
        try {
            this.responseAck(evt, 200);
            Dialog dialog = evt.getDialog();
            if (dialog == null) {
                return;
            }
            if (dialog.getState().equals((Object)DialogState.TERMINATED)) {
                Device device;
                String platformGbId = ((SipURI)((HeaderAddress)evt.getRequest().getHeader("From")).getAddress().getURI()).getUser();
                String channelId = ((SipURI)((HeaderAddress)evt.getRequest().getHeader("To")).getAddress().getURI()).getUser();
                SendRtpItem sendRtpItem = this.redisCatchStorage.querySendRTPServer(platformGbId, channelId);
                this.logger.info("\u6536\u5230bye, [{}/{}]", (Object)platformGbId, (Object)channelId);
                if (sendRtpItem != null) {
                    String streamId = sendRtpItem.getStreamId();
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("vhost", "__defaultVhost__");
                    param.put("app", sendRtpItem.getApp());
                    param.put("stream", streamId);
                    param.put("ssrc", sendRtpItem.getSsrc());
                    this.logger.info("\u505c\u6b62\u5411\u4e0a\u7ea7\u63a8\u6d41\uff1a" + streamId);
                    MediaServerItem mediaInfo = this.mediaServerService.getOne(sendRtpItem.getMediaServerId());
                    this.zlmrtpServerFactory.stopSendRtpStream(mediaInfo, param);
                    this.redisCatchStorage.deleteSendRTPServer(platformGbId, channelId);
                    if (this.zlmrtpServerFactory.totalReaderCount(mediaInfo, sendRtpItem.getApp(), streamId) == 0) {
                        this.logger.info(streamId + "\u65e0\u5176\u5b83\u89c2\u770b\u8005\uff0c\u901a\u77e5\u8bbe\u5907\u505c\u6b62\u63a8\u6d41");
                        this.cmder.streamByeCmd(sendRtpItem.getDeviceId(), channelId);
                    }
                }
                if ((device = this.storager.queryVideoDeviceByChannelId(platformGbId)) != null) {
                    StreamInfo streamInfo = this.redisCatchStorage.queryPlayByDevice(device.getDeviceId(), channelId);
                    if (streamInfo != null) {
                        this.redisCatchStorage.stopPlay(streamInfo);
                    }
                    this.storager.stopPlay(device.getDeviceId(), channelId);
                    this.mediaServerService.closeRTPServer(device, channelId);
                }
            }
        }
        catch (SipException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

