/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.cmd.impl;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.SsrcTransaction;
import com.genersoft.iot.vmp.gb28181.event.SipSubscribe;
import com.genersoft.iot.vmp.gb28181.session.VideoStreamSessionManager;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.ISIPCommander;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.SIPRequestHeaderProvider;
import com.genersoft.iot.vmp.gb28181.utils.DateUtil;
import com.genersoft.iot.vmp.gb28181.utils.NumericUtil;
import com.genersoft.iot.vmp.media.zlm.ZLMHttpHookSubscribe;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.bean.SSRCInfo;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.SIPDialog;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.HashSet;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.SipStack;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@DependsOn(value={"sipLayer"})
public class SIPCommander
implements ISIPCommander {
    private final Logger logger = LoggerFactory.getLogger(SIPCommander.class);
    @Autowired
    private SipConfig sipConfig;
    @Autowired
    @Qualifier(value="tcpSipProvider")
    private SipProviderImpl tcpSipProvider;
    @Autowired
    @Qualifier(value="udpSipProvider")
    private SipProviderImpl udpSipProvider;
    @Autowired
    private SIPRequestHeaderProvider headerProvider;
    @Autowired
    private VideoStreamSessionManager streamSession;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private UserSetup userSetup;
    @Autowired
    private ZLMHttpHookSubscribe subscribe;
    @Autowired
    private SipSubscribe sipSubscribe;
    @Autowired
    private IMediaServerService mediaServerService;

    public boolean ptzdirectCmd(Device device, String channelId, int leftRight, int upDown) {
        return this.ptzCmd(device, channelId, leftRight, upDown, 0, this.sipConfig.getPtzSpeed().intValue(), 0);
    }

    public boolean ptzdirectCmd(Device device, String channelId, int leftRight, int upDown, int moveSpeed) {
        return this.ptzCmd(device, channelId, leftRight, upDown, 0, moveSpeed, 0);
    }

    public boolean ptzZoomCmd(Device device, String channelId, int inOut) {
        return this.ptzCmd(device, channelId, 0, 0, inOut, 0, this.sipConfig.getPtzSpeed().intValue());
    }

    public boolean ptzZoomCmd(Device device, String channelId, int inOut, int zoomSpeed) {
        return this.ptzCmd(device, channelId, 0, 0, inOut, 0, zoomSpeed);
    }

    public static String cmdString(int leftRight, int upDown, int inOut, int moveSpeed, int zoomSpeed) {
        int cmdCode = 0;
        if (leftRight == 2) {
            cmdCode |= 1;
        } else if (leftRight == 1) {
            cmdCode |= 2;
        }
        if (upDown == 2) {
            cmdCode |= 4;
        } else if (upDown == 1) {
            cmdCode |= 8;
        }
        if (inOut == 2) {
            cmdCode |= 0x10;
        } else if (inOut == 1) {
            cmdCode |= 0x20;
        }
        StringBuilder builder = new StringBuilder("A50F01");
        String strTmp = String.format("%02X", cmdCode);
        builder.append(strTmp, 0, 2);
        strTmp = String.format("%02X", moveSpeed);
        builder.append(strTmp, 0, 2);
        builder.append(strTmp, 0, 2);
        strTmp = String.format("%X", zoomSpeed);
        builder.append(strTmp, 0, 1).append("0");
        int checkCode = (181 + cmdCode + moveSpeed + moveSpeed + (zoomSpeed & 0xF0)) % 256;
        strTmp = String.format("%02X", checkCode);
        builder.append(strTmp, 0, 2);
        return builder.toString();
    }

    public static String frontEndCmdString(int cmdCode, int parameter1, int parameter2, int combineCode2) {
        StringBuilder builder = new StringBuilder("A50F01");
        String strTmp = String.format("%02X", cmdCode);
        builder.append(strTmp, 0, 2);
        strTmp = String.format("%02X", parameter1);
        builder.append(strTmp, 0, 2);
        strTmp = String.format("%02X", parameter2);
        builder.append(strTmp, 0, 2);
        strTmp = String.format("%X", combineCode2);
        builder.append(strTmp, 0, 1).append("0");
        int checkCode = (181 + cmdCode + parameter1 + parameter2 + (combineCode2 & 0xF0)) % 256;
        strTmp = String.format("%02X", checkCode);
        builder.append(strTmp, 0, 2);
        return builder.toString();
    }

    public boolean ptzCmd(Device device, String channelId, int leftRight, int upDown, int inOut, int moveSpeed, int zoomSpeed) {
        try {
            String cmdStr = SIPCommander.cmdString((int)leftRight, (int)upDown, (int)inOut, (int)moveSpeed, (int)zoomSpeed);
            StringBuffer ptzXml = new StringBuffer(200);
            ptzXml.append("<?xml version=\"1.0\" ?>\r\n");
            ptzXml.append("<Control>\r\n");
            ptzXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            ptzXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            ptzXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            ptzXml.append("<PTZCmd>" + cmdStr + "</PTZCmd>\r\n");
            ptzXml.append("<Info>\r\n");
            ptzXml.append("</Info>\r\n");
            ptzXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, ptzXml.toString(), "z9hG4bK-ViaPtz-" + tm, "FromPtz" + tm, null, callIdHeader);
            this.transmitRequest(device, request);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean frontEndCmd(Device device, String channelId, int cmdCode, int parameter1, int parameter2, int combineCode2) {
        try {
            String cmdStr = SIPCommander.frontEndCmdString((int)cmdCode, (int)parameter1, (int)parameter2, (int)combineCode2);
            this.logger.info("\u63a7\u5236\u5b57\u7b26\u4e32\uff1a" + cmdStr);
            StringBuffer ptzXml = new StringBuffer(200);
            ptzXml.append("<?xml version=\"1.0\" ?>\r\n");
            ptzXml.append("<Control>\r\n");
            ptzXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            ptzXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            ptzXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            ptzXml.append("<PTZCmd>" + cmdStr + "</PTZCmd>\r\n");
            ptzXml.append("<Info>\r\n");
            ptzXml.append("</Info>\r\n");
            ptzXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, ptzXml.toString(), "z9hG4bK-ViaPtz-" + tm, "FromPtz" + tm, null, callIdHeader);
            this.transmitRequest(device, request);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean fronEndCmd(Device device, String channelId, String cmdString) {
        try {
            StringBuffer ptzXml = new StringBuffer(200);
            ptzXml.append("<?xml version=\"1.0\" ?>\r\n");
            ptzXml.append("<Control>\r\n");
            ptzXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            ptzXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            ptzXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            ptzXml.append("<PTZCmd>" + cmdString + "</PTZCmd>\r\n");
            ptzXml.append("<Info>\r\n");
            ptzXml.append("</Info>\r\n");
            ptzXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, ptzXml.toString(), "z9hG4bK-ViaPtz-" + tm, "FromPtz" + tm, null, callIdHeader);
            this.transmitRequest(device, request);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void playStreamCmd(MediaServerItem mediaServerItem, SSRCInfo ssrcInfo, Device device, String channelId, ZLMHttpHookSubscribe.Event event, SipSubscribe.Event errorEvent) {
        String streamId = ssrcInfo.getStreamId();
        try {
            if (device == null) {
                return;
            }
            String streamMode = device.getStreamMode().toUpperCase();
            this.logger.info("{} \u5206\u914d\u7684ZLM\u4e3a: {} [{}:{}]", new Object[]{streamId, mediaServerItem.getId(), mediaServerItem.getIp(), ssrcInfo.getPort()});
            JSONObject subscribeKey = new JSONObject();
            subscribeKey.put("app", (Object)"rtp");
            subscribeKey.put("stream", (Object)streamId);
            subscribeKey.put("regist", (Object)true);
            subscribeKey.put("mediaServerId", (Object)mediaServerItem.getId());
            this.subscribe.addSubscribe(ZLMHttpHookSubscribe.HookType.on_stream_changed, subscribeKey, (mediaServerItemInUse, json) -> {
                if (this.userSetup.isWaitTrack().booleanValue() && json.getJSONArray("tracks") == null) {
                    return;
                }
                event.response(mediaServerItemInUse, json);
                this.subscribe.removeSubscribe(ZLMHttpHookSubscribe.HookType.on_stream_changed, subscribeKey);
            });
            StringBuffer content = new StringBuffer(200);
            content.append("v=0\r\n");
            content.append("o=" + this.sipConfig.getId() + " 0 0 IN IP4 " + mediaServerItem.getSdpIp() + "\r\n");
            content.append("s=Play\r\n");
            content.append("c=IN IP4 " + mediaServerItem.getSdpIp() + "\r\n");
            content.append("t=0 0\r\n");
            if (this.userSetup.isSeniorSdp().booleanValue()) {
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 126 125 99 34 98 97\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 126 125 99 34 98 97\r\n");
                } else if ("UDP".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " RTP/AVP 96 126 125 99 34 98 97\r\n");
                }
                content.append("a=recvonly\r\n");
                content.append("a=rtpmap:96 PS/90000\r\n");
                content.append("a=fmtp:126 profile-level-id=42e01e\r\n");
                content.append("a=rtpmap:126 H264/90000\r\n");
                content.append("a=rtpmap:125 H264S/90000\r\n");
                content.append("a=fmtp:125 profile-level-id=42e01e\r\n");
                content.append("a=rtpmap:99 MP4V-ES/90000\r\n");
                content.append("a=fmtp:99 profile-level-id=3\r\n");
                content.append("a=rtpmap:98 H264/90000\r\n");
                content.append("a=rtpmap:97 MPEG4/90000\r\n");
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("a=setup:passive\r\n");
                    content.append("a=connection:new\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("a=setup:active\r\n");
                    content.append("a=connection:new\r\n");
                }
            } else {
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 98 97\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 98 97\r\n");
                } else if ("UDP".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " RTP/AVP 96 98 97\r\n");
                }
                content.append("a=recvonly\r\n");
                content.append("a=rtpmap:96 PS/90000\r\n");
                content.append("a=rtpmap:98 H264/90000\r\n");
                content.append("a=rtpmap:97 MPEG4/90000\r\n");
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("a=setup:passive\r\n");
                    content.append("a=connection:new\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("a=setup:active\r\n");
                    content.append("a=connection:new\r\n");
                }
            }
            content.append("y=" + ssrcInfo.getSsrc() + "\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createInviteRequest(device, channelId, content.toString(), null, "FromInvt" + tm, null, ssrcInfo.getSsrc(), callIdHeader);
            String finalStreamId = streamId;
            this.transmitRequest(device, request, e -> {
                this.streamSession.remove(device.getDeviceId(), channelId);
                this.mediaServerService.releaseSsrc(mediaServerItem, ssrcInfo.getSsrc());
                errorEvent.response(e);
            }, e -> {
                this.streamSession.put(device.getDeviceId(), channelId, ssrcInfo.getSsrc(), finalStreamId, mediaServerItem.getId(), ((ResponseEvent)e.event).getClientTransaction());
                this.streamSession.put(device.getDeviceId(), channelId, e.dialog);
            });
        }
        catch (ParseException | InvalidArgumentException | SipException e2) {
            e2.printStackTrace();
        }
    }

    public void playbackStreamCmd(MediaServerItem mediaServerItem, SSRCInfo ssrcInfo, Device device, String channelId, String startTime, String endTime, ZLMHttpHookSubscribe.Event event, SipSubscribe.Event errorEvent) {
        try {
            this.logger.info("{} \u5206\u914d\u7684ZLM\u4e3a: {} [{}:{}]", new Object[]{ssrcInfo.getStreamId(), mediaServerItem.getId(), mediaServerItem.getIp(), ssrcInfo.getPort()});
            JSONObject subscribeKey = new JSONObject();
            subscribeKey.put("app", (Object)"rtp");
            subscribeKey.put("stream", (Object)ssrcInfo.getStreamId());
            subscribeKey.put("regist", (Object)true);
            subscribeKey.put("mediaServerId", (Object)mediaServerItem.getId());
            this.logger.debug("\u5f55\u50cf\u56de\u653e\u6dfb\u52a0\u8ba2\u9605\uff0c\u8ba2\u9605\u5185\u5bb9\uff1a" + subscribeKey.toString());
            this.subscribe.addSubscribe(ZLMHttpHookSubscribe.HookType.on_stream_changed, subscribeKey, (mediaServerItemInUse, json) -> {
                if (this.userSetup.isWaitTrack().booleanValue() && json.getJSONArray("tracks") == null) {
                    return;
                }
                event.response(mediaServerItemInUse, json);
                this.subscribe.removeSubscribe(ZLMHttpHookSubscribe.HookType.on_stream_changed, subscribeKey);
            });
            StringBuffer content = new StringBuffer(200);
            content.append("v=0\r\n");
            content.append("o=" + this.sipConfig.getId() + " 0 0 IN IP4 " + mediaServerItem.getSdpIp() + "\r\n");
            content.append("s=Playback\r\n");
            content.append("u=" + channelId + ":0\r\n");
            content.append("c=IN IP4 " + mediaServerItem.getSdpIp() + "\r\n");
            content.append("t=" + DateUtil.yyyy_MM_dd_HH_mm_ssToTimestamp((String)startTime) + " " + DateUtil.yyyy_MM_dd_HH_mm_ssToTimestamp((String)endTime) + "\r\n");
            String streamMode = device.getStreamMode().toUpperCase();
            if (this.userSetup.isSeniorSdp().booleanValue()) {
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 126 125 99 34 98 97\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 126 125 99 34 98 97\r\n");
                } else if ("UDP".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " RTP/AVP 96 126 125 99 34 98 97\r\n");
                }
                content.append("a=recvonly\r\n");
                content.append("a=rtpmap:96 PS/90000\r\n");
                content.append("a=fmtp:126 profile-level-id=42e01e\r\n");
                content.append("a=rtpmap:126 H264/90000\r\n");
                content.append("a=rtpmap:125 H264S/90000\r\n");
                content.append("a=fmtp:125 profile-level-id=42e01e\r\n");
                content.append("a=rtpmap:99 MP4V-ES/90000\r\n");
                content.append("a=fmtp:99 profile-level-id=3\r\n");
                content.append("a=rtpmap:98 H264/90000\r\n");
                content.append("a=rtpmap:97 MPEG4/90000\r\n");
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("a=setup:passive\r\n");
                    content.append("a=connection:new\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("a=setup:active\r\n");
                    content.append("a=connection:new\r\n");
                }
            } else {
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 98 97\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 98 97\r\n");
                } else if ("UDP".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " RTP/AVP 96 98 97\r\n");
                }
                content.append("a=recvonly\r\n");
                content.append("a=rtpmap:96 PS/90000\r\n");
                content.append("a=rtpmap:98 H264/90000\r\n");
                content.append("a=rtpmap:97 MPEG4/90000\r\n");
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("a=setup:passive\r\n");
                    content.append("a=connection:new\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("a=setup:active\r\n");
                    content.append("a=connection:new\r\n");
                }
            }
            content.append("y=" + ssrcInfo.getSsrc() + "\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createPlaybackInviteRequest(device, channelId, content.toString(), null, "fromplybck" + tm, null, callIdHeader, ssrcInfo.getSsrc());
            this.transmitRequest(device, request, errorEvent, okEvent -> {
                ResponseEvent responseEvent = (ResponseEvent)okEvent.event;
                this.streamSession.put(device.getDeviceId(), channelId, ssrcInfo.getSsrc(), ssrcInfo.getStreamId(), mediaServerItem.getId(), responseEvent.getClientTransaction());
                this.streamSession.put(device.getDeviceId(), channelId, okEvent.dialog);
            });
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
        }
    }

    public void downloadStreamCmd(MediaServerItem mediaServerItem, SSRCInfo ssrcInfo, Device device, String channelId, String startTime, String endTime, String downloadSpeed, ZLMHttpHookSubscribe.Event event, SipSubscribe.Event errorEvent) {
        try {
            this.logger.info("{} \u5206\u914d\u7684ZLM\u4e3a: {} [{}:{}]", new Object[]{ssrcInfo.getStreamId(), mediaServerItem.getId(), mediaServerItem.getIp(), ssrcInfo.getPort()});
            JSONObject subscribeKey = new JSONObject();
            subscribeKey.put("app", (Object)"rtp");
            subscribeKey.put("stream", (Object)ssrcInfo.getStreamId());
            subscribeKey.put("regist", (Object)true);
            subscribeKey.put("mediaServerId", (Object)mediaServerItem.getId());
            this.logger.debug("\u5f55\u50cf\u56de\u653e\u6dfb\u52a0\u8ba2\u9605\uff0c\u8ba2\u9605\u5185\u5bb9\uff1a" + subscribeKey.toString());
            this.subscribe.addSubscribe(ZLMHttpHookSubscribe.HookType.on_stream_changed, subscribeKey, (mediaServerItemInUse, json) -> {
                if (this.userSetup.isWaitTrack().booleanValue() && json.getJSONArray("tracks") == null) {
                    return;
                }
                event.response(mediaServerItemInUse, json);
                this.subscribe.removeSubscribe(ZLMHttpHookSubscribe.HookType.on_stream_changed, subscribeKey);
            });
            StringBuffer content = new StringBuffer(200);
            content.append("v=0\r\n");
            content.append("o=" + this.sipConfig.getId() + " 0 0 IN IP4 " + mediaServerItem.getSdpIp() + "\r\n");
            content.append("s=Download\r\n");
            content.append("u=" + channelId + ":0\r\n");
            content.append("c=IN IP4 " + mediaServerItem.getSdpIp() + "\r\n");
            content.append("t=" + DateUtil.yyyy_MM_dd_HH_mm_ssToTimestamp((String)startTime) + " " + DateUtil.yyyy_MM_dd_HH_mm_ssToTimestamp((String)endTime) + "\r\n");
            String streamMode = device.getStreamMode().toUpperCase();
            if (this.userSetup.isSeniorSdp().booleanValue()) {
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 126 125 99 34 98 97\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 126 125 99 34 98 97\r\n");
                } else if ("UDP".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " RTP/AVP 96 126 125 99 34 98 97\r\n");
                }
                content.append("a=recvonly\r\n");
                content.append("a=rtpmap:96 PS/90000\r\n");
                content.append("a=fmtp:126 profile-level-id=42e01e\r\n");
                content.append("a=rtpmap:126 H264/90000\r\n");
                content.append("a=rtpmap:125 H264S/90000\r\n");
                content.append("a=fmtp:125 profile-level-id=42e01e\r\n");
                content.append("a=rtpmap:99 MP4V-ES/90000\r\n");
                content.append("a=fmtp:99 profile-level-id=3\r\n");
                content.append("a=rtpmap:98 H264/90000\r\n");
                content.append("a=rtpmap:97 MPEG4/90000\r\n");
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("a=setup:passive\r\n");
                    content.append("a=connection:new\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("a=setup:active\r\n");
                    content.append("a=connection:new\r\n");
                }
            } else {
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 98 97\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " TCP/RTP/AVP 96 98 97\r\n");
                } else if ("UDP".equals(streamMode)) {
                    content.append("m=video " + ssrcInfo.getPort() + " RTP/AVP 96 98 97\r\n");
                }
                content.append("a=recvonly\r\n");
                content.append("a=rtpmap:96 PS/90000\r\n");
                content.append("a=rtpmap:98 H264/90000\r\n");
                content.append("a=rtpmap:97 MPEG4/90000\r\n");
                if ("TCP-PASSIVE".equals(streamMode)) {
                    content.append("a=setup:passive\r\n");
                    content.append("a=connection:new\r\n");
                } else if ("TCP-ACTIVE".equals(streamMode)) {
                    content.append("a=setup:active\r\n");
                    content.append("a=connection:new\r\n");
                }
            }
            content.append("a=downloadspeed:" + downloadSpeed + "\r\n");
            content.append("y=" + ssrcInfo.getSsrc() + "\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createPlaybackInviteRequest(device, channelId, content.toString(), null, "fromplybck" + tm, null, callIdHeader, ssrcInfo.getSsrc());
            ClientTransaction transaction = this.transmitRequest(device, request, errorEvent);
            this.streamSession.put(device.getDeviceId(), channelId, ssrcInfo.getSsrc(), ssrcInfo.getStreamId(), mediaServerItem.getId(), transaction);
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
        }
    }

    public void streamByeCmd(String deviceId, String channelId) {
        this.streamByeCmd(deviceId, channelId, null);
    }

    public void streamByeCmd(String deviceId, String channelId, SipSubscribe.Event okEvent) {
        try {
            ClientTransaction transaction = this.streamSession.getTransaction(deviceId, channelId);
            if (transaction == null) {
                this.logger.warn("[ {} -> {}]\u505c\u6b62\u89c6\u9891\u6d41\u7684\u65f6\u5019\u53d1\u73b0\u4e8b\u52a1\u5df2\u4e22\u5931", (Object)deviceId, (Object)channelId);
                SipSubscribe.EventResult eventResult = new SipSubscribe.EventResult();
                if (okEvent != null) {
                    okEvent.response(eventResult);
                }
                return;
            }
            SIPDialog dialog = this.streamSession.getDialog(deviceId, channelId);
            if (dialog == null) {
                this.logger.warn("[ {} -> {}]\u505c\u6b62\u89c6\u9891\u6d41\u7684\u65f6\u5019\u53d1\u73b0\u5bf9\u8bdd\u5df2\u4e22\u5931", (Object)deviceId, (Object)channelId);
                return;
            }
            SipStack sipStack = this.udpSipProvider.getSipStack();
            SIPDialog sipDialog = ((SipStackImpl)sipStack).putDialog(dialog);
            if (dialog != sipDialog) {
                dialog = sipDialog;
            } else {
                dialog.setSipProvider(this.udpSipProvider);
                try {
                    Field sipStackField = SIPDialog.class.getDeclaredField("sipStack");
                    sipStackField.setAccessible(true);
                    sipStackField.set(dialog, sipStack);
                    Field eventListenersField = SIPDialog.class.getDeclaredField("eventListeners");
                    eventListenersField.setAccessible(true);
                    eventListenersField.set(dialog, new HashSet());
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            Request byeRequest = dialog.createRequest("BYE");
            SipURI byeURI = (SipURI)byeRequest.getRequestURI();
            SIPRequest request = (SIPRequest)transaction.getRequest();
            byeURI.setHost(request.getRemoteAddress().getHostName());
            byeURI.setPort(request.getRemotePort());
            ViaHeader viaHeader = (ViaHeader)byeRequest.getHeader("Via");
            String protocol = viaHeader.getTransport().toUpperCase();
            ClientTransaction clientTransaction = null;
            if ("TCP".equals(protocol)) {
                clientTransaction = this.tcpSipProvider.getNewClientTransaction(byeRequest);
            } else if ("UDP".equals(protocol)) {
                clientTransaction = this.udpSipProvider.getNewClientTransaction(byeRequest);
            }
            CallIdHeader callIdHeader = (CallIdHeader)byeRequest.getHeader("Call-ID");
            if (okEvent != null) {
                this.sipSubscribe.addOkSubscribe(callIdHeader.getCallId(), okEvent);
            }
            dialog.sendRequest(clientTransaction);
            SsrcTransaction ssrcTransaction = this.streamSession.getSsrcTransaction(deviceId, channelId);
            if (ssrcTransaction != null) {
                MediaServerItem mediaServerItem = this.mediaServerService.getOne(ssrcTransaction.getMediaServerId());
                this.mediaServerService.releaseSsrc(mediaServerItem, ssrcTransaction.getSsrc());
                this.streamSession.remove(deviceId, channelId);
            }
        }
        catch (ParseException | SipException e) {
            e.printStackTrace();
        }
    }

    public boolean audioBroadcastCmd(Device device, String channelId) {
        return false;
    }

    public boolean audioBroadcastCmd(Device device) {
        try {
            StringBuffer broadcastXml = new StringBuffer(200);
            broadcastXml.append("<?xml version=\"1.0\" ?>\r\n");
            broadcastXml.append("<Notify>\r\n");
            broadcastXml.append("<CmdType>Broadcast</CmdType>\r\n");
            broadcastXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            broadcastXml.append("<SourceID>" + this.sipConfig.getId() + "</SourceID>\r\n");
            broadcastXml.append("<TargetID>" + device.getDeviceId() + "</TargetID>\r\n");
            broadcastXml.append("</Notify>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, broadcastXml.toString(), "z9hG4bK-ViaBcst-" + tm, "FromBcst" + tm, null, callIdHeader);
            this.transmitRequest(device, request);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void audioBroadcastCmd(Device device, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer broadcastXml = new StringBuffer(200);
            broadcastXml.append("<?xml version=\"1.0\" ?>\r\n");
            broadcastXml.append("<Notify>\r\n");
            broadcastXml.append("<CmdType>Broadcast</CmdType>\r\n");
            broadcastXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            broadcastXml.append("<SourceID>" + this.sipConfig.getId() + "</SourceID>\r\n");
            broadcastXml.append("<TargetID>" + device.getDeviceId() + "</TargetID>\r\n");
            broadcastXml.append("</Notify>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, broadcastXml.toString(), "z9hG4bK-ViaBcst-" + tm, "FromBcst" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
        }
    }

    public boolean recordCmd(Device device, String channelId, String recordCmdStr, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Control>\r\n");
            cmdXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            if (StringUtils.isEmpty((Object)channelId)) {
                cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            } else {
                cmdXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            }
            cmdXml.append("<RecordCmd>" + recordCmdStr + "</RecordCmd>\r\n");
            cmdXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromRecord" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean teleBootCmd(Device device) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Control>\r\n");
            cmdXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            cmdXml.append("<TeleBoot>Boot</TeleBoot>\r\n");
            cmdXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromBoot" + tm, null, callIdHeader);
            this.transmitRequest(device, request);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean guardCmd(Device device, String guardCmdStr, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Control>\r\n");
            cmdXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            cmdXml.append("<GuardCmd>" + guardCmdStr + "</GuardCmd>\r\n");
            cmdXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromGuard" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean alarmCmd(Device device, String alarmMethod, String alarmType, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Control>\r\n");
            cmdXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            cmdXml.append("<AlarmCmd>ResetAlarm</AlarmCmd>\r\n");
            if (!StringUtils.isEmpty((Object)alarmMethod) || !StringUtils.isEmpty((Object)alarmType)) {
                cmdXml.append("<Info>\r\n");
            }
            if (!StringUtils.isEmpty((Object)alarmMethod)) {
                cmdXml.append("<AlarmMethod>" + alarmMethod + "</AlarmMethod>\r\n");
            }
            if (!StringUtils.isEmpty((Object)alarmType)) {
                cmdXml.append("<AlarmType>" + alarmType + "</AlarmType>\r\n");
            }
            if (!StringUtils.isEmpty((Object)alarmMethod) || !StringUtils.isEmpty((Object)alarmType)) {
                cmdXml.append("</Info>\r\n");
            }
            cmdXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromAlarm" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean iFrameCmd(Device device, String channelId) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Control>\r\n");
            cmdXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            if (StringUtils.isEmpty((Object)channelId)) {
                cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            } else {
                cmdXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            }
            cmdXml.append("<IFameCmd>Send</IFameCmd>\r\n");
            cmdXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromBoot" + tm, null, callIdHeader);
            this.transmitRequest(device, request);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean homePositionCmd(Device device, String channelId, String enabled, String resetTime, String presetIndex, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Control>\r\n");
            cmdXml.append("<CmdType>DeviceControl</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            if (StringUtils.isEmpty((Object)channelId)) {
                cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            } else {
                cmdXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            }
            cmdXml.append("<HomePosition>\r\n");
            if (NumericUtil.isInteger((String)enabled) && !enabled.equals("0")) {
                cmdXml.append("<Enabled>1</Enabled>\r\n");
                if (NumericUtil.isInteger((String)resetTime)) {
                    cmdXml.append("<ResetTime>" + resetTime + "</ResetTime>\r\n");
                } else {
                    cmdXml.append("<ResetTime>0</ResetTime>\r\n");
                }
                if (NumericUtil.isInteger((String)presetIndex)) {
                    cmdXml.append("<PresetIndex>" + presetIndex + "</PresetIndex>\r\n");
                } else {
                    cmdXml.append("<PresetIndex>0</PresetIndex>\r\n");
                }
            } else {
                cmdXml.append("<Enabled>0</Enabled>\r\n");
            }
            cmdXml.append("</HomePosition>\r\n");
            cmdXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromGuard" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deviceConfigCmd(Device device) {
        return false;
    }

    public boolean deviceBasicConfigCmd(Device device, String channelId, String name, String expiration, String heartBeatInterval, String heartBeatCount, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Control>\r\n");
            cmdXml.append("<CmdType>DeviceConfig</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            if (StringUtils.isEmpty((Object)channelId)) {
                cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            } else {
                cmdXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            }
            cmdXml.append("<BasicParam>\r\n");
            if (!StringUtils.isEmpty((Object)name)) {
                cmdXml.append("<Name>" + name + "</Name>\r\n");
            }
            if (NumericUtil.isInteger((String)expiration) && Integer.valueOf(expiration) > 0) {
                cmdXml.append("<Expiration>" + expiration + "</Expiration>\r\n");
            }
            if (NumericUtil.isInteger((String)heartBeatInterval) && Integer.valueOf(heartBeatInterval) > 0) {
                cmdXml.append("<HeartBeatInterval>" + heartBeatInterval + "</HeartBeatInterval>\r\n");
            }
            if (NumericUtil.isInteger((String)heartBeatCount) && Integer.valueOf(heartBeatCount) > 0) {
                cmdXml.append("<HeartBeatCount>" + heartBeatCount + "</HeartBeatCount>\r\n");
            }
            cmdXml.append("</BasicParam>\r\n");
            cmdXml.append("</Control>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromConfig" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deviceStatusQuery(Device device, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer catalogXml = new StringBuffer(200);
            catalogXml.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\r\n");
            catalogXml.append("<Query>\r\n");
            catalogXml.append("<CmdType>DeviceStatus</CmdType>\r\n");
            catalogXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            catalogXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            catalogXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, catalogXml.toString(), null, "FromStatus" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deviceInfoQuery(Device device) {
        try {
            StringBuffer catalogXml = new StringBuffer(200);
            catalogXml.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\r\n");
            catalogXml.append("<Query>\r\n");
            catalogXml.append("<CmdType>DeviceInfo</CmdType>\r\n");
            catalogXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            catalogXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            catalogXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, catalogXml.toString(), "z9hG4bK-ViaDeviceInfo-" + tm, "FromDev" + tm, null, callIdHeader);
            this.transmitRequest(device, request);
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean catalogQuery(Device device, SipSubscribe.Event errorEvent) {
        this.storager.cleanChannelsForDevice(device.getDeviceId());
        try {
            StringBuffer catalogXml = new StringBuffer(200);
            catalogXml.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\r\n");
            catalogXml.append("<Query>\r\n");
            catalogXml.append("<CmdType>Catalog</CmdType>\r\n");
            catalogXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            catalogXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            catalogXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, catalogXml.toString(), "z9hG4bK-ViaCatalog-" + tm, "FromCat" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean recordInfoQuery(Device device, String channelId, String startTime, String endTime) {
        try {
            StringBuffer recordInfoXml = new StringBuffer(200);
            recordInfoXml.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\r\n");
            recordInfoXml.append("<Query>\r\n");
            recordInfoXml.append("<CmdType>RecordInfo</CmdType>\r\n");
            recordInfoXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            recordInfoXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            recordInfoXml.append("<StartTime>" + DateUtil.yyyy_MM_dd_HH_mm_ssToISO8601((String)startTime) + "</StartTime>\r\n");
            recordInfoXml.append("<EndTime>" + DateUtil.yyyy_MM_dd_HH_mm_ssToISO8601((String)endTime) + "</EndTime>\r\n");
            recordInfoXml.append("<Secrecy>0</Secrecy>\r\n");
            recordInfoXml.append("<Type>all</Type>\r\n");
            recordInfoXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, recordInfoXml.toString(), "z9hG4bK-ViaRecordInfo-" + tm, "fromRec" + tm, null, callIdHeader);
            this.transmitRequest(device, request);
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean alarmInfoQuery(Device device, String startPriority, String endPriority, String alarmMethod, String alarmType, String startTime, String endTime, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Query>\r\n");
            cmdXml.append("<CmdType>Alarm</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            if (!StringUtils.isEmpty((Object)startPriority)) {
                cmdXml.append("<StartAlarmPriority>" + startPriority + "</StartAlarmPriority>\r\n");
            }
            if (!StringUtils.isEmpty((Object)endPriority)) {
                cmdXml.append("<EndAlarmPriority>" + endPriority + "</EndAlarmPriority>\r\n");
            }
            if (!StringUtils.isEmpty((Object)alarmMethod)) {
                cmdXml.append("<AlarmMethod>" + alarmMethod + "</AlarmMethod>\r\n");
            }
            if (!StringUtils.isEmpty((Object)alarmType)) {
                cmdXml.append("<AlarmType>" + alarmType + "</AlarmType>\r\n");
            }
            if (!StringUtils.isEmpty((Object)startTime)) {
                cmdXml.append("<StartAlarmTime>" + startTime + "</StartAlarmTime>\r\n");
            }
            if (!StringUtils.isEmpty((Object)endTime)) {
                cmdXml.append("<EndAlarmTime>" + endTime + "</EndAlarmTime>\r\n");
            }
            cmdXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromAlarm" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deviceConfigQuery(Device device, String channelId, String configType, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Query>\r\n");
            cmdXml.append("<CmdType>ConfigDownload</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            if (StringUtils.isEmpty((Object)channelId)) {
                cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            } else {
                cmdXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            }
            cmdXml.append("<ConfigType>" + configType + "</ConfigType>\r\n");
            cmdXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromConfig" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean presetQuery(Device device, String channelId, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" ?>\r\n");
            cmdXml.append("<Query>\r\n");
            cmdXml.append("<CmdType>PresetQuery</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            if (StringUtils.isEmpty((Object)channelId)) {
                cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            } else {
                cmdXml.append("<DeviceID>" + channelId + "</DeviceID>\r\n");
            }
            cmdXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, cmdXml.toString(), null, "FromConfig" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
            return true;
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean mobilePostitionQuery(Device device, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer mobilePostitionXml = new StringBuffer(200);
            mobilePostitionXml.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\r\n");
            mobilePostitionXml.append("<Query>\r\n");
            mobilePostitionXml.append("<CmdType>MobilePosition</CmdType>\r\n");
            mobilePostitionXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            mobilePostitionXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            mobilePostitionXml.append("<Interval>60</Interval>\r\n");
            mobilePostitionXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createMessageRequest(device, mobilePostitionXml.toString(), "z9hG4bK-viaPos-" + tm, "fromTagPos" + tm, null, callIdHeader);
            this.transmitRequest(device, request, errorEvent);
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean mobilePositionSubscribe(Device device, int expires, int interval) {
        try {
            StringBuffer subscribePostitionXml = new StringBuffer(200);
            subscribePostitionXml.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\r\n");
            subscribePostitionXml.append("<Query>\r\n");
            subscribePostitionXml.append("<CmdType>MobilePosition</CmdType>\r\n");
            subscribePostitionXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            subscribePostitionXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            if (expires > 0) {
                subscribePostitionXml.append("<Interval>" + String.valueOf(interval) + "</Interval>\r\n");
            }
            subscribePostitionXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createSubscribeRequest(device, subscribePostitionXml.toString(), "z9hG4bK-viaPos-" + tm, "fromTagPos" + tm, null, Integer.valueOf(expires), "presence", callIdHeader);
            this.transmitRequest(device, request);
            return true;
        }
        catch (NumberFormatException | ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean alarmSubscribe(Device device, int expires, String startPriority, String endPriority, String alarmMethod, String alarmType, String startTime, String endTime) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\r\n");
            cmdXml.append("<Query>\r\n");
            cmdXml.append("<CmdType>Alarm</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            if (!StringUtils.isEmpty((Object)startPriority)) {
                cmdXml.append("<StartAlarmPriority>" + startPriority + "</StartAlarmPriority>\r\n");
            }
            if (!StringUtils.isEmpty((Object)endPriority)) {
                cmdXml.append("<EndAlarmPriority>" + endPriority + "</EndAlarmPriority>\r\n");
            }
            if (!StringUtils.isEmpty((Object)alarmMethod)) {
                cmdXml.append("<AlarmMethod>" + alarmMethod + "</AlarmMethod>\r\n");
            }
            if (!StringUtils.isEmpty((Object)alarmType)) {
                cmdXml.append("<AlarmType>" + alarmType + "</AlarmType>\r\n");
            }
            if (!StringUtils.isEmpty((Object)startTime)) {
                cmdXml.append("<StartAlarmTime>" + startTime + "</StartAlarmTime>\r\n");
            }
            if (!StringUtils.isEmpty((Object)endTime)) {
                cmdXml.append("<EndAlarmTime>" + endTime + "</EndAlarmTime>\r\n");
            }
            cmdXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createSubscribeRequest(device, cmdXml.toString(), "z9hG4bK-viaPos-" + tm, "fromTagPos" + tm, null, Integer.valueOf(expires), "presence", callIdHeader);
            this.transmitRequest(device, request);
            return true;
        }
        catch (NumberFormatException | ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean catalogSubscribe(Device device, SipSubscribe.Event okEvent, SipSubscribe.Event errorEvent) {
        try {
            StringBuffer cmdXml = new StringBuffer(200);
            cmdXml.append("<?xml version=\"1.0\" encoding=\"GB2312\"?>\r\n");
            cmdXml.append("<Query>\r\n");
            cmdXml.append("<CmdType>Catalog</CmdType>\r\n");
            cmdXml.append("<SN>" + (int)((Math.random() * 9.0 + 1.0) * 100000.0) + "</SN>\r\n");
            cmdXml.append("<DeviceID>" + device.getDeviceId() + "</DeviceID>\r\n");
            cmdXml.append("</Query>\r\n");
            String tm = Long.toString(System.currentTimeMillis());
            CallIdHeader callIdHeader = device.getTransport().equals("TCP") ? this.tcpSipProvider.getNewCallId() : this.udpSipProvider.getNewCallId();
            Request request = this.headerProvider.createSubscribeRequest(device, cmdXml.toString(), "z9hG4bK-viaPos-" + tm, "fromTagPos" + tm, null, Integer.valueOf(device.getSubscribeCycleForCatalog()), "Catalog", callIdHeader);
            this.transmitRequest(device, request, errorEvent, okEvent);
            return true;
        }
        catch (NumberFormatException | ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
            return false;
        }
    }

    private ClientTransaction transmitRequest(Device device, Request request) throws SipException {
        return this.transmitRequest(device, request, null, null);
    }

    private ClientTransaction transmitRequest(Device device, Request request, SipSubscribe.Event errorEvent) throws SipException {
        return this.transmitRequest(device, request, errorEvent, null);
    }

    private ClientTransaction transmitRequest(Device device, Request request, SipSubscribe.Event errorEvent, SipSubscribe.Event okEvent) throws SipException {
        ClientTransaction clientTransaction = null;
        if ("TCP".equals(device.getTransport())) {
            clientTransaction = this.tcpSipProvider.getNewClientTransaction(request);
        } else if ("UDP".equals(device.getTransport())) {
            clientTransaction = this.udpSipProvider.getNewClientTransaction(request);
        }
        CallIdHeader callIdHeader = (CallIdHeader)request.getHeader("Call-ID");
        if (errorEvent != null) {
            this.sipSubscribe.addErrorSubscribe(callIdHeader.getCallId(), eventResult -> {
                errorEvent.response(eventResult);
                this.sipSubscribe.removeErrorSubscribe(eventResult.callId);
            });
        }
        if (okEvent != null) {
            this.sipSubscribe.addOkSubscribe(callIdHeader.getCallId(), eventResult -> {
                okEvent.response(eventResult);
                this.sipSubscribe.removeOkSubscribe(eventResult.callId);
            });
        }
        clientTransaction.sendRequest();
        return clientTransaction;
    }
}

