/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.callback;

import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.async.DeferredResult;

@Component
public class DeferredResultHolder {
    public static final String CALLBACK_CMD_DEVICESTATUS = "CALLBACK_DEVICESTATUS";
    public static final String CALLBACK_CMD_DEVICEINFO = "CALLBACK_DEVICEINFO";
    public static final String CALLBACK_CMD_DEVICECONTROL = "CALLBACK_DEVICECONTROL";
    public static final String CALLBACK_CMD_DEVICECONFIG = "CALLBACK_DEVICECONFIG";
    public static final String CALLBACK_CMD_CONFIGDOWNLOAD = "CALLBACK_CONFIGDOWNLOAD";
    public static final String CALLBACK_CMD_CATALOG = "CALLBACK_CATALOG";
    public static final String CALLBACK_CMD_RECORDINFO = "CALLBACK_RECORDINFO";
    public static final String CALLBACK_CMD_PLAY = "CALLBACK_PLAY";
    public static final String CALLBACK_CMD_STOP = "CALLBACK_STOP";
    public static final String CALLBACK_ONVIF = "CALLBACK_ONVIF";
    public static final String CALLBACK_CMD_MOBILEPOSITION = "CALLBACK_MOBILEPOSITION";
    public static final String CALLBACK_CMD_PRESETQUERY = "CALLBACK_PRESETQUERY";
    public static final String CALLBACK_CMD_ALARM = "CALLBACK_ALARM";
    public static final String CALLBACK_CMD_BROADCAST = "CALLBACK_BROADCAST";
    private Map<String, Map<String, DeferredResult>> map = new ConcurrentHashMap();

    public void put(String key, String id, DeferredResult result) {
        ConcurrentHashMap<String, DeferredResult> deferredResultMap = (ConcurrentHashMap<String, DeferredResult>)this.map.get(key);
        if (deferredResultMap == null) {
            deferredResultMap = new ConcurrentHashMap<String, DeferredResult>();
            this.map.put(key, deferredResultMap);
        }
        deferredResultMap.put(id, result);
    }

    public DeferredResult get(String key, String id) {
        Map deferredResultMap = (Map)this.map.get(key);
        if (deferredResultMap == null) {
            return null;
        }
        return (DeferredResult)deferredResultMap.get(id);
    }

    public boolean exist(String key, String id) {
        if (key == null) {
            return false;
        }
        Map deferredResultMap = (Map)this.map.get(key);
        if (id == null) {
            return deferredResultMap != null;
        }
        return deferredResultMap != null && deferredResultMap.get(id) != null;
    }

    public void invokeResult(RequestMessage msg) {
        Map deferredResultMap = (Map)this.map.get(msg.getKey());
        if (deferredResultMap == null) {
            return;
        }
        DeferredResult result = (DeferredResult)deferredResultMap.get(msg.getId());
        if (result == null) {
            return;
        }
        result.setResult((Object)new ResponseEntity(msg.getData(), HttpStatus.OK));
        deferredResultMap.remove(msg.getId());
        if (deferredResultMap.size() == 0) {
            this.map.remove(msg.getKey());
        }
    }

    public void invokeAllResult(RequestMessage msg) {
        Map deferredResultMap = (Map)this.map.get(msg.getKey());
        if (deferredResultMap == null) {
            return;
        }
        Set ids = deferredResultMap.keySet();
        for (String id : ids) {
            DeferredResult result = (DeferredResult)deferredResultMap.get(id);
            if (result == null) {
                return;
            }
            result.setResult((Object)new ResponseEntity(msg.getData(), HttpStatus.OK));
        }
        this.map.remove(msg.getKey());
    }
}

