/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit;

import com.genersoft.iot.vmp.gb28181.event.SipSubscribe;
import com.genersoft.iot.vmp.gb28181.transmit.ISIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.response.ISIPResponseProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.timeout.ITimeoutProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SIPProcessorObserver
implements ISIPProcessorObserver {
    private static final Logger logger = LoggerFactory.getLogger(SIPProcessorObserver.class);
    private static Map<String, ISIPRequestProcessor> requestProcessorMap = new ConcurrentHashMap();
    private static Map<String, ISIPResponseProcessor> responseProcessorMap = new ConcurrentHashMap();
    private static ITimeoutProcessor timeoutProcessor;
    @Autowired
    private SipSubscribe sipSubscribe;

    public void addRequestProcessor(String method, ISIPRequestProcessor processor) {
        requestProcessorMap.put(method, processor);
    }

    public void addResponseProcessor(String method, ISIPResponseProcessor processor) {
        responseProcessorMap.put(method, processor);
    }

    public void addTimeoutProcessor(ITimeoutProcessor processor) {
        timeoutProcessor = processor;
    }

    @Async
    public void processRequest(RequestEvent requestEvent) {
        String method = requestEvent.getRequest().getMethod();
        ISIPRequestProcessor sipRequestProcessor = (ISIPRequestProcessor)requestProcessorMap.get(method);
        if (sipRequestProcessor == null) {
            logger.warn("\u4e0d\u652f\u6301\u65b9\u6cd5{}\u7684request", (Object)method);
            return;
        }
        ((ISIPRequestProcessor)requestProcessorMap.get(method)).process(requestEvent);
    }

    @Async
    public void processResponse(ResponseEvent responseEvent) {
        logger.debug(responseEvent.getResponse().toString());
        Response response = responseEvent.getResponse();
        logger.debug(responseEvent.getResponse().toString());
        int status = response.getStatusCode();
        if (status >= 200 && status < 300 || status == 401) {
            SipSubscribe.Event subscribe;
            CallIdHeader callIdHeader;
            CSeqHeader cseqHeader = (CSeqHeader)responseEvent.getResponse().getHeader("CSeq");
            String method = cseqHeader.getMethod();
            ISIPResponseProcessor sipRequestProcessor = (ISIPResponseProcessor)responseProcessorMap.get(method);
            if (sipRequestProcessor != null) {
                sipRequestProcessor.process(responseEvent);
            }
            if (responseEvent.getResponse() != null && this.sipSubscribe.getOkSubscribesSize() > 0 && (callIdHeader = (CallIdHeader)responseEvent.getResponse().getHeader("Call-ID")) != null && (subscribe = this.sipSubscribe.getOkSubscribe(callIdHeader.getCallId())) != null) {
                SipSubscribe.EventResult eventResult = new SipSubscribe.EventResult((Object)responseEvent);
                subscribe.response(eventResult);
            }
        } else if (status < 100 || status >= 200) {
            SipSubscribe.Event subscribe;
            CallIdHeader callIdHeader;
            logger.warn("\u63a5\u6536\u5230\u5931\u8d25\u7684response\u54cd\u5e94\uff01status\uff1a" + status + ",message:" + response.getReasonPhrase());
            if (responseEvent.getResponse() != null && this.sipSubscribe.getErrorSubscribesSize() > 0 && (callIdHeader = (CallIdHeader)responseEvent.getResponse().getHeader("Call-ID")) != null && (subscribe = this.sipSubscribe.getErrorSubscribe(callIdHeader.getCallId())) != null) {
                SipSubscribe.EventResult eventResult = new SipSubscribe.EventResult((Object)responseEvent);
                subscribe.response(eventResult);
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        if (timeoutProcessor != null) {
            timeoutProcessor.process(timeoutEvent);
        }
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        CallIdHeader callId = dialogTerminatedEvent.getDialog().getCallId();
    }
}

