/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.event.offline;

import com.genersoft.iot.vmp.gb28181.event.offline.OfflineEvent;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class OfflineEventListener
implements ApplicationListener<OfflineEvent> {
    private static final Logger logger = LoggerFactory.getLogger(OfflineEventListener.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private RedisUtil redis;

    public void onApplicationEvent(OfflineEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u79bb\u7ebf\u4e8b\u4ef6\u89e6\u53d1\uff0cdeviceId\uff1a" + event.getDeviceId() + ",from:" + event.getFrom());
        }
        String key = "VMP_keeplive_" + event.getDeviceId();
        switch (event.getFrom()) {
            case "2": {
                break;
            }
            case "1": {
                this.redis.del(new String[]{key});
                break;
            }
            default: {
                boolean exist = this.redis.hasKey(key);
                if (!exist) break;
                this.redis.del(new String[]{key});
            }
        }
        this.storager.outline(event.getDeviceId());
    }
}

