/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.event;

import com.genersoft.iot.vmp.gb28181.event.SipSubscribe;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SipSubscribe {
    private final Logger logger = LoggerFactory.getLogger(SipSubscribe.class);
    private Map<String, Event> errorSubscribes = new ConcurrentHashMap();
    private Map<String, Event> okSubscribes = new ConcurrentHashMap();
    private Map<String, Date> timeSubscribes = new ConcurrentHashMap();

    @Scheduled(cron="0 0 * * * ?")
    public void execute() {
        this.logger.info("[\u5b9a\u65f6\u4efb\u52a1] \u6e05\u7406\u8fc7\u671f\u7684\u8ba2\u9605\u4fe1\u606f");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(10, calendar.get(10) - 1);
        for (String key : this.timeSubscribes.keySet()) {
            if (!((Date)this.timeSubscribes.get(key)).before(calendar.getTime())) continue;
            this.logger.info("[\u5b9a\u65f6\u4efb\u52a1] \u6e05\u7406\u8fc7\u671f\u7684\u8ba2\u9605\u4fe1\u606f\uff1a {}", (Object)key);
            this.errorSubscribes.remove(key);
            this.okSubscribes.remove(key);
            this.timeSubscribes.remove(key);
        }
    }

    public void addErrorSubscribe(String key, Event event) {
        this.errorSubscribes.put(key, event);
        this.timeSubscribes.put(key, new Date());
    }

    public void addOkSubscribe(String key, Event event) {
        this.okSubscribes.put(key, event);
        this.timeSubscribes.put(key, new Date());
    }

    public Event getErrorSubscribe(String key) {
        return (Event)this.errorSubscribes.get(key);
    }

    public void removeErrorSubscribe(String key) {
        this.errorSubscribes.remove(key);
        this.timeSubscribes.remove(key);
    }

    public Event getOkSubscribe(String key) {
        return (Event)this.okSubscribes.get(key);
    }

    public void removeOkSubscribe(String key) {
        this.okSubscribes.remove(key);
        this.timeSubscribes.remove(key);
    }

    public int getErrorSubscribesSize() {
        return this.errorSubscribes.size();
    }

    public int getOkSubscribesSize() {
        return this.okSubscribes.size();
    }
}

