/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public class LoginFailureHandler
implements AuthenticationFailureHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoginFailureHandler.class);
    @Autowired
    private ObjectMapper objectMapper;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException, ServletException {
        String username = request.getParameter("username");
        if (e instanceof AccountExpiredException) {
            logger.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u8d26\u53f7\u8fc7\u671f", (Object)username);
        } else if (e instanceof BadCredentialsException) {
            logger.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u5bc6\u7801/SIP\u670d\u52a1\u5668ID \u9519\u8bef", (Object)username);
        } else if (e instanceof CredentialsExpiredException) {
            logger.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u5bc6\u7801\u8fc7\u671f", (Object)username);
        } else if (e instanceof DisabledException) {
            logger.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u88ab\u7981\u7528", (Object)username);
        } else if (e instanceof LockedException) {
            logger.info("[\u767b\u5f55\u5931\u8d25] - \u7528\u6237[{}]\u88ab\u9501\u5b9a", (Object)username);
        } else if (e instanceof InternalAuthenticationServiceException) {
            logger.error(String.format("[\u767b\u5f55\u5931\u8d25] - [%s]\u5185\u90e8\u9519\u8bef", username), (Throwable)e);
        } else {
            logger.error(String.format("[\u767b\u5f55\u5931\u8d25] - [%s]\u5176\u4ed6\u9519\u8bef", username), (Throwable)e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "0");
        map.put("msg", "\u767b\u5f55\u5931\u8d25");
        response.setContentType("application/json;charset=UTF-8");
        response.getWriter().write(this.objectMapper.writeValueAsString(map));
    }
}

