/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf;

import com.alibaba.fastjson.parser.ParserConfig;
import com.genersoft.iot.vmp.utils.redis.FastJsonRedisSerializer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfig
extends CachingConfigurerSupport {
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.database}")
    private int database;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.poolMaxTotal:1000}")
    private int poolMaxTotal;
    @Value(value="${spring.redis.poolMaxIdle:500}")
    private int poolMaxIdle;
    @Value(value="${spring.redis.poolMaxWait:5}")
    private int poolMaxWait;

    @Bean
    public JedisPool jedisPool() {
        if (StringUtils.isBlank((CharSequence)this.password)) {
            this.password = null;
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(this.poolMaxIdle);
        poolConfig.setMaxTotal(this.poolMaxTotal);
        poolConfig.setMaxWaitMillis((long)this.poolMaxWait * 1000L);
        JedisPool jp = new JedisPool((GenericObjectPoolConfig)poolConfig, this.host, this.port, this.timeout * 1000, this.password, this.database);
        return jp;
    }

    @Bean(value={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        FastJsonRedisSerializer serializer = new FastJsonRedisSerializer(Object.class);
        template.setValueSerializer((RedisSerializer)serializer);
        template.setHashValueSerializer((RedisSerializer)serializer);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setConnectionFactory(redisConnectionFactory);
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
        return template;
    }

    @Bean
    RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }
}

