/*
 * Decompiled with CFR 0.152.
 */
package top.panll.assist.utils;

import java.util.ArrayList;
import java.util.List;

public class PageInfo<T> {
    private int pageNum;
    private int pageSize;
    private int size;
    private int pages;
    private int total;
    private List<T> resultData;
    private List<T> list;

    public PageInfo(List<T> resultData) {
        this.resultData = resultData;
    }

    public void startPage(int page, int count) {
        if (page <= 0) {
            page = 1;
        }
        this.pageNum = page;
        this.pageSize = count;
        this.total = this.resultData.size();
        this.pages = this.total % count == 0 ? this.total / count : this.total / count + 1;
        int fromIndx = (page - 1) * count;
        if (fromIndx > this.total - 1) {
            this.list = new ArrayList();
            this.size = 0;
            return;
        }
        int toIndx = page * count;
        if (toIndx > this.total) {
            toIndx = this.total;
        }
        this.list = this.resultData.subList(fromIndx, toIndx);
        this.size = this.list.size();
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}

