/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.web;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/v1/control"})
public class ApiControlController {
    private static final Logger logger = LoggerFactory.getLogger(ApiControlController.class);
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IVideoManagerStorager storager;

    @RequestMapping(value={"/ptz"})
    private JSONObject list(String serial, String command, @RequestParam(required=false) Integer channel, @RequestParam(required=false) String code, @RequestParam(required=false) Integer speed) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u6a21\u62df\u63a5\u53e3> \u8bbe\u5907\u4e91\u53f0\u63a7\u5236 API\u8c03\u7528\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s \uff0ccommand\uff1a%d \uff0cspeed\uff1a%d ", serial, code, command, speed));
        }
        Device device = this.storager.queryVideoDevice(serial);
        int leftRight = 0;
        int upDown = 0;
        int inOut = 0;
        switch (command) {
            case "left": {
                leftRight = 1;
                break;
            }
            case "right": {
                leftRight = 2;
                break;
            }
            case "up": {
                upDown = 1;
                break;
            }
            case "down": {
                upDown = 2;
                break;
            }
            case "upleft": {
                upDown = 1;
                leftRight = 1;
            }
            case "upright": {
                upDown = 1;
                leftRight = 2;
                break;
            }
            case "downleft": {
                upDown = 2;
                leftRight = 1;
                break;
            }
            case "downright": {
                upDown = 2;
                leftRight = 2;
                break;
            }
            case "zoomin": {
                inOut = 2;
                break;
            }
            case "zoomout": {
                inOut = 1;
                break;
            }
        }
        this.cmder.ptzCmd(device, code, leftRight, upDown, inOut, speed == 0 ? 129 : speed, 50);
        return null;
    }
}

