/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.user;

import com.genersoft.iot.vmp.conf.security.SecurityUtils;
import com.genersoft.iot.vmp.service.IRoleService;
import com.genersoft.iot.vmp.storager.dao.dto.Role;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/role"})
public class RoleController {
    @Autowired
    private IRoleService roleService;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", required=true, value="\u89d2\u8272\u540d", dataTypeClass=String.class), @ApiImplicitParam(name="authority", required=true, value="\u6743\u9650\uff08\u81ea\u884c\u5b9a\u4e49\u5185\u5bb9\uff0c\u76ee\u524d\u672a\u4f7f\u7528\uff09", dataTypeClass=String.class)})
    @PostMapping(value={"/add"})
    public ResponseEntity<WVPResult<Integer>> add(@RequestParam String name, @RequestParam(required=false) String authority) {
        WVPResult result = new WVPResult();
        int currenRoleId = SecurityUtils.getUserInfo().getRole().getId();
        if (currenRoleId != 1) {
            result.setCode(-1);
            result.setMsg("\u7528\u6237\u65e0\u6743\u9650");
            return new ResponseEntity((Object)result, HttpStatus.FORBIDDEN);
        }
        Role role = new Role();
        role.setName(name);
        role.setAuthority(authority);
        role.setCreateTime(this.format.format(System.currentTimeMillis()));
        role.setUpdateTime(this.format.format(System.currentTimeMillis()));
        int addResult = this.roleService.add(role);
        result.setCode(addResult > 0 ? 0 : -1);
        result.setMsg(addResult > 0 ? "success" : "fail");
        result.setData((Object)addResult);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=true, value="\u7528\u6237Id", dataTypeClass=Integer.class)})
    @DeleteMapping(value={"/delete"})
    public ResponseEntity<WVPResult<String>> delete(@RequestParam Integer id) {
        int currenRoleId = SecurityUtils.getUserInfo().getRole().getId();
        WVPResult result = new WVPResult();
        if (currenRoleId != 1) {
            result.setCode(-1);
            result.setMsg("\u7528\u6237\u65e0\u6743\u9650");
            return new ResponseEntity((Object)result, HttpStatus.FORBIDDEN);
        }
        int deleteResult = this.roleService.delete(id.intValue());
        result.setCode(deleteResult > 0 ? 0 : -1);
        result.setMsg(deleteResult > 0 ? "success" : "fail");
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272")
    @ApiImplicitParams(value={})
    @GetMapping(value={"/all"})
    public ResponseEntity<WVPResult<List<Role>>> all() {
        List allRoles = this.roleService.getAll();
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        result.setData((Object)allRoles);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

