/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.VersionPo;
import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.conf.VersionInfo;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u670d\u52a1\u63a7\u5236"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/server"})
public class ServerController {
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private IMediaServerService mediaServerService;
    @Autowired
    VersionInfo versionInfo;
    @Autowired
    SipConfig sipConfig;
    @Autowired
    UserSetup userSetup;
    @Value(value="${server.port}")
    private int serverPort;

    @ApiOperation(value="\u6d41\u5a92\u4f53\u670d\u52a1\u5217\u8868")
    @GetMapping(value={"/media_server/list"})
    @ResponseBody
    public WVPResult<List<MediaServerItem>> getMediaServerList(boolean detail) {
        List all = this.mediaServerService.getAll();
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        result.setData((Object)this.mediaServerService.getAll());
        return result;
    }

    @ApiOperation(value="\u5728\u7ebf\u6d41\u5a92\u4f53\u670d\u52a1\u5217\u8868")
    @GetMapping(value={"/media_server/online/list"})
    @ResponseBody
    public WVPResult<List<MediaServerItem>> getOnlineMediaServerList() {
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        result.setData((Object)this.mediaServerService.getAllOnline());
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u5a92\u4f53\u670d\u52a1")
    @GetMapping(value={"/media_server/one/{id}"})
    @ResponseBody
    public WVPResult<MediaServerItem> getMediaServer(@PathVariable String id) {
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        result.setData((Object)this.mediaServerService.getOne(id));
        return result;
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6d41\u5a92\u4f53\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ip", value="\u6d41\u5a92\u4f53\u670d\u52a1IP", dataTypeClass=String.class), @ApiImplicitParam(name="port", value="\u6d41\u5a92\u4f53\u670d\u52a1HTT\u7aef\u53e3", dataTypeClass=Integer.class), @ApiImplicitParam(name="secret", value="\u6d41\u5a92\u4f53\u670d\u52a1secret", dataTypeClass=String.class)})
    @GetMapping(value={"/media_server/check"})
    @ResponseBody
    public WVPResult<MediaServerItem> checkMediaServer(@RequestParam String ip, @RequestParam int port, @RequestParam String secret) {
        return this.mediaServerService.checkMediaServer(ip, port, secret);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6d41\u5a92\u4f53\u5f55\u50cf\u7ba1\u7406\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ip", value="\u6d41\u5a92\u4f53\u670d\u52a1IP", dataTypeClass=String.class), @ApiImplicitParam(name="port", value="\u6d41\u5a92\u4f53\u670d\u52a1HTT\u7aef\u53e3", dataTypeClass=Integer.class), @ApiImplicitParam(name="secret", value="\u6d41\u5a92\u4f53\u670d\u52a1secret", dataTypeClass=String.class)})
    @GetMapping(value={"/media_server/record/check"})
    @ResponseBody
    public WVPResult<String> checkMediaRecordServer(@RequestParam String ip, @RequestParam int port) {
        boolean checkResult = this.mediaServerService.checkMediaRecordServer(ip, port);
        WVPResult result = new WVPResult();
        if (checkResult) {
            result.setCode(0);
            result.setMsg("success");
        } else {
            result.setCode(-1);
            result.setMsg("\u8fde\u63a5\u5931\u8d25");
        }
        return result;
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u5a92\u4f53\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="mediaServerItem", value="\u6d41\u5a92\u4f53\u4fe1\u606f", dataTypeClass=MediaServerItem.class)})
    @PostMapping(value={"/media_server/save"})
    @ResponseBody
    public WVPResult<String> saveMediaServer(@RequestBody MediaServerItem mediaServerItem) {
        MediaServerItem mediaServerItemInDatabase = this.mediaServerService.getOne(mediaServerItem.getId());
        if (mediaServerItemInDatabase != null) {
            if (StringUtils.isEmpty((Object)mediaServerItemInDatabase.getSendRtpPortRange()) && StringUtils.isEmpty((Object)mediaServerItem.getSendRtpPortRange())) {
                mediaServerItem.setSendRtpPortRange("30000,30500");
            }
        } else {
            if (StringUtils.isEmpty((Object)mediaServerItem.getSendRtpPortRange())) {
                mediaServerItem.setSendRtpPortRange("30000,30500");
            }
            return this.mediaServerService.add(mediaServerItem);
        }
        this.mediaServerService.update(mediaServerItem);
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        return result;
    }

    @ApiOperation(value="\u79fb\u9664\u6d41\u5a92\u4f53\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6d41\u5a92\u4f53ID", dataTypeClass=String.class)})
    @DeleteMapping(value={"/media_server/delete"})
    @ResponseBody
    public WVPResult<String> deleteMediaServer(@RequestParam String id) {
        if (this.mediaServerService.getOne(id) == null) {
            WVPResult result = new WVPResult();
            result.setCode(-1);
            result.setMsg("\u672a\u627e\u5230\u6b64\u8282\u70b9");
            return result;
        }
        this.mediaServerService.delete(id);
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        return result;
    }

    @ApiOperation(value="\u91cd\u542f\u670d\u52a1")
    @GetMapping(value={"/restart"})
    @ResponseBody
    public Object restart() {
        Thread restartThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        restartThread.setDaemon(false);
        restartThread.start();
        return "success";
    }

    @ApiOperation(value="\u7248\u672c\u4fe1\u606f")
    @GetMapping(value={"/version"})
    @ResponseBody
    public WVPResult<VersionPo> getVersion() {
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        result.setData((Object)this.versionInfo.getVersion());
        return result;
    }

    @ApiOperation(value="\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/config"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u914d\u7f6e\u7c7b\u578b\uff08sip, base\uff09", dataTypeClass=String.class)})
    @ResponseBody
    public WVPResult<JSONObject> getVersion(String type) {
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("server.port", (Object)this.serverPort);
        if (StringUtils.isEmpty((Object)type)) {
            jsonObject.put("sip", JSON.toJSON((Object)this.sipConfig));
            jsonObject.put("base", JSON.toJSON((Object)this.userSetup));
        } else {
            switch (type) {
                case "sip": {
                    jsonObject.put("sip", (Object)this.sipConfig);
                    break;
                }
                case "base": {
                    jsonObject.put("base", (Object)this.userSetup);
                    break;
                }
            }
        }
        result.setData((Object)jsonObject);
        return result;
    }
}

