/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.onvif;

import be.teletask.onvif.models.OnvifDevice;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.onvif.IONVIFServer;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"onvif\u8bbe\u5907"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/onvif"})
public class ONVIFController {
    @Autowired
    private DeferredResultHolder resultHolder;
    @Autowired
    private IONVIFServer onvifServer;

    @ApiOperation(value="\u641c\u7d22")
    @ApiImplicitParams(value={@ApiImplicitParam(name="timeout", value="\u8d85\u65f6\u65f6\u95f4", required=true, dataTypeClass=Integer.class)})
    @GetMapping(value={"/search"})
    @ResponseBody
    public DeferredResult<ResponseEntity<WVPResult>> search(@RequestParam(required=false) Integer timeout) {
        DeferredResult result = new DeferredResult(Long.valueOf((long)timeout.intValue() + 10L));
        String uuid = UUID.randomUUID().toString();
        result.onTimeout(() -> {
            RequestMessage msg = new RequestMessage();
            msg.setKey("CALLBACK_ONVIF");
            msg.setId(uuid);
            WVPResult wvpResult = new WVPResult();
            wvpResult.setCode(0);
            wvpResult.setMsg("\u641c\u7d22\u8d85\u65f6");
            msg.setData((Object)wvpResult);
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put("CALLBACK_ONVIF", uuid, result);
        this.onvifServer.search(timeout.intValue(), (errorCode, onvifDevices) -> {
            RequestMessage msg = new RequestMessage();
            msg.setId("CALLBACK_ONVIF" + uuid);
            WVPResult resultData = new WVPResult();
            resultData.setCode(errorCode);
            if (errorCode == 0) {
                resultData.setMsg("success");
                resultData.setData(onvifDevices);
            } else {
                resultData.setMsg("fail");
            }
            msg.setData((Object)resultData);
            msg.setData((Object)resultData);
            this.resultHolder.invokeResult(msg);
        });
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6onvif\u7684rtsp\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="timeout", value="\u8d85\u65f6\u65f6\u95f4", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="hostname", value="onvif\u5730\u5740", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="username", value="\u7528\u6237\u540d", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="password", value="\u5bc6\u7801", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/rtsp"})
    @ResponseBody
    public DeferredResult<ResponseEntity<WVPResult>> getRTSPUrl(@RequestParam(value="timeout", required=false, defaultValue="3000") Integer timeout, @RequestParam(required=true) String hostname, @RequestParam(required=false) String username, @RequestParam(required=false) String password) {
        DeferredResult result = new DeferredResult(Long.valueOf((long)timeout.intValue() + 10L));
        String uuid = UUID.randomUUID().toString();
        result.onTimeout(() -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey("CALLBACK_ONVIF");
            WVPResult wvpResult = new WVPResult();
            wvpResult.setCode(0);
            wvpResult.setMsg("\u83b7\u53d6onvif\u7684rtsp\u5730\u5740\u8d85\u65f6");
            msg.setData((Object)wvpResult);
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put("CALLBACK_ONVIF", uuid, result);
        OnvifDevice onvifDevice = new OnvifDevice(hostname, username, password);
        this.onvifServer.getRTSPUrl(timeout.intValue(), onvifDevice, (errorCode, url) -> {
            RequestMessage msg = new RequestMessage();
            msg.setId("CALLBACK_ONVIF" + uuid);
            WVPResult resultData = new WVPResult();
            resultData.setCode(errorCode);
            if (errorCode == 0) {
                resultData.setMsg("success");
                resultData.setData(url);
            } else {
                resultData.setMsg(url);
            }
            msg.setData((Object)resultData);
            this.resultHolder.invokeResult(msg);
        });
        return result;
    }
}

