/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.ptz;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u4e91\u53f0\u63a7\u5236"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/ptz"})
public class PtzController {
    private static final Logger logger = LoggerFactory.getLogger(PtzController.class);
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private DeferredResultHolder resultHolder;

    @ApiOperation(value="\u4e91\u53f0\u63a7\u5236")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class), @ApiImplicitParam(name="command", value="\u63a7\u5236\u6307\u4ee4,\u5141\u8bb8\u503c: left, right, up, down, upleft, upright, downleft, downright, zoomin, zoomout, stop", dataTypeClass=String.class), @ApiImplicitParam(name="horizonSpeed", value="\u6c34\u5e73\u901f\u5ea6", dataTypeClass=Integer.class), @ApiImplicitParam(name="verticalSpeed", value="\u5782\u76f4\u901f\u5ea6", dataTypeClass=Integer.class), @ApiImplicitParam(name="zoomSpeed", value="\u7f29\u653e\u901f\u5ea6", dataTypeClass=Integer.class)})
    @PostMapping(value={"/control/{deviceId}/{channelId}"})
    public ResponseEntity<String> ptz(@PathVariable String deviceId, @PathVariable String channelId, String command, int horizonSpeed, int verticalSpeed, int zoomSpeed) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u8bbe\u5907\u4e91\u53f0\u63a7\u5236 API\u8c03\u7528\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s \uff0ccommand\uff1a%s \uff0chorizonSpeed\uff1a%d \uff0cverticalSpeed\uff1a%d \uff0czoomSpeed\uff1a%d", deviceId, channelId, command, horizonSpeed, verticalSpeed, zoomSpeed));
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        int cmdCode = 0;
        switch (command) {
            case "left": {
                cmdCode = 2;
                break;
            }
            case "right": {
                cmdCode = 1;
                break;
            }
            case "up": {
                cmdCode = 8;
                break;
            }
            case "down": {
                cmdCode = 4;
                break;
            }
            case "upleft": {
                cmdCode = 10;
                break;
            }
            case "upright": {
                cmdCode = 9;
                break;
            }
            case "downleft": {
                cmdCode = 6;
                break;
            }
            case "downright": {
                cmdCode = 5;
                break;
            }
            case "zoomin": {
                cmdCode = 16;
                break;
            }
            case "zoomout": {
                cmdCode = 32;
                break;
            }
            case "stop": {
                cmdCode = 0;
                break;
            }
        }
        this.cmder.frontEndCmd(device, channelId, cmdCode, horizonSpeed, verticalSpeed, zoomSpeed);
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @ApiOperation(value="\u901a\u7528\u524d\u7aef\u63a7\u5236\u547d\u4ee4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class), @ApiImplicitParam(name="cmdCode", value="\u6307\u4ee4\u7801", dataTypeClass=Integer.class), @ApiImplicitParam(name="parameter1", value="\u6570\u636e\u4e00", dataTypeClass=Integer.class), @ApiImplicitParam(name="parameter2", value="\u6570\u636e\u4e8c", dataTypeClass=Integer.class), @ApiImplicitParam(name="combindCode2", value="\u7ec4\u5408\u7801\u4e8c", dataTypeClass=Integer.class)})
    @PostMapping(value={"/front_end_command/{deviceId}/{channelId}"})
    public ResponseEntity<String> frontEndCommand(@PathVariable String deviceId, @PathVariable String channelId, int cmdCode, int parameter1, int parameter2, int combindCode2) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u8bbe\u5907\u4e91\u53f0\u63a7\u5236 API\u8c03\u7528\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s \uff0ccmdCode\uff1a%d parameter1\uff1a%d parameter2\uff1a%d", deviceId, channelId, cmdCode, parameter1, parameter2));
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        this.cmder.frontEndCmd(device, channelId, cmdCode, parameter1, parameter2, combindCode2);
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @ApiOperation(value="\u9884\u7f6e\u4f4d\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class)})
    @GetMapping(value={"/preset/query/{deviceId}/{channelId}"})
    public DeferredResult<ResponseEntity<String>> presetQueryApi(@PathVariable String deviceId, @PathVariable String channelId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u9884\u7f6e\u4f4d\u67e5\u8be2API\u8c03\u7528");
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String uuid = UUID.randomUUID().toString();
        String key = "CALLBACK_PRESETQUERY" + (StringUtils.isEmpty((Object)channelId) ? deviceId : channelId);
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u83b7\u53d6\u8bbe\u5907\u9884\u7f6e\u4f4d\u8d85\u65f6", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"\u83b7\u53d6\u8bbe\u5907\u9884\u7f6e\u4f4d\u8d85\u65f6");
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put(key, uuid, result);
        if (this.resultHolder.exist(key, null)) {
            return result;
        }
        this.cmder.presetQuery(device, channelId, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u83b7\u53d6\u8bbe\u5907\u9884\u7f6e\u4f4d\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        return result;
    }
}

