/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.playback;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IPlayService;
import com.genersoft.iot.vmp.service.bean.SSRCInfo;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u5386\u53f2\u5a92\u4f53\u4e0b\u8f7d"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/download"})
public class DownloadController {
    private static final Logger logger = LoggerFactory.getLogger(DownloadController.class);
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private IPlayService playService;
    @Autowired
    private DeferredResultHolder resultHolder;
    @Autowired
    private IMediaServerService mediaServerService;

    @ApiOperation(value="\u5f00\u59cb\u5386\u53f2\u5a92\u4f53\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", dataTypeClass=String.class), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", dataTypeClass=String.class), @ApiImplicitParam(name="downloadSpeed", value="\u4e0b\u8f7d\u500d\u901f", dataTypeClass=String.class)})
    @GetMapping(value={"/start/{deviceId}/{channelId}"})
    public DeferredResult<ResponseEntity<String>> play(@PathVariable String deviceId, @PathVariable String channelId, String startTime, String endTime, String downloadSpeed) {
        MediaServerItem newMediaServerItem;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u5386\u53f2\u5a92\u4f53\u4e0b\u8f7d API\u8c03\u7528\uff0cdeviceId\uff1a%s\uff0cchannelId\uff1a%s\uff0cdownloadSpeed\uff1a%s", deviceId, channelId, downloadSpeed));
        }
        String key = "CALLBACK_PLAY" + deviceId + channelId;
        String uuid = UUID.randomUUID().toString();
        DeferredResult result = new DeferredResult(Long.valueOf(30000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u8bbe\u5907\u4e0b\u8f7d\u54cd\u5e94\u8d85\u65f6\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s", deviceId, channelId));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout");
            this.resultHolder.invokeAllResult(msg);
        });
        if (this.resultHolder.exist(key, null)) {
            return result;
        }
        this.resultHolder.put(key, uuid, result);
        Device device = this.storager.queryVideoDevice(deviceId);
        StreamInfo streamInfo = this.redisCatchStorage.queryPlaybackByDevice(deviceId, channelId);
        if (streamInfo != null) {
            this.cmder.streamByeCmd(deviceId, channelId);
        }
        if ((newMediaServerItem = this.playService.getNewMediaServerItem(device)) == null) {
            logger.warn(String.format("\u8bbe\u5907\u4e0b\u8f7d\u54cd\u5e94\u8d85\u65f6\uff0cdeviceId\uff1a%s \uff0cchannelId\uff1a%s", deviceId, channelId));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout");
            this.resultHolder.invokeAllResult(msg);
            return result;
        }
        SSRCInfo ssrcInfo = this.mediaServerService.openRTPServer(newMediaServerItem, null, true);
        this.cmder.downloadStreamCmd(newMediaServerItem, ssrcInfo, device, channelId, startTime, endTime, downloadSpeed, (mediaServerItem, response) -> {
            logger.info("\u6536\u5230\u8ba2\u9605\u6d88\u606f\uff1a " + response.toJSONString());
            this.playService.onPublishHandlerForPlayBack(mediaServerItem, response, deviceId, channelId, uuid.toString());
        }, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u56de\u653e\u5931\u8d25\uff0c \u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeAllResult(msg);
        });
        return result;
    }

    @ApiOperation(value="\u505c\u6b62\u5386\u53f2\u5a92\u4f53\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class)})
    @GetMapping(value={"/stop/{deviceId}/{channelId}"})
    public ResponseEntity<String> playStop(@PathVariable String deviceId, @PathVariable String channelId) {
        this.cmder.streamByeCmd(deviceId, channelId);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u8bbe\u5907\u5386\u53f2\u5a92\u4f53\u4e0b\u8f7d\u505c\u6b62 API\u8c03\u7528\uff0cdeviceId/channelId\uff1a%s_%s", deviceId, channelId));
        }
        if (deviceId != null && channelId != null) {
            JSONObject json = new JSONObject();
            json.put("deviceId", (Object)deviceId);
            json.put("channelId", (Object)channelId);
            return new ResponseEntity((Object)json.toString(), HttpStatus.OK);
        }
        logger.warn("\u8bbe\u5907\u5386\u53f2\u5a92\u4f53\u4e0b\u8f7d\u505c\u6b62API\u8c03\u7528\u5931\u8d25\uff01");
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

