/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.platform;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.ISIPCommanderForPlatform;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.vmanager.gb28181.platform.bean.ChannelReduce;
import com.genersoft.iot.vmp.vmanager.gb28181.platform.bean.UpdateChannelParam;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ea7\u8054\u5e73\u53f0\u7ba1\u7406"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/platform"})
public class PlatformController {
    private static final Logger logger = LoggerFactory.getLogger(PlatformController.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private ISIPCommanderForPlatform commanderForPlatform;
    @Autowired
    private SipConfig sipConfig;

    @ApiOperation(value="\u83b7\u53d6\u56fd\u6807\u670d\u52a1\u7684\u914d\u7f6e")
    @GetMapping(value={"/server_config"})
    public ResponseEntity<JSONObject> serverConfig() {
        JSONObject result = new JSONObject();
        result.put("deviceIp", (Object)this.sipConfig.getIp());
        result.put("devicePort", (Object)this.sipConfig.getPort());
        result.put("username", (Object)this.sipConfig.getId());
        result.put("password", (Object)this.sipConfig.getPassword());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ea7\u8054\u5e73\u53f0")
    @GetMapping(value={"/query/{count}/{page}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u6761\u6570", dataTypeClass=Integer.class)})
    public PageInfo<ParentPlatform> platforms(@PathVariable int page, @PathVariable int count) {
        return this.storager.queryParentPlatformList(page, count);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e0a\u7ea7\u5e73\u53f0\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="parentPlatform", value="\u4e0a\u7ea7\u5e73\u53f0\u4fe1\u606f", dataTypeClass=ParentPlatform.class)})
    @PostMapping(value={"/save"})
    @ResponseBody
    public ResponseEntity<String> savePlatform(@RequestBody ParentPlatform parentPlatform) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4fdd\u5b58\u4e0a\u7ea7\u5e73\u53f0\u4fe1\u606fAPI\u8c03\u7528");
        }
        if (StringUtils.isEmpty((Object)parentPlatform.getName()) || StringUtils.isEmpty((Object)parentPlatform.getServerGBId()) || StringUtils.isEmpty((Object)parentPlatform.getServerGBDomain()) || StringUtils.isEmpty((Object)parentPlatform.getServerIP()) || StringUtils.isEmpty((Object)parentPlatform.getServerPort()) || StringUtils.isEmpty((Object)parentPlatform.getDeviceGBId()) || StringUtils.isEmpty((Object)parentPlatform.getExpires()) || StringUtils.isEmpty((Object)parentPlatform.getKeepTimeout()) || StringUtils.isEmpty((Object)parentPlatform.getTransport()) || StringUtils.isEmpty((Object)parentPlatform.getCharacterSet())) {
            return new ResponseEntity((Object)"missing parameters", HttpStatus.BAD_REQUEST);
        }
        ParentPlatform parentPlatformOld = this.storager.queryParentPlatByServerGBId(parentPlatform.getServerGBId());
        boolean updateResult = this.storager.updateParentPlatform(parentPlatform);
        if (updateResult) {
            if (parentPlatform.isEnable()) {
                this.commanderForPlatform.register(parentPlatform, null, null);
            } else if (parentPlatformOld != null && parentPlatformOld.isEnable() && !parentPlatform.isEnable()) {
                this.commanderForPlatform.unregister(parentPlatform, null, null);
            }
            return new ResponseEntity((Object)"success", HttpStatus.OK);
        }
        return new ResponseEntity((Object)"fail", HttpStatus.OK);
    }

    @ApiOperation(value="\u5220\u9664\u4e0a\u7ea7\u5e73\u53f0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="serverGBId", value="\u4e0a\u7ea7\u5e73\u53f0\u56fd\u6807ID", dataTypeClass=String.class)})
    @DeleteMapping(value={"/delete/{serverGBId}"})
    @ResponseBody
    public ResponseEntity<String> deletePlatform(@PathVariable String serverGBId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5220\u9664\u4e0a\u7ea7\u5e73\u53f0API\u8c03\u7528");
        }
        if (StringUtils.isEmpty((Object)serverGBId)) {
            return new ResponseEntity((Object)"missing parameters", HttpStatus.BAD_REQUEST);
        }
        ParentPlatform parentPlatform = this.storager.queryParentPlatByServerGBId(serverGBId);
        if (parentPlatform == null) {
            return new ResponseEntity((Object)"fail", HttpStatus.OK);
        }
        this.commanderForPlatform.unregister(parentPlatform, event -> {
            this.redisCatchStorage.delPlatformCatchInfo(parentPlatform.getServerGBId());
            this.redisCatchStorage.delPlatformKeepalive(parentPlatform.getServerGBId());
            this.redisCatchStorage.delPlatformRegister(parentPlatform.getServerGBId());
        }, event -> {
            this.redisCatchStorage.delPlatformCatchInfo(parentPlatform.getServerGBId());
            this.redisCatchStorage.delPlatformKeepalive(parentPlatform.getServerGBId());
            this.redisCatchStorage.delPlatformRegister(parentPlatform.getServerGBId());
        });
        boolean deleteResult = this.storager.deleteParentPlatform(parentPlatform);
        if (deleteResult) {
            return new ResponseEntity((Object)"success", HttpStatus.OK);
        }
        return new ResponseEntity((Object)"fail", HttpStatus.OK);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0a\u7ea7\u5e73\u53f0\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="serverGBId", value="\u4e0a\u7ea7\u5e73\u53f0\u56fd\u6807ID", dataTypeClass=String.class)})
    @GetMapping(value={"/exit/{serverGBId}"})
    @ResponseBody
    public ResponseEntity<String> exitPlatform(@PathVariable String serverGBId) {
        ParentPlatform parentPlatform = this.storager.queryParentPlatByServerGBId(serverGBId);
        return new ResponseEntity((Object)String.valueOf(parentPlatform != null), HttpStatus.OK);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ea7\u8054\u5e73\u53f0\u7684\u6240\u6709\u6240\u6709\u901a\u9053")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u6761\u6570", dataTypeClass=Integer.class), @ApiImplicitParam(name="platformId", value="\u4e0a\u7ea7\u5e73\u53f0ID", dataTypeClass=String.class), @ApiImplicitParam(name="query", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="online", value="\u662f\u5426\u5728\u7ebf", dataTypeClass=Boolean.class), @ApiImplicitParam(name="choosed", value="\u662f\u5426\u5df2\u9009\u4e2d", dataTypeClass=Boolean.class), @ApiImplicitParam(name="channelType", value="\u901a\u9053\u7c7b\u578b", dataTypeClass=Boolean.class)})
    @GetMapping(value={"/channel_list"})
    @ResponseBody
    public PageInfo<ChannelReduce> channelList(int page, int count, @RequestParam(required=false) String platformId, @RequestParam(required=false) String query, @RequestParam(required=false) Boolean online, @RequestParam(required=false) Boolean choosed, @RequestParam(required=false) Boolean channelType) {
        PageInfo channelReduces = null;
        channelReduces = platformId != null ? this.storager.queryAllChannelList(page, count, query, online, channelType, platformId, choosed) : this.storager.queryAllChannelList(page, count, query, online, channelType, null, Boolean.valueOf(false));
        return channelReduces;
    }

    @ApiOperation(value="\u5411\u4e0a\u7ea7\u5e73\u53f0\u6dfb\u52a0\u56fd\u6807\u901a\u9053")
    @ApiImplicitParams(value={@ApiImplicitParam(name="param", value="\u901a\u9053\u5173\u8054\u53c2\u6570", dataTypeClass=UpdateChannelParam.class)})
    @PostMapping(value={"/update_channel_for_gb"})
    @ResponseBody
    public ResponseEntity<String> updateChannelForGB(@RequestBody UpdateChannelParam param) {
        int result;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed9\u4e0a\u7ea7\u5e73\u53f0\u6dfb\u52a0\u56fd\u6807\u901a\u9053API\u8c03\u7528");
        }
        return new ResponseEntity((Object)String.valueOf((result = this.storager.updateChannelForGB(param.getPlatformId(), param.getChannelReduces())) > 0), HttpStatus.OK);
    }

    @ApiOperation(value="\u4ece\u4e0a\u7ea7\u5e73\u53f0\u79fb\u9664\u56fd\u6807\u901a\u9053")
    @ApiImplicitParams(value={@ApiImplicitParam(name="param", value="\u901a\u9053\u5173\u8054\u53c2\u6570", dataTypeClass=UpdateChannelParam.class)})
    @DeleteMapping(value={"/del_channel_for_gb"})
    @ResponseBody
    public ResponseEntity<String> delChannelForGB(@RequestBody UpdateChannelParam param) {
        int result;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed9\u4e0a\u7ea7\u5e73\u53f0\u5220\u9664\u56fd\u6807\u901a\u9053API\u8c03\u7528");
        }
        return new ResponseEntity((Object)String.valueOf((result = this.storager.delChannelForGB(param.getPlatformId(), param.getChannelReduces())) > 0), HttpStatus.OK);
    }
}

