/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.device;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.vmanager.gb28181.device.DeviceQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u56fd\u6807\u8bbe\u5907\u63a7\u5236"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/device/control"})
public class DeviceControl {
    private static final Logger logger = LoggerFactory.getLogger(DeviceQuery.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private DeferredResultHolder resultHolder;

    @ApiOperation(value="\u8fdc\u7a0b\u542f\u52a8\u63a7\u5236\u547d\u4ee4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/teleboot/{deviceId}"})
    public ResponseEntity<String> teleBootApi(@PathVariable String deviceId) {
        Device device;
        boolean sucsess;
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u8fdc\u7a0b\u542f\u52a8API\u8c03\u7528");
        }
        if (sucsess = this.cmder.teleBootCmd(device = this.storager.queryVideoDevice(deviceId))) {
            JSONObject json = new JSONObject();
            json.put("DeviceID", (Object)deviceId);
            json.put("Result", (Object)"OK");
            return new ResponseEntity((Object)json.toJSONString(), HttpStatus.OK);
        }
        logger.warn("\u8bbe\u5907\u8fdc\u7a0b\u542f\u52a8API\u8c03\u7528\u5931\u8d25\uff01");
        return new ResponseEntity((Object)"\u8bbe\u5907\u8fdc\u7a0b\u542f\u52a8API\u8c03\u7528\u5931\u8d25\uff01", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="\u5f55\u50cf\u63a7\u5236\u547d\u4ee4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053\u7f16\u7801", dataTypeClass=String.class), @ApiImplicitParam(name="recordCmdStr", value="\u547d\u4ee4\uff0c \u53ef\u9009\u503c\uff1aRecord\uff08\u624b\u52a8\u5f55\u50cf\uff09\uff0cStopRecord\uff08\u505c\u6b62\u624b\u52a8\u5f55\u50cf\uff09", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/record/{deviceId}/{recordCmdStr}"})
    public DeferredResult<ResponseEntity<String>> recordApi(@PathVariable String deviceId, @PathVariable String recordCmdStr, String channelId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u59cb/\u505c\u6b62\u5f55\u50cfAPI\u8c03\u7528");
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String uuid = UUID.randomUUID().toString();
        String key = "CALLBACK_DEVICECONTROL" + deviceId + channelId;
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u5f00\u59cb/\u505c\u6b62\u5f55\u50cf\u64cd\u4f5c\u8d85\u65f6, \u8bbe\u5907\u672a\u8fd4\u56de\u5e94\u7b54\u6307\u4ee4", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setId(uuid);
            msg.setData((Object)"Timeout. Device did not response to this command.");
            this.resultHolder.invokeAllResult(msg);
        });
        if (this.resultHolder.exist(key, null)) {
            return result;
        }
        this.resultHolder.put(key, uuid, result);
        this.cmder.recordCmd(device, channelId, recordCmdStr, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u5f00\u59cb/\u505c\u6b62\u5f55\u50cf\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeAllResult(msg);
        });
        return result;
    }

    @ApiOperation(value="\u5e03\u9632/\u64a4\u9632\u547d\u4ee4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053\u7f16\u7801", dataTypeClass=String.class), @ApiImplicitParam(name="guardCmdStr", value="\u547d\u4ee4\uff0c \u53ef\u9009\u503c\uff1aSetGuard\uff08\u5e03\u9632\uff09\uff0cResetGuard\uff08\u64a4\u9632\uff09", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/guard/{deviceId}/{guardCmdStr}"})
    public DeferredResult<ResponseEntity<String>> guardApi(@PathVariable String deviceId, String channelId, @PathVariable String guardCmdStr) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e03\u9632/\u64a4\u9632API\u8c03\u7528");
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String key = "CALLBACK_DEVICECONTROL" + deviceId + channelId;
        String uuid = UUID.randomUUID().toString();
        this.cmder.guardCmd(device, guardCmdStr, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u5e03\u9632/\u64a4\u9632\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        this.resultHolder.put(key, uuid, result);
        result.onTimeout(() -> {
            logger.warn(String.format("\u5e03\u9632/\u64a4\u9632\u64cd\u4f5c\u8d85\u65f6, \u8bbe\u5907\u672a\u8fd4\u56de\u5e94\u7b54\u6307\u4ee4", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setId(uuid);
            msg.setData((Object)"Timeout. Device did not response to this command.");
            this.resultHolder.invokeResult(msg);
        });
        return result;
    }

    @ApiOperation(value="\u62a5\u8b66\u590d\u4f4d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053\u7f16\u7801", dataTypeClass=String.class), @ApiImplicitParam(name="alarmMethod", value="\u62a5\u8b66\u65b9\u5f0f", dataTypeClass=String.class), @ApiImplicitParam(name="alarmType", value="\u62a5\u8b66\u7c7b\u578b", dataTypeClass=String.class)})
    @GetMapping(value={"/reset_alarm/{deviceId}"})
    public DeferredResult<ResponseEntity<String>> resetAlarmApi(@PathVariable String deviceId, String channelId, @RequestParam(required=false) String alarmMethod, @RequestParam(required=false) String alarmType) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u62a5\u8b66\u590d\u4f4dAPI\u8c03\u7528");
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String uuid = UUID.randomUUID().toString();
        String key = "CALLBACK_DEVICECONTROL" + deviceId + channelId;
        this.cmder.alarmCmd(device, alarmMethod, alarmType, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u62a5\u8b66\u590d\u4f4d\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u62a5\u8b66\u590d\u4f4d\u64cd\u4f5c\u8d85\u65f6, \u8bbe\u5907\u672a\u8fd4\u56de\u5e94\u7b54\u6307\u4ee4", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout. Device did not response to this command.");
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put(key, uuid, result);
        return result;
    }

    @ApiOperation(value="\u5f3a\u5236\u5173\u952e\u5e27")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/i_frame/{deviceId}"})
    public ResponseEntity<String> iFrame(@PathVariable String deviceId, @RequestParam(required=false) String channelId) {
        Device device;
        boolean sucsess;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f3a\u5236\u5173\u952e\u5e27API\u8c03\u7528");
        }
        if (sucsess = this.cmder.iFrameCmd(device = this.storager.queryVideoDevice(deviceId), channelId)) {
            JSONObject json = new JSONObject();
            json.put("DeviceID", (Object)deviceId);
            json.put("ChannelID", (Object)channelId);
            json.put("Result", (Object)"OK");
            return new ResponseEntity((Object)json.toJSONString(), HttpStatus.OK);
        }
        logger.warn("\u5f3a\u5236\u5173\u952e\u5e27API\u8c03\u7528\u5931\u8d25\uff01");
        return new ResponseEntity((Object)"\u5f3a\u5236\u5173\u952e\u5e27API\u8c03\u7528\u5931\u8d25\uff01", HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="\u770b\u5b88\u4f4d\u63a7\u5236")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053\u7f16\u7801", dataTypeClass=String.class), @ApiImplicitParam(name="enabled", value="\u662f\u5426\u5f00\u542f\u770b\u5b88\u4f4d 1:\u5f00\u542f,0:\u5173\u95ed", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="resetTime", value="\u81ea\u52a8\u5f52\u4f4d\u65f6\u95f4\u95f4\u9694", dataTypeClass=String.class), @ApiImplicitParam(name="presetIndex", value="\u8c03\u7528\u9884\u7f6e\u4f4d\u7f16\u53f7", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class)})
    @GetMapping(value={"/home_position/{deviceId}/{enabled}"})
    public DeferredResult<ResponseEntity<String>> homePositionApi(@PathVariable String deviceId, @PathVariable String enabled, @RequestParam(required=false) String resetTime, @RequestParam(required=false) String presetIndex, String channelId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u62a5\u8b66\u590d\u4f4dAPI\u8c03\u7528");
        }
        String key = "CALLBACK_DEVICECONTROL" + (StringUtils.isEmpty((Object)channelId) ? deviceId : channelId);
        String uuid = UUID.randomUUID().toString();
        Device device = this.storager.queryVideoDevice(deviceId);
        this.cmder.homePositionCmd(device, channelId, enabled, resetTime, presetIndex, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u770b\u5b88\u4f4d\u63a7\u5236\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u770b\u5b88\u4f4d\u63a7\u5236\u64cd\u4f5c\u8d85\u65f6, \u8bbe\u5907\u672a\u8fd4\u56de\u5e94\u7b54\u6307\u4ee4", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            JSONObject json = new JSONObject();
            json.put("DeviceID", (Object)deviceId);
            json.put("Status", (Object)"Timeout");
            json.put("Description", (Object)"\u770b\u5b88\u4f4d\u63a7\u5236\u64cd\u4f5c\u8d85\u65f6, \u8bbe\u5907\u672a\u8fd4\u56de\u5e94\u7b54\u6307\u4ee4");
            msg.setData((Object)json);
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put(key, uuid, result);
        return result;
    }
}

