/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.device;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.vmanager.gb28181.device.DeviceQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u56fd\u6807\u8bbe\u5907\u914d\u7f6e"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/device/config"})
public class DeviceConfig {
    private static final Logger logger = LoggerFactory.getLogger(DeviceQuery.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private DeferredResultHolder resultHolder;

    @ApiOperation(value="\u57fa\u672c\u914d\u7f6e\u8bbe\u7f6e\u547d\u4ee4")
    @GetMapping(value={"/basicParam/{deviceId}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class), @ApiImplicitParam(name="name", value="\u540d\u79f0", dataTypeClass=String.class), @ApiImplicitParam(name="expiration", value="\u5230\u671f\u65f6\u95f4", dataTypeClass=String.class), @ApiImplicitParam(name="heartBeatInterval", value="\u5fc3\u8df3\u95f4\u9694", dataTypeClass=String.class), @ApiImplicitParam(name="heartBeatCount", value="\u5fc3\u8df3\u8ba1\u6570", dataTypeClass=String.class)})
    public DeferredResult<ResponseEntity<String>> homePositionApi(@PathVariable String deviceId, String channelId, @RequestParam(required=false) String name, @RequestParam(required=false) String expiration, @RequestParam(required=false) String heartBeatInterval, @RequestParam(required=false) String heartBeatCount) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u62a5\u8b66\u590d\u4f4dAPI\u8c03\u7528");
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String uuid = UUID.randomUUID().toString();
        String key = "CALLBACK_DEVICECONFIG" + deviceId + channelId;
        this.cmder.deviceBasicConfigCmd(device, channelId, name, expiration, heartBeatInterval, heartBeatCount, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u8bbe\u5907\u914d\u7f6e\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u8bbe\u5907\u914d\u7f6e\u64cd\u4f5c\u8d85\u65f6, \u8bbe\u5907\u672a\u8fd4\u56de\u5e94\u7b54\u6307\u4ee4", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            JSONObject json = new JSONObject();
            json.put("DeviceID", (Object)deviceId);
            json.put("Status", (Object)"Timeout");
            json.put("Description", (Object)"\u8bbe\u5907\u914d\u7f6e\u64cd\u4f5c\u8d85\u65f6, \u8bbe\u5907\u672a\u8fd4\u56de\u5e94\u7b54\u6307\u4ee4");
            msg.setData((Object)json);
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put(key, uuid, result);
        return result;
    }

    @ApiOperation(value="\u8bbe\u5907\u914d\u7f6e\u67e5\u8be2\u8bf7\u6c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", dataTypeClass=String.class), @ApiImplicitParam(name="channelId", value="\u901a\u9053ID", dataTypeClass=String.class), @ApiImplicitParam(name="configType", value="\u914d\u7f6e\u7c7b\u578b", dataTypeClass=String.class)})
    @GetMapping(value={"/query/{deviceId}/{configType}"})
    public DeferredResult<ResponseEntity<String>> configDownloadApi(@PathVariable String deviceId, @PathVariable String configType, @RequestParam(required=false) String channelId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u72b6\u6001\u67e5\u8be2API\u8c03\u7528");
        }
        String key = "CALLBACK_CONFIGDOWNLOAD" + (StringUtils.isEmpty((Object)channelId) ? deviceId : channelId);
        String uuid = UUID.randomUUID().toString();
        Device device = this.storager.queryVideoDevice(deviceId);
        this.cmder.deviceConfigQuery(device, channelId, configType, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u83b7\u53d6\u8bbe\u5907\u914d\u7f6e\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        DeferredResult result = new DeferredResult(Long.valueOf(3000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u83b7\u53d6\u8bbe\u5907\u914d\u7f6e\u8d85\u65f6", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout. Device did not response to this command.");
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put(key, uuid, result);
        return result;
    }
}

