/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.alarm;

import com.genersoft.iot.vmp.gb28181.bean.DeviceAlarm;
import com.genersoft.iot.vmp.service.IDeviceAlarmService;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u62a5\u8b66\u4fe1\u606f\u7ba1\u7406"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/alarm"})
public class AlarmController {
    @Autowired
    private IDeviceAlarmService deviceAlarmService;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u62a5\u8b66")
    @GetMapping(value={"/all"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907id", dataTypeClass=String.class), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u67e5\u8be2\u6570\u91cf", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="alarmPriority", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="alarmMethod", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="alarmMethod", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="alarmType", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="startTime", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="endTime", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class)})
    public ResponseEntity<PageInfo<DeviceAlarm>> getAll(@RequestParam int page, @RequestParam int count, @RequestParam(required=false) String deviceId, @RequestParam(required=false) String alarmPriority, @RequestParam(required=false) String alarmMethod, @RequestParam(required=false) String alarmType, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) {
        if (StringUtils.isEmpty((Object)alarmPriority)) {
            alarmPriority = null;
        }
        if (StringUtils.isEmpty((Object)alarmMethod)) {
            alarmMethod = null;
        }
        if (StringUtils.isEmpty((Object)alarmType)) {
            alarmType = null;
        }
        if (StringUtils.isEmpty((Object)startTime)) {
            startTime = null;
        }
        if (StringUtils.isEmpty((Object)endTime)) {
            endTime = null;
        }
        try {
            if (startTime != null) {
                this.format.parse(startTime);
            }
            if (endTime != null) {
                this.format.parse(endTime);
            }
        }
        catch (ParseException e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        PageInfo allAlarm = this.deviceAlarmService.getAllAlarm(page, count, deviceId, alarmPriority, alarmMethod, alarmType, startTime, endTime);
        return new ResponseEntity((Object)allAlarm, HttpStatus.OK);
    }

    @ApiOperation(value="\u5220\u9664\u62a5\u8b66")
    @DeleteMapping(value={"/delete"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataTypeClass=Integer.class), @ApiImplicitParam(name="deviceIds", value="\u591a\u4e2a\u8bbe\u5907id,\u9017\u53f7\u5206\u9694", required=false, dataTypeClass=String.class), @ApiImplicitParam(name="time", value="\u7ed3\u675f\u65f6\u95f4", required=false, dataTypeClass=String.class)})
    public ResponseEntity<WVPResult<String>> delete(@RequestParam(required=false) Integer id, @RequestParam(required=false) String deviceIds, @RequestParam(required=false) String time) {
        if (StringUtils.isEmpty((Object)id)) {
            id = null;
        }
        if (StringUtils.isEmpty((Object)deviceIds)) {
            deviceIds = null;
        }
        if (StringUtils.isEmpty((Object)time)) {
            time = null;
        }
        try {
            if (time != null) {
                this.format.parse(time);
            }
        }
        catch (ParseException e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        List<String> deviceIdList = null;
        if (deviceIds != null) {
            String[] deviceIdArray = deviceIds.split(",");
            deviceIdList = Arrays.asList(deviceIdArray);
        }
        int count = this.deviceAlarmService.clearAlarmBeforeTime(id, deviceIdList, time);
        WVPResult wvpResult = new WVPResult();
        wvpResult.setCode(0);
        wvpResult.setMsg("success");
        wvpResult.setData((Object)count);
        return new ResponseEntity((Object)wvpResult, HttpStatus.OK);
    }
}

