/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.gb28181.MobilePosition;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.MobilePosition;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Api(tags={"\u4f4d\u7f6e\u4fe1\u606f\u7ba1\u7406"})
@CrossOrigin
@RestController
@RequestMapping(value={"/api/position"})
public class MobilePositionController {
    private static final Logger logger = LoggerFactory.getLogger(MobilePositionController.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private SIPCommander cmder;
    @Autowired
    private DeferredResultHolder resultHolder;

    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u8f68\u8ff9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="start", value="\u5f00\u59cb\u65f6\u95f4", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="end", value="\u7ed3\u675f\u65f6\u95f4", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/history/{deviceId}"})
    public ResponseEntity<List<MobilePosition>> positions(@PathVariable String deviceId, @RequestParam(required=false) String start, @RequestParam(required=false) String end) {
        if (StringUtil.isEmpty((String)start)) {
            start = null;
        }
        if (StringUtil.isEmpty((String)end)) {
            end = null;
        }
        List result = this.storager.queryMobilePositions(deviceId, start, end);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u6700\u65b0\u4f4d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/latest/{deviceId}"})
    public ResponseEntity<MobilePosition> latestPosition(@PathVariable String deviceId) {
        MobilePosition result = this.storager.queryLatestPosition(deviceId);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="\u83b7\u53d6\u79fb\u52a8\u4f4d\u7f6e\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class)})
    @GetMapping(value={"/realtime/{deviceId}"})
    public DeferredResult<ResponseEntity<MobilePosition>> realTimePosition(@PathVariable String deviceId) {
        Device device = this.storager.queryVideoDevice(deviceId);
        String uuid = UUID.randomUUID().toString();
        String key = "CALLBACK_MOBILEPOSITION" + deviceId;
        this.cmder.mobilePostitionQuery(device, event -> {
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)String.format("\u83b7\u53d6\u79fb\u52a8\u4f4d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a %s, %s", event.statusCode, event.msg));
            this.resultHolder.invokeResult(msg);
        });
        DeferredResult result = new DeferredResult(Long.valueOf(5000L));
        result.onTimeout(() -> {
            logger.warn(String.format("\u83b7\u53d6\u79fb\u52a8\u4f4d\u7f6e\u4fe1\u606f\u8d85\u65f6", new Object[0]));
            RequestMessage msg = new RequestMessage();
            msg.setId(uuid);
            msg.setKey(key);
            msg.setData((Object)"Timeout");
            this.resultHolder.invokeResult(msg);
        });
        this.resultHolder.put(key, uuid, result);
        return result;
    }

    @ApiOperation(value="\u8ba2\u9605\u4f4d\u7f6e\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceId", value="\u8bbe\u5907ID", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="expires", value="\u8ba2\u9605\u8d85\u65f6\u65f6\u95f4", dataTypeClass=String.class), @ApiImplicitParam(name="interval", value="\u4e0a\u62a5\u65f6\u95f4\u95f4\u9694", dataTypeClass=String.class)})
    @GetMapping(value={"/subscribe/{deviceId}"})
    public ResponseEntity<String> positionSubscribe(@PathVariable String deviceId, @RequestParam String expires, @RequestParam String interval) {
        String msg = (expires.equals("0") ? "\u53d6\u6d88" : "") + "\u8ba2\u9605\u8bbe\u5907" + deviceId + "\u7684\u79fb\u52a8\u4f4d\u7f6e";
        if (logger.isDebugEnabled()) {
            logger.debug(msg);
        }
        if (StringUtil.isEmpty((String)interval)) {
            interval = "5";
        }
        Device device = this.storager.queryVideoDevice(deviceId);
        String result = msg;
        result = this.cmder.mobilePositionSubscribe(device, Integer.parseInt(expires), Integer.parseInt(interval)) ? result + "\uff0c\u6210\u529f" : result + "\uff0c\u5931\u8d25";
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

