/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.media.zlm.dto.StreamProxyItem;
import com.genersoft.iot.vmp.service.IGbStreamService;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IStreamProxyService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.storager.dao.GbStreamMapper;
import com.genersoft.iot.vmp.storager.dao.PlatformGbStreamMapper;
import com.genersoft.iot.vmp.storager.dao.StreamProxyMapper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreamProxyServiceImpl
implements IStreamProxyService {
    private static final Logger logger = LoggerFactory.getLogger(StreamProxyServiceImpl.class);
    @Autowired
    private IVideoManagerStorager videoManagerStorager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    @Autowired
    private StreamProxyMapper streamProxyMapper;
    @Autowired
    private GbStreamMapper gbStreamMapper;
    @Autowired
    private PlatformGbStreamMapper platformGbStreamMapper;
    @Autowired
    private IGbStreamService gbStreamService;
    @Autowired
    private IMediaServerService mediaServerService;

    public String save(StreamProxyItem param) {
        JSONObject jsonObject;
        MediaServerItem mediaInfo = "auto".equals(param.getMediaServerId()) ? this.mediaServerService.getMediaServerForMinimumLoad() : this.mediaServerService.getOne(param.getMediaServerId());
        if (mediaInfo == null) {
            logger.warn("\u4fdd\u5b58\u4ee3\u7406\u672a\u627e\u5230\u5728\u7ebf\u7684ZLM...");
            return "\u4fdd\u5b58\u5931\u8d25";
        }
        String dstUrl = String.format("rtmp://%s:%s/%s/%s", "127.0.0.1", mediaInfo.getRtmpPort(), param.getApp(), param.getStream());
        param.setDst_url(dstUrl);
        StringBuffer result = new StringBuffer();
        boolean streamLive = false;
        param.setMediaServerId(mediaInfo.getId());
        if (this.videoManagerStorager.queryStreamProxy(param.getApp(), param.getStream()) != null) {
            if (this.videoManagerStorager.updateStreamProxy(param)) {
                result.append("\u4fdd\u5b58\u6210\u529f");
                if (param.isEnable() && (jsonObject = this.addStreamProxyToZlm(param)) == null) {
                    result.append(", \u4f46\u662f\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u5730\u5740\u662f\u5426\u53ef\u7528");
                    param.setEnable(false);
                    this.videoManagerStorager.updateStreamProxy(param);
                }
            }
        } else if (this.videoManagerStorager.addStreamProxy(param)) {
            result.append("\u4fdd\u5b58\u6210\u529f");
            streamLive = true;
            if (param.isEnable() && (jsonObject = this.addStreamProxyToZlm(param)) == null) {
                streamLive = false;
                result.append(", \u4f46\u662f\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u5730\u5740\u662f\u5426\u53ef\u7528");
                param.setEnable(false);
                this.videoManagerStorager.updateStreamProxy(param);
            }
        } else {
            result.append("\u4fdd\u5b58\u5931\u8d25");
        }
        if (param.getPlatformGbId() != null && streamLive) {
            ArrayList<StreamProxyItem> gbStreams = new ArrayList<StreamProxyItem>();
            gbStreams.add(param);
            if (this.gbStreamService.addPlatformInfo(gbStreams, param.getPlatformGbId())) {
                result.append(",  \u5173\u8054\u56fd\u6807\u5e73\u53f0[ " + param.getPlatformGbId() + " ]\u6210\u529f");
            } else {
                result.append(",  \u5173\u8054\u56fd\u6807\u5e73\u53f0[ " + param.getPlatformGbId() + " ]\u5931\u8d25");
            }
        }
        return result.toString();
    }

    public JSONObject addStreamProxyToZlm(StreamProxyItem param) {
        JSONObject result = null;
        MediaServerItem mediaServerItem = null;
        if (param.getMediaServerId() == null) {
            logger.warn("\u6dfb\u52a0\u4ee3\u7406\u65f6MediaServerId \u4e3anull");
            return null;
        }
        mediaServerItem = this.mediaServerService.getOne(param.getMediaServerId());
        if ("default".equals(param.getType())) {
            result = this.zlmresTfulUtils.addStreamProxy(mediaServerItem, param.getApp(), param.getStream(), param.getUrl(), param.isEnable_hls(), param.isEnable_mp4(), param.getRtp_type());
        } else if ("ffmpeg".equals(param.getType())) {
            result = this.zlmresTfulUtils.addFFmpegSource(mediaServerItem, param.getSrc_url(), param.getDst_url(), param.getTimeout_ms() + "", param.isEnable_hls(), param.isEnable_mp4(), param.getFfmpeg_cmd_key());
        }
        return result;
    }

    public JSONObject removeStreamProxyFromZlm(StreamProxyItem param) {
        if (param == null) {
            return null;
        }
        MediaServerItem mediaServerItem = this.mediaServerService.getOne(param.getMediaServerId());
        JSONObject result = this.zlmresTfulUtils.closeStreams(mediaServerItem, param.getApp(), param.getStream());
        return result;
    }

    public PageInfo<StreamProxyItem> getAll(Integer page, Integer count) {
        return this.videoManagerStorager.queryStreamProxyList(page, count);
    }

    public void del(String app, String stream) {
        StreamProxyItem streamProxyItem = this.videoManagerStorager.queryStreamProxy(app, stream);
        if (streamProxyItem != null) {
            this.videoManagerStorager.deleteStreamProxy(app, stream);
            JSONObject jsonObject = this.removeStreamProxyFromZlm(streamProxyItem);
            if (jsonObject != null && jsonObject.getInteger("code") == 0) {
                this.gbStreamMapper.del(app, stream);
                this.platformGbStreamMapper.delByAppAndStream(app, stream);
            }
        }
    }

    public boolean start(String app, String stream) {
        boolean result = false;
        StreamProxyItem streamProxy = this.videoManagerStorager.queryStreamProxy(app, stream);
        if (!streamProxy.isEnable() && streamProxy != null) {
            JSONObject jsonObject = this.addStreamProxyToZlm(streamProxy);
            if (jsonObject == null) {
                return false;
            }
            if (jsonObject.getInteger("code") == 0) {
                result = true;
                streamProxy.setEnable(true);
                this.videoManagerStorager.updateStreamProxy(streamProxy);
            }
        }
        return result;
    }

    public boolean stop(String app, String stream) {
        JSONObject jsonObject;
        boolean result = false;
        StreamProxyItem streamProxyDto = this.videoManagerStorager.queryStreamProxy(app, stream);
        if (streamProxyDto != null && streamProxyDto.isEnable() && (jsonObject = this.removeStreamProxyFromZlm(streamProxyDto)).getInteger("code") == 0) {
            streamProxyDto.setEnable(false);
            result = this.videoManagerStorager.updateStreamProxy(streamProxyDto);
        }
        return result;
    }

    public JSONObject getFFmpegCMDs(MediaServerItem mediaServerItem) {
        JSONObject result = new JSONObject();
        JSONObject mediaServerConfigResuly = this.zlmresTfulUtils.getMediaServerConfig(mediaServerItem);
        if (mediaServerConfigResuly != null && mediaServerConfigResuly.getInteger("code") == 0 && mediaServerConfigResuly.getJSONArray("data").size() > 0) {
            JSONObject mediaServerConfig = mediaServerConfigResuly.getJSONArray("data").getJSONObject(0);
            for (String key : mediaServerConfig.keySet()) {
                if (!key.startsWith("ffmpeg.cmd")) continue;
                result.put(key, (Object)mediaServerConfig.getString(key));
            }
        }
        return result;
    }
}

