/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.conf.MediaConfig;
import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.session.SsrcConfig;
import com.genersoft.iot.vmp.gb28181.session.VideoStreamSessionManager;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.ZLMRTPServerFactory;
import com.genersoft.iot.vmp.media.zlm.ZLMServerConfig;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.bean.SSRCInfo;
import com.genersoft.iot.vmp.storager.dao.MediaServerMapper;
import com.genersoft.iot.vmp.utils.redis.JedisUtil;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=2)
public class MediaServerServiceImpl
implements IMediaServerService,
CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(MediaServerServiceImpl.class);
    @Autowired
    private SipConfig sipConfig;
    @Value(value="${server.ssl.enabled:false}")
    private boolean sslEnabled;
    @Value(value="${server.port}")
    private String serverPort;
    @Autowired
    private MediaConfig mediaConfig;
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    @Autowired
    private MediaServerMapper mediaServerMapper;
    @Autowired
    private VideoStreamSessionManager streamSession;
    @Autowired
    private ZLMRTPServerFactory zlmrtpServerFactory;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    JedisUtil jedisUtil;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void run(String ... args) throws Exception {
        logger.info("Media Server \u7f13\u5b58\u521d\u59cb\u5316");
        List mediaServerItemList = this.mediaServerMapper.queryAll();
        for (MediaServerItem mediaServerItem : mediaServerItemList) {
            String key;
            if (mediaServerItem.getSsrcConfig() == null) {
                SsrcConfig ssrcConfig = new SsrcConfig(mediaServerItem.getId(), null, this.sipConfig.getDomain());
                mediaServerItem.setSsrcConfig(ssrcConfig);
                this.redisUtil.set("VMP_MEDIA_SERVER_" + mediaServerItem.getId(), (Object)mediaServerItem);
            }
            if (this.redisUtil.hasKey(key = "VMP_MEDIA_SERVER_" + mediaServerItem.getId())) continue;
            this.redisUtil.set(key, (Object)mediaServerItem);
        }
    }

    public SSRCInfo openRTPServer(MediaServerItem mediaServerItem, String streamId) {
        return this.openRTPServer(mediaServerItem, streamId, false);
    }

    public SSRCInfo openRTPServer(MediaServerItem mediaServerItem, String streamId, boolean isPlayback) {
        if (mediaServerItem == null || mediaServerItem.getId() == null) {
            return null;
        }
        String key = "VMP_MEDIA_SERVER_" + mediaServerItem.getId();
        SsrcConfig ssrcConfig = mediaServerItem.getSsrcConfig();
        if (ssrcConfig == null) {
            logger.info("media server [ {} ] ssrcConfig is null", (Object)mediaServerItem.getId());
            return null;
        }
        String ssrc = null;
        ssrc = isPlayback ? ssrcConfig.getPlayBackSsrc() : ssrcConfig.getPlaySsrc();
        if (streamId == null) {
            streamId = String.format("%08x", Integer.parseInt(ssrc)).toUpperCase();
        }
        int rtpServerPort = mediaServerItem.getRtpProxyPort();
        if (mediaServerItem.isRtpEnable()) {
            rtpServerPort = this.zlmrtpServerFactory.createRTPServer(mediaServerItem, streamId);
        }
        this.redisUtil.set(key, (Object)mediaServerItem);
        return new SSRCInfo(rtpServerPort, ssrc, streamId);
    }

    public void closeRTPServer(Device device, String channelId) {
        String mediaServerId = this.streamSession.getMediaServerId(device.getDeviceId(), channelId);
        MediaServerItem mediaServerItem = this.getOne(mediaServerId);
        if (mediaServerItem != null) {
            String streamId = String.format("%s_%s", device.getDeviceId(), channelId);
            this.zlmrtpServerFactory.closeRTPServer(mediaServerItem, streamId);
            this.releaseSsrc(mediaServerItem, this.streamSession.getSSRC(device.getDeviceId(), channelId));
        }
        this.streamSession.remove(device.getDeviceId(), channelId);
    }

    public void releaseSsrc(MediaServerItem mediaServerItem, String ssrc) {
        if (mediaServerItem == null || ssrc == null) {
            return;
        }
        SsrcConfig ssrcConfig = mediaServerItem.getSsrcConfig();
        ssrcConfig.releaseSsrc(ssrc);
        mediaServerItem.setSsrcConfig(ssrcConfig);
        String key = "VMP_MEDIA_SERVER_" + mediaServerItem.getId();
        this.redisUtil.set(key, (Object)mediaServerItem);
    }

    public void clearRTPServer(MediaServerItem mediaServerItem) {
        mediaServerItem.setSsrcConfig(new SsrcConfig(mediaServerItem.getId(), null, this.sipConfig.getDomain()));
        this.redisUtil.zAdd((Object)"VMP_MEDIA_ONLINE_SERVERS", (Object)mediaServerItem.getId(), 0.0);
    }

    public void update(MediaServerItem mediaSerItem) {
        this.mediaServerMapper.update(mediaSerItem);
        MediaServerItem mediaServerItemInRedis = this.getOne(mediaSerItem.getId());
        MediaServerItem mediaServerItemInDataBase = this.mediaServerMapper.queryOne(mediaSerItem.getId());
        if (mediaServerItemInRedis != null && mediaServerItemInRedis.getSsrcConfig() != null) {
            mediaServerItemInDataBase.setSsrcConfig(mediaServerItemInRedis.getSsrcConfig());
        } else {
            mediaServerItemInDataBase.setSsrcConfig(new SsrcConfig(mediaServerItemInDataBase.getId(), null, this.sipConfig.getDomain()));
        }
        String key = "VMP_MEDIA_SERVER_" + mediaServerItemInDataBase.getId();
        this.redisUtil.set(key, (Object)mediaServerItemInDataBase);
    }

    public List<MediaServerItem> getAll() {
        ArrayList<MediaServerItem> result = new ArrayList<MediaServerItem>();
        List mediaServerKeys = this.redisUtil.scan(String.format("%S*", "VMP_MEDIA_SERVER_"));
        String onlineKey = "VMP_MEDIA_ONLINE_SERVERS";
        for (Object mediaServerKey : mediaServerKeys) {
            String key = (String)mediaServerKey;
            MediaServerItem mediaServerItem = (MediaServerItem)this.redisUtil.get(key);
            if (this.redisUtil.zScore((Object)onlineKey, (Object)mediaServerItem.getId()) != null) {
                mediaServerItem.setStatus(true);
            }
            result.add(mediaServerItem);
        }
        return result;
    }

    public List<MediaServerItem> getAllFromDatabase() {
        return this.mediaServerMapper.queryAll();
    }

    public List<MediaServerItem> getAllOnline() {
        String key = "VMP_MEDIA_ONLINE_SERVERS";
        Set mediaServerIdSet = this.redisUtil.zRevRange((Object)key, 0, -1);
        ArrayList<MediaServerItem> result = new ArrayList<MediaServerItem>();
        if (mediaServerIdSet != null && mediaServerIdSet.size() > 0) {
            for (String mediaServerId : mediaServerIdSet) {
                String serverKey = "VMP_MEDIA_SERVER_" + mediaServerId;
                result.add((MediaServerItem)this.redisUtil.get(serverKey));
            }
        }
        return result;
    }

    public MediaServerItem getOne(String mediaServerId) {
        if (mediaServerId == null) {
            return null;
        }
        String key = "VMP_MEDIA_SERVER_" + mediaServerId;
        return (MediaServerItem)this.redisUtil.get(key);
    }

    public MediaServerItem getOneByHostAndPort(String host, int port) {
        return this.mediaServerMapper.queryOneByHostAndPort(host, port);
    }

    public void clearMediaServerForOnline() {
        String key = "VMP_MEDIA_ONLINE_SERVERS";
        this.redisUtil.del(new String[]{key});
    }

    public WVPResult<String> add(MediaServerItem mediaServerItem) {
        WVPResult result = new WVPResult();
        mediaServerItem.setCreateTime(this.format.format(System.currentTimeMillis()));
        mediaServerItem.setUpdateTime(this.format.format(System.currentTimeMillis()));
        JSONObject responseJSON = this.zlmresTfulUtils.getMediaServerConfig(mediaServerItem);
        if (responseJSON != null) {
            JSONArray data = responseJSON.getJSONArray("data");
            if (data != null && data.size() > 0) {
                ZLMServerConfig zlmServerConfig = (ZLMServerConfig)JSON.parseObject((String)JSON.toJSONString((Object)data.get(0)), ZLMServerConfig.class);
                if (this.mediaServerMapper.queryOne(zlmServerConfig.getGeneralMediaServerId()) != null) {
                    result.setCode(-1);
                    result.setMsg("\u4fdd\u5b58\u5931\u8d25\uff0c\u5a92\u4f53\u670d\u52a1ID [ " + zlmServerConfig.getGeneralMediaServerId() + " ] \u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5a92\u4f53\u670d\u52a1\u5668\u914d\u7f6e");
                    return result;
                }
                zlmServerConfig.setIp(mediaServerItem.getIp());
                this.handLeZLMServerConfig(zlmServerConfig);
                result.setCode(0);
                result.setMsg("success");
            } else {
                result.setCode(-1);
                result.setMsg("\u8fde\u63a5\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u8fde\u63a5\u5931\u8d25");
        }
        return result;
    }

    public void handLeZLMServerConfig(ZLMServerConfig zlmServerConfig) {
        logger.info("[ {} ]-[ {}:{} ]\u5df2\u8fde\u63a5", new Object[]{zlmServerConfig.getGeneralMediaServerId(), zlmServerConfig.getIp(), zlmServerConfig.getHttpPort()});
        MediaServerItem serverItem = this.mediaServerMapper.queryOne(zlmServerConfig.getGeneralMediaServerId());
        if (serverItem == null) {
            serverItem = this.mediaServerMapper.queryOneByHostAndPort(zlmServerConfig.getIp(), zlmServerConfig.getHttpPort());
        }
        if (zlmServerConfig.getGeneralMediaServerId().equals(this.mediaConfig.getId()) || zlmServerConfig.getIp().equals(this.mediaConfig.getIp()) && zlmServerConfig.getHttpPort() == this.mediaConfig.getHttpPort()) {
            MediaServerItem serverItemFromConfig = this.mediaConfig.getMediaSerItem();
            serverItemFromConfig.setId(zlmServerConfig.getGeneralMediaServerId());
            if (this.mediaConfig.getHttpPort() == 0) {
                serverItemFromConfig.setHttpPort(zlmServerConfig.getHttpPort());
            }
            if (this.mediaConfig.getHttpSSlPort() == 0) {
                serverItemFromConfig.setHttpSSlPort(zlmServerConfig.getHttpSSLport());
            }
            if (this.mediaConfig.getRtmpPort() == 0) {
                serverItemFromConfig.setRtmpPort(zlmServerConfig.getRtmpPort());
            }
            if (this.mediaConfig.getRtmpSSlPort() == 0) {
                serverItemFromConfig.setRtmpSSlPort(zlmServerConfig.getRtmpSslPort());
            }
            if (this.mediaConfig.getRtspPort() == 0) {
                serverItemFromConfig.setRtspPort(zlmServerConfig.getRtspPort());
            }
            if (this.mediaConfig.getRtspSSLPort() == 0) {
                serverItemFromConfig.setRtspSSLPort(zlmServerConfig.getRtspSSlport());
            }
            if (this.mediaConfig.getRtpProxyPort() == 0) {
                serverItemFromConfig.setRtpProxyPort(zlmServerConfig.getRtpProxyPort());
            }
            if (serverItem != null) {
                this.mediaServerMapper.delDefault();
                this.mediaServerMapper.add(serverItemFromConfig);
                String key = "VMP_MEDIA_SERVER_" + serverItemFromConfig.getId();
                MediaServerItem serverItemInRedis = (MediaServerItem)this.redisUtil.get(key);
                if (serverItemInRedis != null) {
                    serverItemFromConfig.setSsrcConfig(serverItemInRedis.getSsrcConfig());
                } else {
                    serverItemFromConfig.setSsrcConfig(new SsrcConfig(serverItemFromConfig.getId(), null, this.sipConfig.getDomain()));
                }
                this.redisUtil.set(key, (Object)serverItemFromConfig);
            } else {
                String key = "VMP_MEDIA_SERVER_" + serverItemFromConfig.getId();
                serverItemFromConfig.setSsrcConfig(new SsrcConfig(serverItemFromConfig.getId(), null, this.sipConfig.getDomain()));
                this.redisUtil.set(key, (Object)serverItemFromConfig);
                this.mediaServerMapper.add(serverItemFromConfig);
            }
            this.resetOnlineServerItem(serverItemFromConfig);
            this.setZLMConfig(serverItemFromConfig);
        } else {
            String now = this.format.format(System.currentTimeMillis());
            if (serverItem == null) {
                serverItem = new MediaServerItem(zlmServerConfig, this.sipConfig.getIp());
                serverItem.setCreateTime(now);
                serverItem.setUpdateTime(now);
                String key = "VMP_MEDIA_SERVER_" + serverItem.getId();
                serverItem.setSsrcConfig(new SsrcConfig(serverItem.getId(), null, this.sipConfig.getDomain()));
                this.redisUtil.set(key, (Object)serverItem);
                this.mediaServerMapper.add(serverItem);
                this.setZLMConfig(serverItem);
            }
            this.resetOnlineServerItem(serverItem);
        }
    }

    public void resetOnlineServerItem(MediaServerItem serverItem) {
        String key = "VMP_MEDIA_ONLINE_SERVERS";
        if (this.redisUtil.zScore((Object)key, (Object)serverItem.getId()) == null) {
            this.redisUtil.zAdd((Object)key, (Object)serverItem.getId(), 0.0);
            this.zlmresTfulUtils.getMediaList(serverItem, null, null, "rtmp", mediaList -> {
                JSONArray data;
                Integer code = mediaList.getInteger("code");
                if (code == 0 && (data = mediaList.getJSONArray("data")) != null) {
                    this.redisUtil.zAdd((Object)key, (Object)serverItem.getId(), (double)data.size());
                }
            });
        } else {
            this.clearRTPServer(serverItem);
        }
    }

    public void addCount(String mediaServerId) {
        if (mediaServerId == null) {
            return;
        }
        String key = "VMP_MEDIA_ONLINE_SERVERS";
        this.redisUtil.zIncrScore((Object)key, (Object)mediaServerId, 1.0);
    }

    public void removeCount(String mediaServerId) {
        String key = "VMP_MEDIA_ONLINE_SERVERS";
        this.redisUtil.zIncrScore((Object)key, (Object)mediaServerId, -1.0);
    }

    public MediaServerItem getMediaServerForMinimumLoad() {
        String key = "VMP_MEDIA_ONLINE_SERVERS";
        if (this.redisUtil.zSize((Object)key) == null || this.redisUtil.zSize((Object)key) == 0L) {
            logger.info("\u83b7\u53d6\u8d1f\u8f7d\u6700\u4f4e\u7684\u8282\u70b9\u65f6\u65e0\u5728\u7ebf\u8282\u70b9");
            return null;
        }
        Set objects = this.redisUtil.ZRange((Object)key, 0, -1);
        ArrayList mediaServerObjectS = new ArrayList(objects);
        String mediaServerId = (String)mediaServerObjectS.get(0);
        return this.getOne(mediaServerId);
    }

    public void setZLMConfig(MediaServerItem mediaServerItem) {
        logger.info("[ {} ]-[ {}:{} ]\u8bbe\u7f6ezlm", new Object[]{mediaServerItem.getId(), mediaServerItem.getIp(), mediaServerItem.getHttpPort()});
        String protocol = this.sslEnabled ? "https" : "http";
        String hookPrex = String.format("%s://%s:%s/index/hook", protocol, mediaServerItem.getHookIp(), this.serverPort);
        String recordHookPrex = null;
        if (mediaServerItem.getRecordAssistPort() != 0) {
            recordHookPrex = String.format("http://127.0.0.1:%s/api/record", mediaServerItem.getRecordAssistPort());
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("api.secret", mediaServerItem.getSecret());
        param.put("ffmpeg.cmd", "%s -fflags nobuffer -i %s -c:a aac -strict -2 -ar 44100 -ab 48k -c:v libx264  -f flv %s");
        param.put("hook.enable", "1");
        param.put("hook.on_flow_report", "");
        param.put("hook.on_play", String.format("%s/on_play", hookPrex));
        param.put("hook.on_http_access", "");
        param.put("hook.on_publish", String.format("%s/on_publish", hookPrex));
        param.put("hook.on_record_mp4", recordHookPrex != null ? String.format("%s/on_record_mp4", recordHookPrex) : "");
        param.put("hook.on_record_ts", "");
        param.put("hook.on_rtsp_auth", "");
        param.put("hook.on_rtsp_realm", "");
        param.put("hook.on_server_started", String.format("%s/on_server_started", hookPrex));
        param.put("hook.on_shell_login", String.format("%s/on_shell_login", hookPrex));
        param.put("hook.on_stream_changed", String.format("%s/on_stream_changed", hookPrex));
        param.put("hook.on_stream_none_reader", String.format("%s/on_stream_none_reader", hookPrex));
        param.put("hook.on_stream_not_found", String.format("%s/on_stream_not_found", hookPrex));
        param.put("hook.timeoutSec", "20");
        param.put("general.streamNoneReaderDelayMS", "-1".equals(mediaServerItem.getStreamNoneReaderDelayMS()) ? "3600000" : mediaServerItem.getStreamNoneReaderDelayMS());
        JSONObject responseJSON = this.zlmresTfulUtils.setServerConfig(mediaServerItem, param);
        if (responseJSON != null && responseJSON.getInteger("code") == 0) {
            logger.info("[ {} ]-[ {}:{} ]\u8bbe\u7f6ezlm\u6210\u529f", new Object[]{mediaServerItem.getId(), mediaServerItem.getIp(), mediaServerItem.getHttpPort()});
        } else {
            logger.info("[ {} ]-[ {}:{} ]\u8bbe\u7f6ezlm\u5931\u8d25", new Object[]{mediaServerItem.getId(), mediaServerItem.getIp(), mediaServerItem.getHttpPort()});
        }
    }

    public WVPResult<MediaServerItem> checkMediaServer(String ip, int port, String secret) {
        WVPResult result = new WVPResult();
        if (this.mediaServerMapper.queryOneByHostAndPort(ip, port) != null) {
            result.setCode(-1);
            result.setMsg("\u6b64\u8fde\u63a5\u5df2\u5b58\u5728");
            return result;
        }
        MediaServerItem mediaServerItem = new MediaServerItem();
        mediaServerItem.setIp(ip);
        mediaServerItem.setHttpPort(port);
        mediaServerItem.setSecret(secret);
        JSONObject responseJSON = this.zlmresTfulUtils.getMediaServerConfig(mediaServerItem);
        if (responseJSON == null) {
            result.setCode(-1);
            result.setMsg("\u8fde\u63a5\u5931\u8d25");
            return result;
        }
        JSONArray data = responseJSON.getJSONArray("data");
        ZLMServerConfig zlmServerConfig = (ZLMServerConfig)JSON.parseObject((String)JSON.toJSONString((Object)data.get(0)), ZLMServerConfig.class);
        if (zlmServerConfig == null) {
            result.setCode(-1);
            result.setMsg("\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25");
            return result;
        }
        if (this.mediaServerMapper.queryOne(zlmServerConfig.getGeneralMediaServerId()) != null) {
            result.setCode(-1);
            result.setMsg("\u5a92\u4f53\u670d\u52a1ID [" + zlmServerConfig.getGeneralMediaServerId() + " ] \u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5a92\u4f53\u670d\u52a1\u5668\u914d\u7f6e");
            return result;
        }
        mediaServerItem.setHttpSSlPort(zlmServerConfig.getHttpPort());
        mediaServerItem.setRtmpPort(zlmServerConfig.getRtmpPort());
        mediaServerItem.setRtmpSSlPort(zlmServerConfig.getRtmpSslPort());
        mediaServerItem.setRtspPort(zlmServerConfig.getRtspPort());
        mediaServerItem.setRtspSSLPort(zlmServerConfig.getRtspSSlport());
        mediaServerItem.setRtpProxyPort(zlmServerConfig.getRtpProxyPort());
        mediaServerItem.setStreamIp(ip);
        mediaServerItem.setHookIp(this.sipConfig.getIp());
        mediaServerItem.setSdpIp(ip);
        mediaServerItem.setStreamNoneReaderDelayMS(zlmServerConfig.getGeneralStreamNoneReaderDelayMS());
        result.setCode(0);
        result.setMsg("\u6210\u529f");
        result.setData((Object)mediaServerItem);
        return result;
    }

    public boolean checkMediaRecordServer(String ip, int port) {
        boolean result = false;
        OkHttpClient client = new OkHttpClient();
        String url = String.format("http://%s:%s/index/api/record", ip, port);
        FormBody.Builder builder = new FormBody.Builder();
        Request request = new Request.Builder().get().url(url).build();
        try {
            Response response = client.newCall(request).execute();
            if (response != null) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void delete(String id) {
        this.redisUtil.zRemove((Object)"VMP_MEDIA_ONLINE_SERVERS", (Object)id);
        String key = "VMP_MEDIA_SERVER_" + id;
        this.redisUtil.del(new String[]{key});
        this.mediaServerMapper.delOne(id);
    }
}

