/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.service.bean;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.ISIPCommander;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import javax.sip.ResponseEvent;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogSubscribeTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(CatalogSubscribeTask.class);
    private Device device;
    private ISIPCommander sipCommander;

    public CatalogSubscribeTask(Device device, ISIPCommander sipCommander) {
        this.device = device;
        this.sipCommander = sipCommander;
    }

    @Override
    public void run() {
        this.sipCommander.catalogSubscribe(this.device, eventResult -> {
            ResponseEvent event = (ResponseEvent)eventResult.event;
            Element rootElement = null;
            try {
                rootElement = XmlUtil.getRootElement((byte[])event.getResponse().getRawContent(), (String)"gb2312");
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            Element resultElement = rootElement.element("Result");
            String result = resultElement.getText();
            if (result.toUpperCase().equals("OK")) {
                this.logger.info("\u76ee\u5f55\u8ba2\u9605\u6210\u529f\uff1a {}", (Object)this.device.getDeviceId());
            } else {
                this.logger.info("\u76ee\u5f55\u8ba2\u9605\u5931\u8d25\uff1a {}-{}", (Object)this.device.getDeviceId(), (Object)result);
            }
        }, eventResult -> this.logger.warn("\u76ee\u5f55\u8ba2\u9605\u5931\u8d25\uff1a {}-\u4fe1\u4ee4\u53d1\u9001\u5931\u8d25", (Object)this.device.getDeviceId()));
    }
}

