/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.media.zlm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.SendRtpItem;
import com.genersoft.iot.vmp.media.zlm.ZLMRESTfulUtils;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ZLMRTPServerFactory {
    private Logger logger = LoggerFactory.getLogger((String)"ZLMRTPServerFactory");
    @Autowired
    private ZLMRESTfulUtils zlmresTfulUtils;
    private int[] portRangeArray = new int[2];

    public int createRTPServer(MediaServerItem mediaServerItem, String streamId) {
        JSONArray data;
        HashMap<String, Integer> currentStreams = new HashMap<String, Integer>();
        JSONObject listRtpServerJsonResult = this.zlmresTfulUtils.listRtpServer(mediaServerItem);
        if (listRtpServerJsonResult != null && (data = listRtpServerJsonResult.getJSONArray("data")) != null) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject dataItem = data.getJSONObject(i);
                currentStreams.put(dataItem.getString("stream_id"), dataItem.getInteger("port"));
            }
        }
        if (currentStreams.get(streamId) != null) {
            HashMap<String, String> closeRtpServerParam = new HashMap<String, String>();
            closeRtpServerParam.put("stream_id", streamId);
            this.zlmresTfulUtils.closeRtpServer(mediaServerItem, closeRtpServerParam);
            currentStreams.remove(streamId);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        int result = -1;
        if (StringUtils.isEmpty((Object)mediaServerItem.getSendRtpPortRange())) {
            param.put("port", 0);
        } else {
            int newPort = this.getPortFromportRange(mediaServerItem);
            param.put("port", newPort);
        }
        param.put("enable_tcp", 1);
        param.put("stream_id", streamId);
        JSONObject openRtpServerResultJson = this.zlmresTfulUtils.openRtpServer(mediaServerItem, param);
        if (openRtpServerResultJson != null) {
            switch (openRtpServerResultJson.getInteger("code")) {
                case 0: {
                    result = openRtpServerResultJson.getInteger("port");
                    break;
                }
                case -300: {
                    HashMap<String, String> closeRtpServerParam = new HashMap<String, String>();
                    closeRtpServerParam.put("stream_id", streamId);
                    this.zlmresTfulUtils.closeRtpServer(mediaServerItem, closeRtpServerParam);
                    result = this.createRTPServer(mediaServerItem, streamId);
                    break;
                }
                case -400: {
                    result = this.createRTPServer(mediaServerItem, streamId);
                    break;
                }
                default: {
                    this.logger.error("\u521b\u5efaRTP Server \u5931\u8d25 {}: " + openRtpServerResultJson.getString("msg"), param.get("port"));
                    break;
                }
            }
        } else {
            this.logger.error("\u521b\u5efaRTP Server \u5931\u8d25 {}: \u8bf7\u68c0\u67e5ZLM\u670d\u52a1", param.get("port"));
        }
        return result;
    }

    public boolean closeRTPServer(MediaServerItem serverItem, String streamId) {
        boolean result = false;
        if (serverItem != null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("stream_id", streamId);
            JSONObject jsonObject = this.zlmresTfulUtils.closeRtpServer(serverItem, param);
            if (jsonObject != null) {
                if (jsonObject.getInteger("code") == 0) {
                    result = jsonObject.getInteger("hit") == 1;
                } else {
                    this.logger.error("\u5173\u95edRTP Server \u5931\u8d25: " + jsonObject.getString("msg"));
                }
            } else {
                this.logger.error("\u5173\u95edRTP Server \u5931\u8d25: \u8bf7\u68c0\u67e5ZLM\u670d\u52a1");
            }
        }
        return result;
    }

    private int getPortFromportRange(MediaServerItem mediaServerItem) {
        int currentPort = mediaServerItem.getCurrentPort();
        if (currentPort == 0) {
            String[] portRangeStrArray = mediaServerItem.getSendRtpPortRange().split(",");
            if (portRangeStrArray.length != 2) {
                this.portRangeArray[0] = 30000;
                this.portRangeArray[1] = 30500;
            } else {
                this.portRangeArray[0] = Integer.parseInt(portRangeStrArray[0]);
                this.portRangeArray[1] = Integer.parseInt(portRangeStrArray[1]);
            }
        }
        if (currentPort == 0 || currentPort++ > this.portRangeArray[1]) {
            currentPort = this.portRangeArray[0];
            mediaServerItem.setCurrentPort(currentPort);
            return this.portRangeArray[0];
        }
        if (currentPort % 2 == 1) {
            ++currentPort;
        }
        mediaServerItem.setCurrentPort(++currentPort);
        return currentPort;
    }

    public SendRtpItem createSendRtpItem(MediaServerItem serverItem, String ip, int port, String ssrc, String platformId, String deviceId, String channelId, boolean tcp) {
        String playSsrc = serverItem.getSsrcConfig().getPlaySsrc();
        int localPort = this.createRTPServer(serverItem, playSsrc);
        if (localPort == -1) {
            this.logger.error("\u6ca1\u6709\u53ef\u7528\u7684\u7aef\u53e3");
            return null;
        }
        serverItem.getSsrcConfig().releaseSsrc(playSsrc);
        this.closeRTPServer(serverItem, playSsrc);
        SendRtpItem sendRtpItem = new SendRtpItem();
        sendRtpItem.setIp(ip);
        sendRtpItem.setPort(port);
        sendRtpItem.setSsrc(ssrc);
        sendRtpItem.setPlatformId(platformId);
        sendRtpItem.setDeviceId(deviceId);
        sendRtpItem.setChannelId(channelId);
        sendRtpItem.setTcp(tcp);
        sendRtpItem.setApp("rtp");
        sendRtpItem.setLocalPort(localPort);
        sendRtpItem.setMediaServerId(serverItem.getId());
        return sendRtpItem;
    }

    public SendRtpItem createSendRtpItem(MediaServerItem serverItem, String ip, int port, String ssrc, String platformId, String app, String stream, String channelId, boolean tcp) {
        String playSsrc = serverItem.getSsrcConfig().getPlaySsrc();
        int localPort = this.createRTPServer(serverItem, playSsrc);
        if (localPort == -1) {
            this.logger.error("\u6ca1\u6709\u53ef\u7528\u7684\u7aef\u53e3");
            return null;
        }
        serverItem.getSsrcConfig().releaseSsrc(ssrc);
        this.closeRTPServer(serverItem, playSsrc);
        SendRtpItem sendRtpItem = new SendRtpItem();
        sendRtpItem.setIp(ip);
        sendRtpItem.setPort(port);
        sendRtpItem.setSsrc(ssrc);
        sendRtpItem.setApp(app);
        sendRtpItem.setStreamId(stream);
        sendRtpItem.setPlatformId(platformId);
        sendRtpItem.setChannelId(channelId);
        sendRtpItem.setTcp(tcp);
        sendRtpItem.setLocalPort(localPort);
        sendRtpItem.setMediaServerId(serverItem.getId());
        return sendRtpItem;
    }

    public Boolean startSendRtpStream(MediaServerItem mediaServerItem, Map<String, Object> param) {
        Boolean result = false;
        JSONObject jsonObject = this.zlmresTfulUtils.startSendRtp(mediaServerItem, param);
        if (jsonObject == null) {
            this.logger.error("RTP\u63a8\u6d41\u5931\u8d25: \u8bf7\u68c0\u67e5ZLM\u670d\u52a1");
        } else if (jsonObject.getInteger("code") == 0) {
            result = true;
            this.logger.info("RTP\u63a8\u6d41[ {}/{} ]\u8bf7\u6c42\u6210\u529f\uff0c\u672c\u5730\u63a8\u6d41\u7aef\u53e3\uff1a{}", new Object[]{param.get("app"), param.get("stream"), jsonObject.getString("local_port")});
        } else {
            this.logger.error("RTP\u63a8\u6d41\u5931\u8d25: " + jsonObject.getString("msg"));
        }
        return result;
    }

    public Boolean isRtpReady(MediaServerItem mediaServerItem, String streamId) {
        JSONObject mediaInfo = this.zlmresTfulUtils.getMediaInfo(mediaServerItem, "rtp", "rtmp", streamId);
        return mediaInfo.getInteger("code") == 0 && mediaInfo.getBoolean("online") != false;
    }

    public Boolean isStreamReady(MediaServerItem mediaServerItem, String app, String streamId) {
        JSONObject mediaInfo = this.zlmresTfulUtils.getMediaInfo(mediaServerItem, app, "rtmp", streamId);
        return mediaInfo.getInteger("code") == 0 && mediaInfo.getBoolean("online") != false;
    }

    public int totalReaderCount(MediaServerItem mediaServerItem, String app, String streamId) {
        JSONObject mediaInfo = this.zlmresTfulUtils.getMediaInfo(mediaServerItem, app, "rtmp", streamId);
        if (mediaInfo == null) {
            return 0;
        }
        return mediaInfo.getInteger("totalReaderCount");
    }

    public Boolean stopSendRtpStream(MediaServerItem mediaServerItem, Map<String, Object> param) {
        Boolean result = false;
        JSONObject jsonObject = this.zlmresTfulUtils.stopSendRtp(mediaServerItem, param);
        if (jsonObject == null) {
            this.logger.error("\u505c\u6b62RTP\u63a8\u6d41\u5931\u8d25: \u8bf7\u68c0\u67e5ZLM\u670d\u52a1");
        } else if (jsonObject.getInteger("code") == 0) {
            result = true;
            this.logger.info("\u505c\u6b62RTP\u63a8\u6d41\u6210\u529f");
        } else {
            this.logger.error("\u505c\u6b62RTP\u63a8\u6d41\u5931\u8d25: " + jsonObject.getString("msg"));
        }
        return result;
    }

    public void closeAllSendRtpStream() {
    }
}

