/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.media.zlm;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.media.zlm.ZLMHttpHookSubscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class ZLMHttpHookSubscribe {
    private Map<HookType, Map<JSONObject, Event>> allSubscribes = new ConcurrentHashMap();

    public void addSubscribe(HookType type, JSONObject hookResponse, Event event) {
        HashMap<JSONObject, Event> eventMap = (HashMap<JSONObject, Event>)this.allSubscribes.get(type);
        if (eventMap == null) {
            eventMap = new HashMap<JSONObject, Event>();
            this.allSubscribes.put(type, eventMap);
        }
        eventMap.put(hookResponse, event);
    }

    public Event getSubscribe(HookType type, JSONObject hookResponse) {
        Event event = null;
        Map eventMap = (Map)this.allSubscribes.get(type);
        if (eventMap == null) {
            return null;
        }
        for (JSONObject key : eventMap.keySet()) {
            Boolean result = null;
            for (String s : key.keySet()) {
                if (result == null) {
                    result = key.getString(s).equals(hookResponse.getString(s));
                    continue;
                }
                if (key.getString(s) == null) continue;
                result = result != false && key.getString(s).equals(hookResponse.getString(s));
            }
            if (null == result || !result.booleanValue()) continue;
            event = (Event)eventMap.get(key);
        }
        return event;
    }

    public void removeSubscribe(HookType type, JSONObject hookResponse) {
        Map eventMap = (Map)this.allSubscribes.get(type);
        if (eventMap == null) {
            return;
        }
        Iterator iterator = eventMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            JSONObject key = (JSONObject)next.getKey();
            Boolean result = null;
            for (String s : key.keySet()) {
                if (result == null) {
                    result = key.getString(s).equals(hookResponse.getString(s));
                    continue;
                }
                if (key.getString(s) == null) continue;
                result = result != false && key.getString(s).equals(hookResponse.getString(s));
            }
            if (null == result || !result.booleanValue()) continue;
            iterator.remove();
        }
    }

    public List<Event> getSubscribes(HookType type) {
        Map eventMap = (Map)this.allSubscribes.get(type);
        if (eventMap == null) {
            return null;
        }
        ArrayList<Event> result = new ArrayList<Event>();
        for (JSONObject key : eventMap.keySet()) {
            result.add((Event)eventMap.get(key));
        }
        return result;
    }
}

