/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.response.impl;

import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatformCatch;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.ISIPCommanderForPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.event.response.ISIPResponseProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.response.SIPResponseProcessorAbstract;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import javax.sip.ResponseEvent;
import javax.sip.header.CallIdHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RegisterResponseProcessor
extends SIPResponseProcessorAbstract {
    private Logger logger = LoggerFactory.getLogger(RegisterResponseProcessor.class);
    private String method = "REGISTER";
    @Autowired
    private ISIPCommanderForPlatform sipCommanderForPlatform;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addResponseProcessor(this.method, (ISIPResponseProcessor)this);
    }

    public void process(ResponseEvent evt) {
        Response response = evt.getResponse();
        CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
        String callId = callIdHeader.getCallId();
        String platformGBId = this.redisCatchStorage.queryPlatformRegisterInfo(callId);
        if (platformGBId == null) {
            this.logger.info(String.format("\u672a\u627e\u5230callId\uff1a %s \u7684\u6ce8\u518c/\u6ce8\u9500\u5e73\u53f0id", callId));
            return;
        }
        ParentPlatformCatch parentPlatformCatch = this.redisCatchStorage.queryPlatformCatchInfo(platformGBId);
        if (parentPlatformCatch == null) {
            this.logger.warn(String.format("\u6536\u5230 %s \u7684\u6ce8\u518c/\u6ce8\u9500%S\u8bf7\u6c42, \u4f46\u662f\u5e73\u53f0\u7f13\u5b58\u4fe1\u606f\u672a\u67e5\u8be2\u5230!!!", platformGBId, response.getStatusCode()));
            return;
        }
        String action = parentPlatformCatch.getParentPlatform().getExpires().equals("0") ? "\u6ce8\u9500" : "\u6ce8\u518c";
        this.logger.info(String.format("\u6536\u5230 %s %s\u7684%S\u54cd\u5e94", platformGBId, action, response.getStatusCode()));
        ParentPlatform parentPlatform = parentPlatformCatch.getParentPlatform();
        if (parentPlatform == null) {
            this.logger.warn(String.format("\u6536\u5230 %s %s\u7684%S\u8bf7\u6c42, \u4f46\u662f\u5e73\u53f0\u4fe1\u606f\u672a\u67e5\u8be2\u5230!!!", platformGBId, action, response.getStatusCode()));
            return;
        }
        if (response.getStatusCode() == 401) {
            WWWAuthenticateHeader www = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate");
            this.sipCommanderForPlatform.register(parentPlatform, callId, www, null, null);
        } else if (response.getStatusCode() == 200) {
            this.logger.info(String.format("%s %s\u6210\u529f", platformGBId, action));
            this.redisCatchStorage.delPlatformRegisterInfo(callId);
            parentPlatform.setStatus("\u6ce8\u518c".equals(action));
            ParentPlatform parentPlatformTmp = this.storager.queryParentPlatByServerGBId(platformGBId);
            String expires = parentPlatformTmp.getExpires();
            parentPlatform.setExpires(expires);
            parentPlatform.setId(parentPlatformTmp.getId());
            this.storager.updateParentPlatformStatus(platformGBId, "\u6ce8\u518c".equals(action));
            this.redisCatchStorage.updatePlatformRegister(parentPlatform);
            this.redisCatchStorage.updatePlatformKeepalive(parentPlatform);
            parentPlatformCatch.setParentPlatform(parentPlatform);
            this.redisCatchStorage.updatePlatformCatchInfo(parentPlatformCatch);
        }
    }
}

