/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.cmd;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.callback.RequestMessage;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.response.ResponseMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BroadcastResponseMessageHandler
extends SIPRequestProcessorParent
implements InitializingBean,
IMessageHandler {
    private Logger logger = LoggerFactory.getLogger(BroadcastResponseMessageHandler.class);
    private final String cmdType = "Broadcast";
    @Autowired
    private ResponseMessageHandler responseMessageHandler;
    @Autowired
    private DeferredResultHolder deferredResultHolder;

    public void afterPropertiesSet() throws Exception {
        this.responseMessageHandler.addHandler("Broadcast", (IMessageHandler)this);
    }

    public void handForDevice(RequestEvent evt, Device device, Element rootElement) {
        try {
            String channelId = XmlUtil.getText((Element)rootElement, (String)"DeviceID");
            String key = "CALLBACK_BROADCAST" + device.getDeviceId() + channelId;
            this.responseAck(evt, 200);
            JSONObject json = new JSONObject();
            XmlUtil.node2Json((Element)rootElement, (JSONObject)json);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(json.toJSONString());
            }
            RequestMessage msg = new RequestMessage();
            msg.setKey(key);
            msg.setData((Object)json);
            this.deferredResultHolder.invokeAllResult(msg);
        }
        catch (ParseException | InvalidArgumentException | SipException e) {
            e.printStackTrace();
        }
    }

    public void handForPlatform(RequestEvent evt, ParentPlatform parentPlatform, Element element) {
    }
}

