/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message;

import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.impl.message.IMessageHandler;
import com.genersoft.iot.vmp.gb28181.utils.SipUtils;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.message.Request;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageRequestProcessor
extends SIPRequestProcessorParent
implements InitializingBean,
ISIPRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MessageRequestProcessor.class);
    private final String method = "MESSAGE";
    private static Map<String, IMessageHandler> messageHandlerMap = new ConcurrentHashMap();
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;
    @Autowired
    private IVideoManagerStorager storage;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addRequestProcessor("MESSAGE", (ISIPRequestProcessor)this);
    }

    public void addHandler(String name, IMessageHandler handler) {
        messageHandlerMap.put(name, handler);
    }

    public void process(RequestEvent evt) {
        logger.debug("\u63a5\u6536\u5230\u6d88\u606f\uff1a" + evt.getRequest());
        String deviceId = SipUtils.getUserIdFromFromHeader((Request)evt.getRequest());
        Device device = this.storage.queryVideoDevice(deviceId);
        ParentPlatform parentPlatform = this.storage.queryParentPlatByServerGBId(deviceId);
        try {
            if (device == null && parentPlatform == null) {
                this.responseAck(evt, 404, "device id not found");
            } else {
                Element rootElement = this.getRootElement(evt);
                String name = rootElement.getName();
                IMessageHandler messageHandler = (IMessageHandler)messageHandlerMap.get(name);
                if (messageHandler != null) {
                    if (device != null) {
                        messageHandler.handForDevice(evt, device, rootElement);
                    } else {
                        messageHandler.handForPlatform(evt, parentPlatform, rootElement);
                    }
                } else {
                    this.responseAck(evt, 415, "Unsupported message type, must Control/Notify/Query/Response");
                }
            }
        }
        catch (SipException e) {
            logger.warn("SIP \u56de\u590d\u9519\u8bef", (Throwable)e);
        }
        catch (InvalidArgumentException e) {
            logger.warn("\u53c2\u6570\u65e0\u6548", (Throwable)e);
        }
        catch (ParseException e) {
            logger.warn("SIP\u56de\u590d\u65f6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        catch (DocumentException e) {
            logger.warn("\u89e3\u6790XML\u6d88\u606f\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
        }
    }
}

