/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl;

import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.header.ExpiresHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubscribeRequestProcessor
extends SIPRequestProcessorParent
implements InitializingBean,
ISIPRequestProcessor {
    private Logger logger = LoggerFactory.getLogger(SubscribeRequestProcessor.class);
    private String method = "SUBSCRIBE";
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addRequestProcessor(this.method, (ISIPRequestProcessor)this);
    }

    public void process(RequestEvent evt) {
        Request request = evt.getRequest();
        try {
            Response response = null;
            response = this.getMessageFactory().createResponse(200, request);
            if (response != null) {
                ExpiresHeader expireHeader = this.getHeaderFactory().createExpiresHeader(30);
                response.setExpires(expireHeader);
            }
            this.logger.info("response : " + response.toString());
            ServerTransaction transaction = this.getServerTransaction(evt);
            if (transaction != null) {
                transaction.sendResponse(response);
                transaction.getDialog().delete();
                transaction.terminate();
            } else {
                this.logger.info("processRequest serverTransactionId is null.");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
    }
}

