/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl;

import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.gb28181.bean.BaiduPoint;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceAlarm;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.gb28181.bean.MobilePosition;
import com.genersoft.iot.vmp.gb28181.event.DeviceOffLineDetector;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.callback.DeferredResultHolder;
import com.genersoft.iot.vmp.gb28181.transmit.cmd.impl.SIPCommander;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.gb28181.utils.NumericUtil;
import com.genersoft.iot.vmp.gb28181.utils.SipUtils;
import com.genersoft.iot.vmp.gb28181.utils.XmlUtil;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.utils.GpsUtil;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.header.FromHeader;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class NotifyRequestProcessor
extends SIPRequestProcessorParent
implements InitializingBean,
ISIPRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(NotifyRequestProcessor.class);
    @Autowired
    private UserSetup userSetup;
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private EventPublisher publisher;
    @Autowired
    private DeviceOffLineDetector offLineDetector;
    private static final String NOTIFY_CATALOG = "Catalog";
    private static final String NOTIFY_ALARM = "Alarm";
    private static final String NOTIFY_MOBILE_POSITION = "MobilePosition";
    private String method = "NOTIFY";
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addRequestProcessor(this.method, (ISIPRequestProcessor)this);
    }

    public void process(RequestEvent evt) {
        try {
            Element rootElement = this.getRootElement(evt);
            String cmd = XmlUtil.getText((Element)rootElement, (String)"CmdType");
            if (NOTIFY_CATALOG.equals(cmd)) {
                logger.info("\u63a5\u6536\u5230Catalog\u901a\u77e5");
                this.processNotifyCatalogList(evt);
            } else if (NOTIFY_ALARM.equals(cmd)) {
                logger.info("\u63a5\u6536\u5230Alarm\u901a\u77e5");
                this.processNotifyAlarm(evt);
            } else if (NOTIFY_MOBILE_POSITION.equals(cmd)) {
                logger.info("\u63a5\u6536\u5230MobilePosition\u901a\u77e5");
                this.processNotifyMobilePosition(evt);
            } else {
                logger.info("\u63a5\u6536\u5230\u6d88\u606f\uff1a" + cmd);
                this.responseAck(evt, 200);
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processNotifyMobilePosition(RequestEvent evt) {
        try {
            Element rootElement = this.getRootElement(evt);
            MobilePosition mobilePosition = new MobilePosition();
            Element deviceIdElement = rootElement.element("DeviceID");
            String deviceId = deviceIdElement.getTextTrim().toString();
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device != null && !StringUtils.isEmpty((Object)device.getName())) {
                mobilePosition.setDeviceName(device.getName());
            }
            mobilePosition.setDeviceId(XmlUtil.getText((Element)rootElement, (String)"DeviceID"));
            mobilePosition.setTime(XmlUtil.getText((Element)rootElement, (String)"Time"));
            mobilePosition.setLongitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Longitude")));
            mobilePosition.setLatitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Latitude")));
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Speed"))) {
                mobilePosition.setSpeed(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Speed")));
            } else {
                mobilePosition.setSpeed(0.0);
            }
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Direction"))) {
                mobilePosition.setDirection(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Direction")));
            } else {
                mobilePosition.setDirection(0.0);
            }
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Altitude"))) {
                mobilePosition.setAltitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Altitude")));
            } else {
                mobilePosition.setAltitude(0.0);
            }
            mobilePosition.setReportSource("Mobile Position");
            BaiduPoint bp = new BaiduPoint();
            bp = GpsUtil.Wgs84ToBd09((String)String.valueOf(mobilePosition.getLongitude()), (String)String.valueOf(mobilePosition.getLatitude()));
            logger.info("\u767e\u5ea6\u5750\u6807\uff1a" + bp.getBdLng() + ", " + bp.getBdLat());
            mobilePosition.setGeodeticSystem("BD-09");
            mobilePosition.setCnLng(bp.getBdLng());
            mobilePosition.setCnLat(bp.getBdLat());
            if (!this.userSetup.getSavePositionHistory().booleanValue()) {
                this.storager.clearMobilePositionsByDeviceId(deviceId);
            }
            this.storager.insertMobilePosition(mobilePosition);
            this.responseAck(evt, 200);
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processNotifyAlarm(RequestEvent evt) {
        try {
            Element rootElement = this.getRootElement(evt);
            Element deviceIdElement = rootElement.element("DeviceID");
            String deviceId = deviceIdElement.getText().toString();
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                return;
            }
            rootElement = this.getRootElement(evt, device.getCharset());
            DeviceAlarm deviceAlarm = new DeviceAlarm();
            deviceAlarm.setDeviceId(deviceId);
            deviceAlarm.setAlarmPriority(XmlUtil.getText((Element)rootElement, (String)"AlarmPriority"));
            deviceAlarm.setAlarmMethod(XmlUtil.getText((Element)rootElement, (String)"AlarmMethod"));
            deviceAlarm.setAlarmTime(XmlUtil.getText((Element)rootElement, (String)"AlarmTime"));
            if (XmlUtil.getText((Element)rootElement, (String)"AlarmDescription") == null) {
                deviceAlarm.setAlarmDescription("");
            } else {
                deviceAlarm.setAlarmDescription(XmlUtil.getText((Element)rootElement, (String)"AlarmDescription"));
            }
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Longitude"))) {
                deviceAlarm.setLongitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Longitude")));
            } else {
                deviceAlarm.setLongitude(0.0);
            }
            if (NumericUtil.isDouble((String)XmlUtil.getText((Element)rootElement, (String)"Latitude"))) {
                deviceAlarm.setLatitude(Double.parseDouble(XmlUtil.getText((Element)rootElement, (String)"Latitude")));
            } else {
                deviceAlarm.setLatitude(0.0);
            }
            if (deviceAlarm.getAlarmMethod().equals("4")) {
                MobilePosition mobilePosition = new MobilePosition();
                mobilePosition.setDeviceId(deviceAlarm.getDeviceId());
                mobilePosition.setTime(deviceAlarm.getAlarmTime());
                mobilePosition.setLongitude(deviceAlarm.getLongitude());
                mobilePosition.setLatitude(deviceAlarm.getLatitude());
                mobilePosition.setReportSource("GPS Alarm");
                BaiduPoint bp = new BaiduPoint();
                bp = GpsUtil.Wgs84ToBd09((String)String.valueOf(mobilePosition.getLongitude()), (String)String.valueOf(mobilePosition.getLatitude()));
                logger.info("\u767e\u5ea6\u5750\u6807\uff1a" + bp.getBdLng() + ", " + bp.getBdLat());
                mobilePosition.setGeodeticSystem("BD-09");
                mobilePosition.setCnLng(bp.getBdLng());
                mobilePosition.setCnLat(bp.getBdLat());
                if (!this.userSetup.getSavePositionHistory().booleanValue()) {
                    this.storager.clearMobilePositionsByDeviceId(deviceId);
                }
                this.storager.insertMobilePosition(mobilePosition);
            }
            this.responseAck(evt, 200);
            if (this.offLineDetector.isOnline(deviceId)) {
                this.publisher.deviceAlarmEventPublish(deviceAlarm);
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    private void processNotifyCatalogList(RequestEvent evt) {
        try {
            Element deviceListElement;
            FromHeader fromHeader = (FromHeader)evt.getRequest().getHeader("From");
            String deviceId = SipUtils.getUserIdFromFromHeader((FromHeader)fromHeader);
            Element rootElement = this.getRootElement(evt);
            Device device = this.storager.queryVideoDevice(deviceId);
            if (device == null) {
                return;
            }
            if (device != null) {
                rootElement = this.getRootElement(evt, device.getCharset());
            }
            if ((deviceListElement = rootElement.element("DeviceList")) == null) {
                return;
            }
            Iterator deviceListIterator = deviceListElement.elementIterator();
            if (deviceListIterator != null) {
                block20: while (deviceListIterator.hasNext()) {
                    Element itemDevice = (Element)deviceListIterator.next();
                    Element channelDeviceElement = itemDevice.element("DeviceID");
                    if (channelDeviceElement == null) continue;
                    Element eventElement = itemDevice.element("Event");
                    DeviceChannel channel = this.channelContentHander(itemDevice);
                    switch (eventElement.getText().toUpperCase()) {
                        case "ON": {
                            logger.info("\u6536\u5230\u6765\u81ea\u8bbe\u5907\u3010{}\u3011\u7684\u901a\u9053\u3010{}\u3011\u4e0a\u7ebf\u901a\u77e5", (Object)device.getDeviceId(), (Object)channel.getChannelId());
                            this.storager.deviceChannelOnline(deviceId, channel.getChannelId());
                            this.responseAck(evt, 200);
                            continue block20;
                        }
                        case "OFF": {
                            logger.info("\u6536\u5230\u6765\u81ea\u8bbe\u5907\u3010{}\u3011\u7684\u901a\u9053\u3010{}\u3011\u79bb\u7ebf\u901a\u77e5", (Object)device.getDeviceId(), (Object)channel.getChannelId());
                            this.storager.deviceChannelOffline(deviceId, channel.getChannelId());
                            this.responseAck(evt, 200);
                            continue block20;
                        }
                        case "VLOST": {
                            logger.info("\u6536\u5230\u6765\u81ea\u8bbe\u5907\u3010{}\u3011\u7684\u901a\u9053\u3010{}\u3011\u89c6\u9891\u4e22\u5931\u901a\u77e5", (Object)device.getDeviceId(), (Object)channel.getChannelId());
                            this.storager.deviceChannelOffline(deviceId, channel.getChannelId());
                            this.responseAck(evt, 200);
                            continue block20;
                        }
                        case "DEFECT": {
                            this.responseAck(evt, 200);
                            continue block20;
                        }
                        case "ADD": {
                            logger.info("\u6536\u5230\u6765\u81ea\u8bbe\u5907\u3010{}\u3011\u7684\u589e\u52a0\u901a\u9053\u3010{}\u3011\u901a\u77e5", (Object)device.getDeviceId(), (Object)channel.getChannelId());
                            this.storager.updateChannel(deviceId, channel);
                            this.responseAck(evt, 200);
                            continue block20;
                        }
                        case "DEL": {
                            logger.info("\u6536\u5230\u6765\u81ea\u8bbe\u5907\u3010{}\u3011\u7684\u5220\u9664\u901a\u9053\u3010{}\u3011\u901a\u77e5", (Object)device.getDeviceId(), (Object)channel.getChannelId());
                            this.storager.delChannel(deviceId, channel.getChannelId());
                            this.responseAck(evt, 200);
                            continue block20;
                        }
                        case "UPDATE": {
                            logger.info("\u6536\u5230\u6765\u81ea\u8bbe\u5907\u3010{}\u3011\u7684\u66f4\u65b0\u901a\u9053\u3010{}\u3011\u901a\u77e5", (Object)device.getDeviceId(), (Object)channel.getChannelId());
                            this.storager.updateChannel(deviceId, channel);
                            this.responseAck(evt, 200);
                            continue block20;
                        }
                    }
                    this.responseAck(evt, 400, "event not found");
                }
                if (this.offLineDetector.isOnline(deviceId)) {
                    this.publisher.onlineEventPublish(device, "3");
                }
            }
        }
        catch (ParseException | InvalidArgumentException | SipException | DocumentException e) {
            e.printStackTrace();
        }
    }

    public DeviceChannel channelContentHander(Element itemDevice) {
        Element channdelNameElement = itemDevice.element("Name");
        String channelName = channdelNameElement != null ? channdelNameElement.getTextTrim().toString() : "";
        Element statusElement = itemDevice.element("Status");
        String status = statusElement != null ? statusElement.getTextTrim().toString() : "ON";
        DeviceChannel deviceChannel = new DeviceChannel();
        deviceChannel.setName(channelName);
        Element channdelIdElement = itemDevice.element("DeviceID");
        String channelId = channdelIdElement != null ? channdelIdElement.getTextTrim().toString() : "";
        deviceChannel.setChannelId(channelId);
        if (status.equals("ON") || status.equals("On") || status.equals("ONLINE")) {
            deviceChannel.setStatus(1);
        }
        if (status.equals("OFF") || status.equals("Off") || status.equals("OFFLINE")) {
            deviceChannel.setStatus(0);
        }
        deviceChannel.setManufacture(XmlUtil.getText((Element)itemDevice, (String)"Manufacturer"));
        deviceChannel.setModel(XmlUtil.getText((Element)itemDevice, (String)"Model"));
        deviceChannel.setOwner(XmlUtil.getText((Element)itemDevice, (String)"Owner"));
        deviceChannel.setCivilCode(XmlUtil.getText((Element)itemDevice, (String)"CivilCode"));
        deviceChannel.setBlock(XmlUtil.getText((Element)itemDevice, (String)"Block"));
        deviceChannel.setAddress(XmlUtil.getText((Element)itemDevice, (String)"Address"));
        if (XmlUtil.getText((Element)itemDevice, (String)"Parental") == null || XmlUtil.getText((Element)itemDevice, (String)"Parental") == "") {
            deviceChannel.setParental(0);
        } else {
            deviceChannel.setParental(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Parental")));
        }
        deviceChannel.setParentId(XmlUtil.getText((Element)itemDevice, (String)"ParentID"));
        if (XmlUtil.getText((Element)itemDevice, (String)"SafetyWay") == null || XmlUtil.getText((Element)itemDevice, (String)"SafetyWay") == "") {
            deviceChannel.setSafetyWay(0);
        } else {
            deviceChannel.setSafetyWay(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"SafetyWay")));
        }
        if (XmlUtil.getText((Element)itemDevice, (String)"RegisterWay") == null || XmlUtil.getText((Element)itemDevice, (String)"RegisterWay") == "") {
            deviceChannel.setRegisterWay(1);
        } else {
            deviceChannel.setRegisterWay(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"RegisterWay")));
        }
        deviceChannel.setCertNum(XmlUtil.getText((Element)itemDevice, (String)"CertNum"));
        if (XmlUtil.getText((Element)itemDevice, (String)"Certifiable") == null || XmlUtil.getText((Element)itemDevice, (String)"Certifiable") == "") {
            deviceChannel.setCertifiable(0);
        } else {
            deviceChannel.setCertifiable(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Certifiable")));
        }
        if (XmlUtil.getText((Element)itemDevice, (String)"ErrCode") == null || XmlUtil.getText((Element)itemDevice, (String)"ErrCode") == "") {
            deviceChannel.setErrCode(0);
        } else {
            deviceChannel.setErrCode(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"ErrCode")));
        }
        deviceChannel.setEndTime(XmlUtil.getText((Element)itemDevice, (String)"EndTime"));
        deviceChannel.setSecrecy(XmlUtil.getText((Element)itemDevice, (String)"Secrecy"));
        deviceChannel.setIpAddress(XmlUtil.getText((Element)itemDevice, (String)"IPAddress"));
        if (XmlUtil.getText((Element)itemDevice, (String)"Port") == null || XmlUtil.getText((Element)itemDevice, (String)"Port") == "") {
            deviceChannel.setPort(0);
        } else {
            deviceChannel.setPort(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"Port")));
        }
        deviceChannel.setPassword(XmlUtil.getText((Element)itemDevice, (String)"Password"));
        if (NumericUtil.isDouble((String)XmlUtil.getText((Element)itemDevice, (String)"Longitude"))) {
            deviceChannel.setLongitude(Double.parseDouble(XmlUtil.getText((Element)itemDevice, (String)"Longitude")));
        } else {
            deviceChannel.setLongitude(0.0);
        }
        if (NumericUtil.isDouble((String)XmlUtil.getText((Element)itemDevice, (String)"Latitude"))) {
            deviceChannel.setLatitude(Double.parseDouble(XmlUtil.getText((Element)itemDevice, (String)"Latitude")));
        } else {
            deviceChannel.setLatitude(0.0);
        }
        if (XmlUtil.getText((Element)itemDevice, (String)"PTZType") == null || XmlUtil.getText((Element)itemDevice, (String)"PTZType") == "") {
            deviceChannel.setPTZType(0);
        } else {
            deviceChannel.setPTZType(Integer.parseInt(XmlUtil.getText((Element)itemDevice, (String)"PTZType")));
        }
        deviceChannel.setHasAudio(true);
        return deviceChannel;
    }

    public void setCmder(SIPCommander cmder) {
    }

    public void setStorager(IVideoManagerStorager storager) {
        this.storager = storager;
    }

    public void setPublisher(EventPublisher publisher) {
        this.publisher = publisher;
    }

    public void setRedis(RedisUtil redis) {
    }

    public void setDeferredResultHolder(DeferredResultHolder deferredResultHolder) {
    }

    public void setOffLineDetector(DeviceOffLineDetector offLineDetector) {
        this.offLineDetector = offLineDetector;
    }

    public IRedisCatchStorage getRedisCatchStorage() {
        return this.redisCatchStorage;
    }

    public void setRedisCatchStorage(IRedisCatchStorage redisCatchStorage) {
        this.redisCatchStorage = redisCatchStorage;
    }
}

