/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.event.request.impl;

import com.genersoft.iot.vmp.common.StreamInfo;
import com.genersoft.iot.vmp.gb28181.bean.SendRtpItem;
import com.genersoft.iot.vmp.gb28181.transmit.SIPProcessorObserver;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.ISIPRequestProcessor;
import com.genersoft.iot.vmp.gb28181.transmit.event.request.SIPRequestProcessorParent;
import com.genersoft.iot.vmp.media.zlm.ZLMRTPServerFactory;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import java.util.HashMap;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.RequestEvent;
import javax.sip.address.SipURI;
import javax.sip.header.HeaderAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AckRequestProcessor
extends SIPRequestProcessorParent
implements InitializingBean,
ISIPRequestProcessor {
    private Logger logger = LoggerFactory.getLogger(AckRequestProcessor.class);
    private String method = "ACK";
    @Autowired
    private SIPProcessorObserver sipProcessorObserver;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private ZLMRTPServerFactory zlmrtpServerFactory;
    @Autowired
    private IMediaServerService mediaServerService;

    public void afterPropertiesSet() throws Exception {
        this.sipProcessorObserver.addRequestProcessor(this.method, (ISIPRequestProcessor)this);
    }

    public void process(RequestEvent evt) {
        Dialog dialog = evt.getDialog();
        if (dialog == null) {
            return;
        }
        if (dialog.getState() == DialogState.CONFIRMED) {
            String channelId;
            String platformGbId = ((SipURI)((HeaderAddress)evt.getRequest().getHeader("From")).getAddress().getURI()).getUser();
            SendRtpItem sendRtpItem = this.redisCatchStorage.querySendRTPServer(platformGbId, channelId = ((SipURI)((HeaderAddress)evt.getRequest().getHeader("To")).getAddress().getURI()).getUser());
            String is_Udp = sendRtpItem.isTcp() ? "0" : "1";
            String deviceId = sendRtpItem.getDeviceId();
            StreamInfo streamInfo = null;
            if (deviceId == null) {
                streamInfo = new StreamInfo();
                streamInfo.setApp(sendRtpItem.getApp());
                streamInfo.setStreamId(sendRtpItem.getStreamId());
            } else {
                streamInfo = this.redisCatchStorage.queryPlayByDevice(deviceId, channelId);
                sendRtpItem.setStreamId(streamInfo.getStreamId());
                streamInfo.setApp("rtp");
            }
            this.redisCatchStorage.updateSendRTPSever(sendRtpItem);
            this.logger.info(platformGbId);
            this.logger.info(channelId);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("vhost", "__defaultVhost__");
            param.put("app", streamInfo.getApp());
            param.put("stream", streamInfo.getStreamId());
            param.put("ssrc", sendRtpItem.getSsrc());
            param.put("dst_url", sendRtpItem.getIp());
            param.put("dst_port", sendRtpItem.getPort());
            param.put("is_udp", is_Udp);
            boolean rtpPushed = false;
            long startTime = System.currentTimeMillis();
            while (!rtpPushed) {
                try {
                    if (System.currentTimeMillis() - startTime < 30000L) {
                        MediaServerItem mediaInfo = this.mediaServerService.getOne(sendRtpItem.getMediaServerId());
                        if (this.zlmrtpServerFactory.isStreamReady(mediaInfo, streamInfo.getApp(), streamInfo.getStreamId()).booleanValue()) {
                            rtpPushed = true;
                            this.logger.info("\u5df2\u83b7\u53d6\u8bbe\u5907\u63a8\u6d41[{}/{}]\uff0c\u5f00\u59cb\u5411\u4e0a\u7ea7\u63a8\u6d41[{}:{}]", new Object[]{streamInfo.getApp(), streamInfo.getStreamId(), sendRtpItem.getIp(), sendRtpItem.getPort()});
                            this.zlmrtpServerFactory.startSendRtpStream(mediaInfo, param);
                            continue;
                        }
                        this.logger.info("\u7b49\u5f85\u8bbe\u5907\u63a8\u6d41[{}/{}].......", (Object)streamInfo.getApp(), (Object)streamInfo.getStreamId());
                        Thread.sleep(1000L);
                        continue;
                    }
                    rtpPushed = true;
                    this.logger.info("\u8bbe\u5907\u63a8\u6d41[{}/{}]\u8d85\u65f6\uff0c\u7ec8\u6b62\u5411\u4e0a\u7ea7\u63a8\u6d41", (Object)streamInfo.getApp(), (Object)streamInfo.getStreamId());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

