/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.cmd;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import java.text.ParseException;
import java.util.ArrayList;
import javax.sip.InvalidArgumentException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.SubjectHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SIPRequestHeaderProvider {
    @Autowired
    private SipConfig sipConfig;
    @Autowired
    private SipFactory sipFactory;

    public Request createMessageRequest(Device device, String content, String viaTag, String fromTag, String toTag, CallIdHeader callIdHeader) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestURI = this.sipFactory.createAddressFactory().createSipURI(device.getDeviceId(), device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = this.sipFactory.createHeaderFactory().createViaHeader(this.sipConfig.getIp(), this.sipConfig.getPort().intValue(), device.getTransport(), viaTag);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getIp() + ":" + this.sipConfig.getPort());
        Address fromAddress = this.sipFactory.createAddressFactory().createAddress((URI)fromSipURI);
        FromHeader fromHeader = this.sipFactory.createHeaderFactory().createFromHeader(fromAddress, fromTag);
        SipURI toSipURI = this.sipFactory.createAddressFactory().createSipURI(device.getDeviceId(), this.sipConfig.getDomain());
        Address toAddress = this.sipFactory.createAddressFactory().createAddress((URI)toSipURI);
        ToHeader toHeader = this.sipFactory.createHeaderFactory().createToHeader(toAddress, toTag);
        MaxForwardsHeader maxForwards = this.sipFactory.createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = this.sipFactory.createHeaderFactory().createCSeqHeader(1L, "MESSAGE");
        request = this.sipFactory.createMessageFactory().createRequest((URI)requestURI, "MESSAGE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        ContentTypeHeader contentTypeHeader = this.sipFactory.createHeaderFactory().createContentTypeHeader("APPLICATION", "MANSCDP+xml");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }

    public Request createInviteRequest(Device device, String channelId, String content, String viaTag, String fromTag, String toTag, String ssrc, CallIdHeader callIdHeader) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestLine = this.sipFactory.createAddressFactory().createSipURI(channelId, device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = this.sipFactory.createHeaderFactory().createViaHeader(this.sipConfig.getIp(), this.sipConfig.getPort().intValue(), device.getTransport(), viaTag);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getDomain());
        Address fromAddress = this.sipFactory.createAddressFactory().createAddress((URI)fromSipURI);
        FromHeader fromHeader = this.sipFactory.createHeaderFactory().createFromHeader(fromAddress, fromTag);
        SipURI toSipURI = this.sipFactory.createAddressFactory().createSipURI(channelId, this.sipConfig.getDomain());
        Address toAddress = this.sipFactory.createAddressFactory().createAddress((URI)toSipURI);
        ToHeader toHeader = this.sipFactory.createHeaderFactory().createToHeader(toAddress, null);
        MaxForwardsHeader maxForwards = this.sipFactory.createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = this.sipFactory.createHeaderFactory().createCSeqHeader(1L, "INVITE");
        request = this.sipFactory.createMessageFactory().createRequest((URI)requestLine, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        Address concatAddress = this.sipFactory.createAddressFactory().createAddress((URI)this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getIp() + ":" + this.sipConfig.getPort()));
        request.addHeader((Header)this.sipFactory.createHeaderFactory().createContactHeader(concatAddress));
        SubjectHeader subjectHeader = this.sipFactory.createHeaderFactory().createSubjectHeader(String.format("%s:%s,%s:%s", channelId, ssrc, this.sipConfig.getId(), 0));
        request.addHeader((Header)subjectHeader);
        ContentTypeHeader contentTypeHeader = this.sipFactory.createHeaderFactory().createContentTypeHeader("APPLICATION", "SDP");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }

    public Request createPlaybackInviteRequest(Device device, String channelId, String content, String viaTag, String fromTag, String toTag, CallIdHeader callIdHeader, String ssrc) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestLine = this.sipFactory.createAddressFactory().createSipURI(channelId, device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = this.sipFactory.createHeaderFactory().createViaHeader(this.sipConfig.getIp(), this.sipConfig.getPort().intValue(), device.getTransport(), viaTag);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getDomain());
        Address fromAddress = this.sipFactory.createAddressFactory().createAddress((URI)fromSipURI);
        FromHeader fromHeader = this.sipFactory.createHeaderFactory().createFromHeader(fromAddress, fromTag);
        SipURI toSipURI = this.sipFactory.createAddressFactory().createSipURI(channelId, this.sipConfig.getDomain());
        Address toAddress = this.sipFactory.createAddressFactory().createAddress((URI)toSipURI);
        ToHeader toHeader = this.sipFactory.createHeaderFactory().createToHeader(toAddress, null);
        MaxForwardsHeader maxForwards = this.sipFactory.createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = this.sipFactory.createHeaderFactory().createCSeqHeader(1L, "INVITE");
        request = this.sipFactory.createMessageFactory().createRequest((URI)requestLine, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        Address concatAddress = this.sipFactory.createAddressFactory().createAddress((URI)this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getIp() + ":" + this.sipConfig.getPort()));
        request.addHeader((Header)this.sipFactory.createHeaderFactory().createContactHeader(concatAddress));
        SubjectHeader subjectHeader = this.sipFactory.createHeaderFactory().createSubjectHeader(String.format("%s:%s,%s:%s", channelId, ssrc, this.sipConfig.getId(), 0));
        request.addHeader((Header)subjectHeader);
        ContentTypeHeader contentTypeHeader = this.sipFactory.createHeaderFactory().createContentTypeHeader("APPLICATION", "SDP");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }

    public Request createByteRequest(Device device, String channelId, String viaTag, String fromTag, String toTag, String callId) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestLine = this.sipFactory.createAddressFactory().createSipURI(channelId, device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = this.sipFactory.createHeaderFactory().createViaHeader(this.sipConfig.getIp(), this.sipConfig.getPort().intValue(), device.getTransport(), viaTag);
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getDomain());
        Address fromAddress = this.sipFactory.createAddressFactory().createAddress((URI)fromSipURI);
        FromHeader fromHeader = this.sipFactory.createHeaderFactory().createFromHeader(fromAddress, fromTag);
        SipURI toSipURI = this.sipFactory.createAddressFactory().createSipURI(channelId, this.sipConfig.getDomain());
        Address toAddress = this.sipFactory.createAddressFactory().createAddress((URI)toSipURI);
        ToHeader toHeader = this.sipFactory.createHeaderFactory().createToHeader(toAddress, toTag);
        MaxForwardsHeader maxForwards = this.sipFactory.createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = this.sipFactory.createHeaderFactory().createCSeqHeader(1L, "BYE");
        CallIdHeader callIdHeader = this.sipFactory.createHeaderFactory().createCallIdHeader(callId);
        request = this.sipFactory.createMessageFactory().createRequest((URI)requestLine, "BYE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        Address concatAddress = this.sipFactory.createAddressFactory().createAddress((URI)this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getIp() + ":" + this.sipConfig.getPort()));
        return request;
    }

    public Request createSubscribeRequest(Device device, String content, String viaTag, String fromTag, String toTag, Integer expires, String event, CallIdHeader callIdHeader) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestURI = this.sipFactory.createAddressFactory().createSipURI(device.getDeviceId(), device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = this.sipFactory.createHeaderFactory().createViaHeader(this.sipConfig.getIp(), this.sipConfig.getPort().intValue(), device.getTransport(), viaTag);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getIp() + ":" + this.sipConfig.getPort());
        Address fromAddress = this.sipFactory.createAddressFactory().createAddress((URI)fromSipURI);
        FromHeader fromHeader = this.sipFactory.createHeaderFactory().createFromHeader(fromAddress, fromTag);
        SipURI toSipURI = this.sipFactory.createAddressFactory().createSipURI(device.getDeviceId(), this.sipConfig.getDomain());
        Address toAddress = this.sipFactory.createAddressFactory().createAddress((URI)toSipURI);
        ToHeader toHeader = this.sipFactory.createHeaderFactory().createToHeader(toAddress, toTag);
        MaxForwardsHeader maxForwards = this.sipFactory.createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = this.sipFactory.createHeaderFactory().createCSeqHeader(1L, "SUBSCRIBE");
        request = this.sipFactory.createMessageFactory().createRequest((URI)requestURI, "SUBSCRIBE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        Address concatAddress = this.sipFactory.createAddressFactory().createAddress((URI)this.sipFactory.createAddressFactory().createSipURI(this.sipConfig.getId(), this.sipConfig.getIp() + ":" + this.sipConfig.getPort()));
        request.addHeader((Header)this.sipFactory.createHeaderFactory().createContactHeader(concatAddress));
        ExpiresHeader expireHeader = this.sipFactory.createHeaderFactory().createExpiresHeader(expires.intValue());
        request.addHeader((Header)expireHeader);
        EventHeader eventHeader = this.sipFactory.createHeaderFactory().createEventHeader(event);
        request.addHeader((Header)eventHeader);
        ContentTypeHeader contentTypeHeader = this.sipFactory.createHeaderFactory().createContentTypeHeader("APPLICATION", "MANSCDP+xml");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }
}

