/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.transmit.cmd;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import gov.nist.javax.sip.message.MessageFactoryImpl;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.UUID;
import javax.sip.InvalidArgumentException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.UserAgentHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Request;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

@Component
public class SIPRequestHeaderPlarformProvider {
    @Autowired
    private SipConfig sipConfig;
    @Autowired
    private SipFactory sipFactory;

    public Request createKeetpaliveMessageRequest(ParentPlatform parentPlatform, String content, String viaTag, String fromTag, String toTag, CallIdHeader callIdHeader) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestURI = this.sipFactory.createAddressFactory().createSipURI(parentPlatform.getServerGBId(), parentPlatform.getServerIP() + ":" + parentPlatform.getServerPort());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = this.sipFactory.createHeaderFactory().createViaHeader(this.sipConfig.getIp(), this.sipConfig.getPort().intValue(), parentPlatform.getTransport(), viaTag);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = this.sipFactory.createAddressFactory().createSipURI(parentPlatform.getDeviceGBId(), this.sipConfig.getIp() + ":" + this.sipConfig.getPort());
        Address fromAddress = this.sipFactory.createAddressFactory().createAddress((URI)fromSipURI);
        FromHeader fromHeader = this.sipFactory.createHeaderFactory().createFromHeader(fromAddress, fromTag);
        SipURI toSipURI = this.sipFactory.createAddressFactory().createSipURI(parentPlatform.getServerGBId(), parentPlatform.getServerIP() + ":" + parentPlatform.getServerPort());
        Address toAddress = this.sipFactory.createAddressFactory().createAddress((URI)toSipURI);
        ToHeader toHeader = this.sipFactory.createHeaderFactory().createToHeader(toAddress, toTag);
        MaxForwardsHeader maxForwards = this.sipFactory.createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = this.sipFactory.createHeaderFactory().createCSeqHeader(1L, "MESSAGE");
        request = this.sipFactory.createMessageFactory().createRequest((URI)requestURI, "MESSAGE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        ArrayList<String> agentParam = new ArrayList<String>();
        agentParam.add("wvp-pro");
        UserAgentHeader userAgentHeader = this.sipFactory.createHeaderFactory().createUserAgentHeader(agentParam);
        request.addHeader((Header)userAgentHeader);
        ContentTypeHeader contentTypeHeader = this.sipFactory.createHeaderFactory().createContentTypeHeader("Application", "MANSCDP+xml");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }

    public Request createRegisterRequest(@NotNull ParentPlatform platform, long CSeq, String fromTag, String viaTag, CallIdHeader callIdHeader) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        String sipAddress = this.sipConfig.getIp() + ":" + this.sipConfig.getPort();
        SipURI requestLine = this.sipFactory.createAddressFactory().createSipURI(platform.getServerGBId(), platform.getServerIP() + ":" + platform.getServerPort());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = this.sipFactory.createHeaderFactory().createViaHeader(platform.getServerIP(), platform.getServerPort(), platform.getTransport(), viaTag);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = this.sipFactory.createAddressFactory().createSipURI(platform.getDeviceGBId(), sipAddress);
        Address fromAddress = this.sipFactory.createAddressFactory().createAddress((URI)fromSipURI);
        FromHeader fromHeader = this.sipFactory.createHeaderFactory().createFromHeader(fromAddress, fromTag);
        SipURI toSipURI = this.sipFactory.createAddressFactory().createSipURI(platform.getDeviceGBId(), sipAddress);
        Address toAddress = this.sipFactory.createAddressFactory().createAddress((URI)toSipURI);
        ToHeader toHeader = this.sipFactory.createHeaderFactory().createToHeader(toAddress, null);
        MaxForwardsHeader maxForwards = this.sipFactory.createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = this.sipFactory.createHeaderFactory().createCSeqHeader(CSeq, "REGISTER");
        request = this.sipFactory.createMessageFactory().createRequest((URI)requestLine, "REGISTER", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        Address concatAddress = this.sipFactory.createAddressFactory().createAddress((URI)this.sipFactory.createAddressFactory().createSipURI(platform.getDeviceGBId(), sipAddress));
        request.addHeader((Header)this.sipFactory.createHeaderFactory().createContactHeader(concatAddress));
        ExpiresHeader expires = this.sipFactory.createHeaderFactory().createExpiresHeader(Integer.parseInt(platform.getExpires()));
        request.addHeader((Header)expires);
        ArrayList<String> agentParam = new ArrayList<String>();
        agentParam.add("wvp-pro");
        UserAgentHeader userAgentHeader = this.sipFactory.createHeaderFactory().createUserAgentHeader(agentParam);
        request.addHeader((Header)userAgentHeader);
        return request;
    }

    public Request createRegisterRequest(@NotNull ParentPlatform parentPlatform, String fromTag, String viaTag, String callId, WWWAuthenticateHeader www, CallIdHeader callIdHeader) throws ParseException, PeerUnavailableException, InvalidArgumentException {
        Request registerRequest = this.createRegisterRequest(parentPlatform, 2L, fromTag, viaTag, callIdHeader);
        String realm = www.getRealm();
        String nonce = www.getNonce();
        String scheme = www.getScheme();
        String qop = www.getQop();
        callIdHeader.setCallId(callId);
        SipURI requestURI = this.sipFactory.createAddressFactory().createSipURI(parentPlatform.getServerGBId(), parentPlatform.getServerIP() + ":" + parentPlatform.getServerPort());
        String cNonce = null;
        String nc = "00000001";
        if (qop != null) {
            if ("auth".equals(qop)) {
                cNonce = UUID.randomUUID().toString();
            } else if ("auth-int".equals(qop)) {
                // empty if block
            }
        }
        String HA1 = DigestUtils.md5DigestAsHex((byte[])(parentPlatform.getDeviceGBId() + ":" + realm + ":" + parentPlatform.getPassword()).getBytes());
        String HA2 = DigestUtils.md5DigestAsHex((byte[])("REGISTER:" + requestURI.toString()).getBytes());
        StringBuffer reStr = new StringBuffer(200);
        reStr.append(HA1);
        reStr.append(":");
        reStr.append(nonce);
        reStr.append(":");
        if (qop != null) {
            reStr.append(nc);
            reStr.append(":");
            reStr.append(cNonce);
            reStr.append(":");
            reStr.append(qop);
            reStr.append(":");
        }
        reStr.append(HA2);
        String RESPONSE = DigestUtils.md5DigestAsHex((byte[])reStr.toString().getBytes());
        AuthorizationHeader authorizationHeader = this.sipFactory.createHeaderFactory().createAuthorizationHeader(scheme);
        authorizationHeader.setUsername(parentPlatform.getDeviceGBId());
        authorizationHeader.setRealm(realm);
        authorizationHeader.setNonce(nonce);
        authorizationHeader.setURI((URI)requestURI);
        authorizationHeader.setResponse(RESPONSE);
        authorizationHeader.setAlgorithm("MD5");
        if (qop != null) {
            authorizationHeader.setQop(qop);
            authorizationHeader.setCNonce(cNonce);
            authorizationHeader.setNonceCount(1);
        }
        registerRequest.addHeader((Header)authorizationHeader);
        return registerRequest;
    }

    public Request createMessageRequest(ParentPlatform parentPlatform, String content, String fromTag, CallIdHeader callIdHeader) throws PeerUnavailableException, ParseException, InvalidArgumentException {
        Request request = null;
        SipURI requestURI = this.sipFactory.createAddressFactory().createSipURI(parentPlatform.getServerGBId(), parentPlatform.getServerIP() + ":" + parentPlatform.getServerPort());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = this.sipFactory.createHeaderFactory().createViaHeader(parentPlatform.getDeviceIp(), Integer.parseInt(parentPlatform.getDevicePort()), parentPlatform.getTransport(), null);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = this.sipFactory.createAddressFactory().createSipURI(parentPlatform.getDeviceGBId(), parentPlatform.getDeviceIp() + ":" + parentPlatform.getDevicePort());
        Address fromAddress = this.sipFactory.createAddressFactory().createAddress((URI)fromSipURI);
        FromHeader fromHeader = this.sipFactory.createHeaderFactory().createFromHeader(fromAddress, fromTag);
        SipURI toSipURI = this.sipFactory.createAddressFactory().createSipURI(parentPlatform.getServerGBId(), parentPlatform.getServerGBDomain());
        Address toAddress = this.sipFactory.createAddressFactory().createAddress((URI)toSipURI);
        ToHeader toHeader = this.sipFactory.createHeaderFactory().createToHeader(toAddress, null);
        MaxForwardsHeader maxForwards = this.sipFactory.createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = this.sipFactory.createHeaderFactory().createCSeqHeader(1L, "MESSAGE");
        MessageFactoryImpl messageFactory = (MessageFactoryImpl)this.sipFactory.createMessageFactory();
        messageFactory.setDefaultContentEncodingCharset("gb2312");
        request = messageFactory.createRequest((URI)requestURI, "MESSAGE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        ArrayList<String> agentParam = new ArrayList<String>();
        agentParam.add("wvp-pro");
        UserAgentHeader userAgentHeader = this.sipFactory.createHeaderFactory().createUserAgentHeader(agentParam);
        request.addHeader((Header)userAgentHeader);
        ContentTypeHeader contentTypeHeader = this.sipFactory.createHeaderFactory().createContentTypeHeader("APPLICATION", "MANSCDP+xml");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }
}

