/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.event.online;

import com.genersoft.iot.vmp.conf.SipConfig;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.event.online.OnlineEvent;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.genersoft.iot.vmp.utils.redis.RedisUtil;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class OnlineEventListener
implements ApplicationListener<OnlineEvent> {
    private static final Logger logger = LoggerFactory.getLogger(OnlineEventListener.class);
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private RedisUtil redis;
    @Autowired
    private SipConfig sipConfig;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void onApplicationEvent(OnlineEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u4e0a\u7ebf\u4e8b\u4ef6\u89e6\u53d1\uff0cdeviceId\uff1a" + event.getDevice().getDeviceId() + ",from:" + event.getFrom());
        }
        Device device = event.getDevice();
        String key = "VMP_keeplive_" + event.getDevice().getDeviceId();
        switch (event.getFrom()) {
            case "1": {
                this.redis.set(key, (Object)event.getDevice().getDeviceId(), (long)this.sipConfig.getKeepaliveTimeOut().intValue());
                device.setRegisterTime(this.format.format(System.currentTimeMillis()));
                break;
            }
            case "2": {
                boolean exist = this.redis.hasKey(key);
                if (!exist) {
                    this.redis.set(key, (Object)event.getDevice().getDeviceId(), (long)this.sipConfig.getKeepaliveTimeOut().intValue());
                } else {
                    this.redis.expire(key, (long)this.sipConfig.getKeepaliveTimeOut().intValue());
                }
                device.setKeepaliveTime(this.format.format(System.currentTimeMillis()));
                break;
            }
        }
        device.setOnline(1);
        this.storager.updateDevice(device);
    }
}

