/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.gb28181.event.alarm;

import com.genersoft.iot.vmp.gb28181.event.alarm.AlarmEvent;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class AlarmEventListener
implements ApplicationListener<AlarmEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AlarmEventListener.class);
    private static Map<String, SseEmitter> sseEmitters = new Hashtable();

    public void addSseEmitters(String browserId, SseEmitter sseEmitter) {
        sseEmitters.put(browserId, sseEmitter);
    }

    public void onApplicationEvent(AlarmEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\u62a5\u8b66\u4e8b\u4ef6\u89e6\u53d1\uff0cdeviceId\uff1a" + event.getAlarmInfo().getDeviceId() + ", " + event.getAlarmInfo().getAlarmDescription());
        }
        String msg = "<strong>\u8bbe\u5907\u7f16\u7801\uff1a</strong> <i>" + event.getAlarmInfo().getDeviceId() + "</i><br><strong>\u62a5\u8b66\u63cf\u8ff0\uff1a</strong> <i>" + event.getAlarmInfo().getAlarmDescription() + "</i><br><strong>\u62a5\u8b66\u65f6\u95f4\uff1a</strong> <i>" + event.getAlarmInfo().getAlarmTime() + "</i><br><strong>\u62a5\u8b66\u4f4d\u7f6e\uff1a</strong> <i>" + event.getAlarmInfo().getLongitude() + "</i>, <i>" + event.getAlarmInfo().getLatitude() + "</i>";
        Iterator it = sseEmitters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry emitter = it.next();
            logger.info("\u63a8\u9001\u5230SSE\u8fde\u63a5\uff0c\u6d4f\u89c8\u5668ID: " + (String)emitter.getKey());
            try {
                ((SseEmitter)emitter.getValue()).send((Object)msg);
            }
            catch (IOException | IllegalStateException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SSE\u8fde\u63a5\u5df2\u5173\u95ed");
                }
                it.remove();
            }
        }
    }
}

