/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf.security;

import com.genersoft.iot.vmp.conf.UserSetup;
import com.genersoft.iot.vmp.conf.security.AnonymousAuthenticationEntryPoint;
import com.genersoft.iot.vmp.conf.security.DefaultUserDetailsServiceImpl;
import com.genersoft.iot.vmp.conf.security.LoginFailureHandler;
import com.genersoft.iot.vmp.conf.security.LoginSuccessHandler;
import com.genersoft.iot.vmp.conf.security.LogoutHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Autowired
    private UserSetup userSetup;
    @Autowired
    private DefaultUserDetailsServiceImpl userDetailsService;
    @Autowired
    private LoginFailureHandler loginFailureHandler;
    @Autowired
    private LoginSuccessHandler loginSuccessHandler;
    @Autowired
    private LogoutHandler logoutHandler;
    @Autowired
    private AnonymousAuthenticationEntryPoint anonymousAuthenticationEntryPoint;

    public void configure(WebSecurity web) {
        if (!this.userSetup.isInterfaceAuthentication().booleanValue()) {
            web.ignoring().antMatchers(new String[]{"**"});
        } else {
            ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/"})).antMatchers(new String[]{"/#/**"})).antMatchers(new String[]{"/static/**"})).antMatchers(new String[]{"/index.html"})).antMatchers(new String[]{"/doc.html"})).antMatchers(new String[]{"/webjars/**"})).antMatchers(new String[]{"/swagger-resources/**"})).antMatchers(new String[]{"/v3/api-docs/**"})).antMatchers(new String[]{"/js/**"});
            List interfaceAuthenticationExcludes = this.userSetup.getInterfaceAuthenticationExcludes();
            for (String interfaceAuthenticationExclude : interfaceAuthenticationExcludes) {
                if (interfaceAuthenticationExclude.split("/").length < 4) {
                    logger.warn("{}\u4e0d\u6ee1\u8db3\u4e24\u7ea7\u76ee\u5f55\uff0c\u5df2\u5ffd\u7565", (Object)interfaceAuthenticationExclude);
                    continue;
                }
                web.ignoring().antMatchers(new String[]{interfaceAuthenticationExclude});
            }
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setHideUserNotFoundExceptions(true);
        provider.setUserDetailsService((UserDetailsService)this.userDetailsService);
        provider.setPasswordEncoder((PasswordEncoder)this.passwordEncoder());
        auth.authenticationProvider((AuthenticationProvider)provider);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)http.cors().and()).csrf().disable();
        http.headers().contentTypeOptions().disable();
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/api/user/login", "/index/hook/**"})).permitAll().anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.anonymousAuthenticationEntryPoint).and()).formLogin().permitAll()).successHandler((AuthenticationSuccessHandler)this.loginSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.loginFailureHandler)).and()).logout().logoutUrl("/api/user/logout").permitAll().logoutSuccessHandler((LogoutSuccessHandler)this.logoutHandler).deleteCookies(new String[]{"JSESSIONID"});
    }

    @Bean
    public BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationManager authenticationManager() throws Exception {
        return super.authenticationManager();
    }
}

