/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync(proxyTargetClass=true)
public class ThreadPoolTaskConfig {
    private static final int corePoolSize = 5;
    private static final int maxPoolSize = 30;
    private static final int keepAliveTime = 30;
    private static final int queueCapacity = 10000;
    private static final String threadNamePrefix = "wvp-sip-handle-";

    @Bean(value={"taskExecutor"})
    public ThreadPoolTaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(5);
        executor.setMaxPoolSize(30);
        executor.setQueueCapacity(10000);
        executor.setKeepAliveSeconds(30);
        executor.setThreadNamePrefix(threadNamePrefix);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

