/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.conf;

import com.genersoft.iot.vmp.gb28181.bean.ParentPlatform;
import com.genersoft.iot.vmp.gb28181.bean.ParentPlatformCatch;
import com.genersoft.iot.vmp.gb28181.event.EventPublisher;
import com.genersoft.iot.vmp.media.zlm.ZLMRTPServerFactory;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=3)
public class SipPlatformRunner
implements CommandLineRunner {
    @Autowired
    private IVideoManagerStorager storager;
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private EventPublisher publisher;
    @Autowired
    private ZLMRTPServerFactory zlmrtpServerFactory;

    public void run(String ... args) throws Exception {
        this.storager.outlineForAllParentPlatform();
        this.redisCatchStorage.cleanPlatformRegisterInfos();
        List parentPlatforms = this.storager.queryEnableParentPlatformList(true);
        for (ParentPlatform parentPlatform : parentPlatforms) {
            this.redisCatchStorage.updatePlatformRegister(parentPlatform);
            this.redisCatchStorage.updatePlatformKeepalive(parentPlatform);
            ParentPlatformCatch parentPlatformCatch = new ParentPlatformCatch();
            parentPlatformCatch.setParentPlatform(parentPlatform);
            parentPlatformCatch.setId(parentPlatform.getServerGBId());
            this.redisCatchStorage.updatePlatformCatchInfo(parentPlatformCatch);
            this.publisher.platformNotRegisterEventPublish(parentPlatform.getServerGBId());
        }
    }
}

