/*
 * Decompiled with CFR 0.152.
 */
package top.panll.assist.service;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.bramp.ffmpeg.FFprobe;
import net.bramp.ffmpeg.probe.FFmpegProbeResult;
import net.bramp.ffmpeg.progress.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import top.panll.assist.dto.MergeOrCutTaskInfo;
import top.panll.assist.dto.SpaceInfo;
import top.panll.assist.dto.UserSettings;
import top.panll.assist.service.FFmpegExecUtils;
import top.panll.assist.utils.DateUtils;
import top.panll.assist.utils.RedisUtil;

@Service
public class VideoFileService {
    private static final Logger logger = LoggerFactory.getLogger(VideoFileService.class);
    @Autowired
    private UserSettings userSettings;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private ThreadPoolExecutor processThreadPool;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat simpleDateFormatForTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String keyStr = "MERGEORCUT";

    @Bean(value={"threadPoolExecutor"})
    private ThreadPoolExecutor iniThreadPool() {
        int processThreadNum = Runtime.getRuntime().availableProcessors() * 10;
        LinkedBlockingQueue<Runnable> processQueue = new LinkedBlockingQueue<Runnable>(10000);
        this.processThreadPool = new ThreadPoolExecutor(processThreadNum, processThreadNum, 0L, TimeUnit.MILLISECONDS, processQueue, new ThreadPoolExecutor.CallerRunsPolicy());
        return this.processThreadPool;
    }

    public List<File> getAppList() {
        File recordFile = new File(this.userSettings.getRecord());
        if (recordFile != null) {
            File[] files = recordFile.listFiles();
            List<File> result = Arrays.asList(files);
            Collections.sort(result);
            return result;
        }
        return null;
    }

    public SpaceInfo getSpaceInfo() {
        File recordFile = new File(this.userSettings.getRecord());
        SpaceInfo spaceInfo = new SpaceInfo();
        spaceInfo.setFree(recordFile.getFreeSpace());
        spaceInfo.setTotal(recordFile.getTotalSpace());
        return spaceInfo;
    }

    public List<File> getStreamList(String app) {
        File appFile = new File(this.userSettings.getRecord() + File.separator + app);
        if (appFile != null) {
            File[] files = appFile.listFiles();
            List<File> result = Arrays.asList(files);
            Collections.sort(result);
            return result;
        }
        return null;
    }

    public void handFile(File file) {
        FFprobe ffprobe = FFmpegExecUtils.getInstance().ffprobe;
        if (file.exists() && file.isFile() && !file.getName().startsWith(".") && file.getName().endsWith(".mp4") && file.getName().indexOf(":") < 0) {
            try {
                FFmpegProbeResult in = null;
                in = ffprobe.probe(file.getAbsolutePath());
                double duration = in.getFormat().duration * 1000.0;
                String endTimeStr = file.getName().replace(".mp4", "");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                File dateFile = new File(file.getParent());
                long startTime = formatter.parse(dateFile.getName() + " " + endTimeStr).getTime();
                long durationLong = new Double(duration).longValue();
                long endTime = startTime + durationLong;
                endTime -= endTime % 1000L;
                String newName = file.getAbsolutePath().replace(file.getName(), simpleDateFormat.format(startTime) + "-" + simpleDateFormat.format(endTime) + "-" + durationLong + ".mp4");
                file.renameTo(new File(newName));
                System.out.println(newName);
            }
            catch (IOException e) {
                logger.warn("\u6587\u4ef6\u53ef\u80fd\u4ee5\u635f\u574f[{}]", (Object)file.getAbsolutePath());
            }
            catch (ParseException e) {
                logger.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25", (Object)e.getMessage());
            }
        }
    }

    public List<Map<String, String>> getList() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List appList = this.getAppList();
        if (appList != null && appList.size() > 0) {
            for (File appFile : appList) {
                List streamList = this.getStreamList(appFile.getName());
                if (streamList == null || streamList.size() <= 0) continue;
                for (File streamFile : streamList) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("app", appFile.getName());
                    data.put("stream", streamFile.getName());
                    BasicFileAttributes bAttributes = null;
                    try {
                        bAttributes = Files.readAttributes(streamFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    data.put("time", this.simpleDateFormatForTime.format(new Date(bAttributes.lastModifiedTime().toMillis())));
                    result.add(data);
                }
            }
        }
        result.sort((f1, f2) -> {
            Date time1 = null;
            Date time2 = null;
            try {
                time1 = this.simpleDateFormatForTime.parse(f1.get("time").toString());
                time2 = this.simpleDateFormatForTime.parse(f2.get("time").toString());
            }
            catch (ParseException e) {
                logger.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25", (Object)e.getMessage());
            }
            return time1.compareTo(time2) * -1;
        });
        return result;
    }

    public List<File> getFilesInTime(String app, String stream, Date startTime, Date endTime) {
        ArrayList<File> result = new ArrayList<File>();
        if (app == null || stream == null) {
            return result;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat formatterForDate = new SimpleDateFormat("yyyy-MM-dd");
        String startTimeStr = formatter.format(startTime);
        String endTimeStr = formatter.format(endTime);
        logger.debug("\u83b7\u53d6[app: {}, stream: {}, statime: {}, endTime: {}]\u7684\u89c6\u9891", new Object[]{app, stream, startTimeStr, endTimeStr});
        File recordFile = new File(this.userSettings.getRecord());
        File streamFile = new File(recordFile.getAbsolutePath() + File.separator + app + File.separator + stream + File.separator);
        if (!streamFile.exists()) {
            logger.warn("\u83b7\u53d6[app: {}, stream: {}, statime: {}, endTime: {}]\u7684\u89c6\u9891\u65f6\u672a\u627e\u5230\u76ee\u5f55\uff1a {}", new Object[]{app, stream, startTimeStr, endTimeStr, stream});
            return result;
        }
        File[] dateFiles = streamFile.listFiles((dir, name) -> {
            Date fileDate = null;
            Date startDate = new Date(startTime.getTime() - (startTime.getTime() + 28800000L) % 86400000L);
            Date endDate = new Date(endTime.getTime() - (endTime.getTime() + 28800000L) % 86400000L);
            try {
                fileDate = formatterForDate.parse(name);
            }
            catch (ParseException e) {
                logger.error("\u8fc7\u6ee4\u65e5\u671f\u6587\u4ef6\u65f6\u5f02\u5e38\uff1a {}-{}", (Object)name, (Object)e.getMessage());
                return false;
            }
            return DateUtils.getStartOfDay((Date)startDate).compareTo(fileDate) <= 0 || DateUtils.getEndOfDay((Date)endDate).compareTo(fileDate) >= 0;
        });
        if (dateFiles != null && dateFiles.length > 0) {
            for (File dateFile : dateFiles) {
                File[] files = dateFile.listFiles((dir, name) -> {
                    String[] timeArray;
                    boolean filterResult = false;
                    if (name.contains(":") && name.endsWith(".mp4") && !name.startsWith(".") && (timeArray = name.split("-")).length == 3) {
                        String fileStartTimeStr = dateFile.getName() + " " + timeArray[0];
                        String fileEndTimeStr = dateFile.getName() + " " + timeArray[1];
                        try {
                            filterResult = formatter.parse(fileStartTimeStr).after(startTime) && formatter.parse(fileEndTimeStr).before(endTime);
                        }
                        catch (ParseException e) {
                            logger.error("\u8fc7\u6ee4\u89c6\u9891\u6587\u4ef6\u65f6\u5f02\u5e38\uff1a {}-{}", (Object)name, (Object)e.getMessage());
                            return false;
                        }
                    }
                    return filterResult;
                });
                List<File> fileList = Arrays.asList(files);
                result.addAll(fileList);
            }
        }
        if (result.size() > 0) {
            result.sort((f1, f2) -> {
                int sortResult = 0;
                String[] timeArray1 = f1.getName().split("-");
                String[] timeArray2 = f2.getName().split("-");
                if (timeArray1.length == 3 && timeArray2.length == 3) {
                    File dateFile1 = f1.getParentFile();
                    File dateFile2 = f2.getParentFile();
                    String fileStartTimeStr1 = dateFile1.getName() + " " + timeArray1[0];
                    String fileStartTimeStr2 = dateFile2.getName() + " " + timeArray2[0];
                    try {
                        sortResult = formatter.parse(fileStartTimeStr1).compareTo(formatter.parse(fileStartTimeStr2));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                return sortResult;
            });
        }
        return result;
    }

    public String mergeOrCut(String app, String stream, Date startTime, Date endTime) {
        List filesInTime = this.getFilesInTime(app, stream, startTime, endTime);
        if (filesInTime == null || filesInTime.size() == 0) {
            logger.info("\u6b64\u65f6\u95f4\u6bb5\u672a\u672a\u627e\u5230\u89c6\u9891\u6587\u4ef6");
            return null;
        }
        File recordFile = new File(new File(this.userSettings.getRecord()).getParentFile().getAbsolutePath() + File.separator + "recordTemp");
        if (!recordFile.exists()) {
            recordFile.mkdirs();
        }
        String taskId = DigestUtils.md5DigestAsHex((byte[])String.valueOf(System.currentTimeMillis()).getBytes());
        MergeOrCutTaskInfo mergeOrCutTaskInfo = new MergeOrCutTaskInfo();
        mergeOrCutTaskInfo.setId(taskId);
        mergeOrCutTaskInfo.setApp(app);
        mergeOrCutTaskInfo.setStream(stream);
        mergeOrCutTaskInfo.setStartTime(this.simpleDateFormatForTime.format(startTime));
        mergeOrCutTaskInfo.setEndTime(this.simpleDateFormatForTime.format(endTime));
        Runnable task = () -> FFmpegExecUtils.getInstance().mergeOrCutFile(filesInTime, recordFile, taskId, (status, percentage, result) -> {
            if (status.equals(Progress.Status.END.name())) {
                mergeOrCutTaskInfo.setPercentage("1");
                mergeOrCutTaskInfo.setRecordFile(result);
                this.stringRedisTemplate.convertAndSend("topic_mergeorcut_end", (Object)JSONObject.toJSONString((Object)mergeOrCutTaskInfo));
            } else {
                mergeOrCutTaskInfo.setPercentage(percentage + "");
                this.stringRedisTemplate.convertAndSend("topic_mergeorcut_continue", (Object)JSONObject.toJSONString((Object)mergeOrCutTaskInfo));
            }
            String key = String.format("%S_%S_%S_%S", this.keyStr, app, stream, taskId);
            this.redisUtil.set(key, (Object)mergeOrCutTaskInfo);
        });
        this.processThreadPool.execute(task);
        return taskId;
    }

    public List<File> getDateList(String app, String stream, Integer year, Integer month) {
        File recordFile = new File(this.userSettings.getRecord());
        File streamFile = new File(recordFile.getAbsolutePath() + File.separator + app + File.separator + stream);
        if (!streamFile.exists()) {
            logger.warn("\u83b7\u53d6[app: {}, stream: {}]\u7684\u89c6\u9891\u65f6\u672a\u627e\u5230\u76ee\u5f55\uff1a {}", new Object[]{app, stream, stream});
            return null;
        }
        File[] dateFiles = streamFile.listFiles((dir, name) -> {
            Date date = null;
            try {
                date = this.simpleDateFormat.parse(name);
            }
            catch (ParseException e) {
                logger.error("\u683c\u5f0f\u5316\u65f6\u95f4{}\u9519\u8bef", (Object)name);
            }
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            int y = c.get(1);
            int m = c.get(2);
            if (year != null) {
                if (month != null) {
                    return y == year && m == month;
                }
                return y == year;
            }
            return true;
        });
        List<File> dateFileList = Arrays.asList(dateFiles);
        dateFileList.sort((f1, f2) -> {
            int sortResult = 0;
            try {
                sortResult = this.simpleDateFormat.parse(f1.getName()).compareTo(this.simpleDateFormat.parse(f2.getName()));
            }
            catch (ParseException e) {
                logger.error("\u683c\u5f0f\u5316\u65f6\u95f4{}/{}\u9519\u8bef", (Object)f1.getName(), (Object)f2.getName());
            }
            return sortResult;
        });
        return dateFileList;
    }

    public List<MergeOrCutTaskInfo> getTaskListForDownload(boolean idEnd) {
        ArrayList<MergeOrCutTaskInfo> result = new ArrayList<MergeOrCutTaskInfo>();
        List taskCatch = this.redisUtil.scan(String.format("%S_*_*_*", this.keyStr));
        for (int i = 0; i < taskCatch.size(); ++i) {
            String keyItem = taskCatch.get(i).toString();
            MergeOrCutTaskInfo mergeOrCutTaskInfo = (MergeOrCutTaskInfo)this.redisUtil.get(keyItem);
            if (mergeOrCutTaskInfo == null) continue;
            if (idEnd) {
                if (Double.parseDouble(mergeOrCutTaskInfo.getPercentage()) != 1.0) continue;
                result.add(mergeOrCutTaskInfo);
                continue;
            }
            if (!(Double.parseDouble(mergeOrCutTaskInfo.getPercentage()) < 1.0)) continue;
            result.add((MergeOrCutTaskInfo)this.redisUtil.get(keyItem));
        }
        result.sort((m1, m2) -> {
            int sortResult = 0;
            try {
                sortResult = this.simpleDateFormatForTime.parse(m1.getStartTime()).compareTo(this.simpleDateFormatForTime.parse(m2.getStartTime()));
                if (sortResult == 0) {
                    sortResult = this.simpleDateFormatForTime.parse(m1.getEndTime()).compareTo(this.simpleDateFormatForTime.parse(m2.getEndTime()));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return sortResult * -1;
        });
        return result;
    }

    public boolean stopTask(String taskId) {
        return false;
    }
}

