/*
 * Decompiled with CFR 0.152.
 */
package top.panll.assist.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.bramp.ffmpeg.FFmpeg;
import net.bramp.ffmpeg.FFmpegExecutor;
import net.bramp.ffmpeg.FFprobe;
import net.bramp.ffmpeg.builder.FFmpegBuilder;
import net.bramp.ffmpeg.builder.FFmpegOutputBuilder;
import net.bramp.ffmpeg.job.FFmpegJob;
import net.bramp.ffmpeg.progress.Progress;
import top.panll.assist.service.FFmpegExecUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FFmpegExecUtils {
    private static FFmpegExecUtils instance;
    public FFprobe ffprobe;
    public FFmpeg ffmpeg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FFmpegExecUtils getInstance() {
        if (instance != null) return instance;
        Class<FFmpegExecUtils> clazz = FFmpegExecUtils.class;
        synchronized (FFmpegExecUtils.class) {
            if (instance != null) return instance;
            instance = new FFmpegExecUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String mergeOrCutFile(List<File> fils, File dest, String temp, VideoHandEndCallBack callBack) {
        FFmpeg ffmpeg = FFmpegExecUtils.getInstance().ffmpeg;
        FFprobe ffprobe = FFmpegExecUtils.getInstance().ffprobe;
        if (fils == null || fils.size() == 0 || ffmpeg == null || ffprobe == null || dest == null || !dest.exists()) {
            callBack.run("error", 0.0, null);
            return null;
        }
        File tempFile = new File(dest.getAbsolutePath() + File.separator + temp);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        FFmpegExecutor executor = new FFmpegExecutor(ffmpeg, ffprobe);
        String fileListName = tempFile.getAbsolutePath() + File.separator + "fileList";
        double durationAll = 0.0;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileListName));
            for (File file : fils) {
                String[] split = file.getName().split("-");
                if (split.length != 3) continue;
                String durationStr = split[2].replace(".mp4", "");
                Double duration = Double.parseDouble(durationStr) / 1000.0;
                bw.write("file " + file.getAbsolutePath());
                bw.newLine();
                durationAll += duration.doubleValue();
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            callBack.run("error", 0.0, null);
        }
        String recordFileResultPath = dest.getAbsolutePath() + File.separator + temp + File.separator + "record.mp4";
        long startTime = System.currentTimeMillis();
        FFmpegBuilder builder = ((FFmpegOutputBuilder)((FFmpegOutputBuilder)new FFmpegBuilder().setFormat("concat").overrideOutputFiles(true).setInput(fileListName).addExtraArgs(new String[]{"-safe", "0"}).addOutput(recordFileResultPath).setVideoCodec("copy")).setFormat("mp4")).done();
        double finalDurationAll = durationAll;
        FFmpegJob job = executor.createJob(builder, progress -> {
            double duration_ns = finalDurationAll * (double)TimeUnit.SECONDS.toNanos(1L);
            double percentage = (double)progress.out_time_ns / duration_ns;
            if (progress.status.equals((Object)Progress.Status.END)) {
                callBack.run(progress.status.name(), percentage, dest.getName() + File.separator + temp + File.separator + "record.mp4");
                System.out.println(System.currentTimeMillis() - startTime);
            } else {
                callBack.run(progress.status.name(), percentage, null);
            }
        });
        job.run();
        return temp;
    }
}

