/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.google.gson.Gson;
import com.meituan.android.walle.ChannelWriter;
import com.meituan.android.walle.SignatureNotFoundException;
import com.meituan.android.walle.WalleConfig;
import com.meituan.android.walle.commands.IWalleCommand;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

@Parameters(commandDescription="channel apk batch production")
public class Batch2Command
implements IWalleCommand {
    @Parameter(required=true, description="inputFile [outputDirectory]", arity=2, converter=FileConverter.class)
    private List<File> files;
    @Parameter(names={"-f", "--configFile"}, description="config file (json)")
    private File configFile;

    @Override
    public void parse() {
        File inputFile = this.files.get(0);
        File outputDir = null;
        if (this.files.size() == 2) {
            outputDir = this.files.get(1);
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
        } else {
            outputDir = inputFile.getParentFile();
        }
        if (this.configFile != null) {
            try {
                WalleConfig config = new Gson().fromJson((Reader)new FileReader(this.configFile), WalleConfig.class);
                Map<String, String> defaultExtraInfo = config.getDefaultExtraInfo();
                List<WalleConfig.ChannelInfo> channelInfoList = config.getChannelInfoList();
                for (WalleConfig.ChannelInfo channelInfo : channelInfoList) {
                    Map<String, String> extraInfo = channelInfo.getExtraInfo();
                    if (extraInfo == null) {
                        extraInfo = defaultExtraInfo;
                    }
                    this.generateChannelApk(inputFile, outputDir, channelInfo.getChannel(), channelInfo.getAlias(), extraInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void generateChannelApk(File inputFile, File outputDir, String channel, String alias, Map<String, String> extraInfo) {
        String channelName = alias == null ? channel : alias;
        String name = FilenameUtils.getBaseName(inputFile.getName());
        String extension = FilenameUtils.getExtension(inputFile.getName());
        String newName = name + "_" + channelName + "." + extension;
        File channelApk = new File(outputDir, newName);
        try {
            FileUtils.copyFile(inputFile, channelApk);
            ChannelWriter.put(channelApk, channel, extraInfo);
        }
        catch (SignatureNotFoundException | IOException e) {
            e.printStackTrace();
        }
    }
}

