/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.meituan.android.walle.ApkSigningBlock;
import com.meituan.android.walle.ApkSigningPayload;
import com.meituan.android.walle.ApkUtil;
import com.meituan.android.walle.Pair;
import com.meituan.android.walle.SignatureNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class PayloadWriter {
    private PayloadWriter() {
    }

    public static void put(File apkFile, int id, ByteBuffer buffer) throws IOException, SignatureNotFoundException {
        HashMap<Integer, ByteBuffer> idValues = new HashMap<Integer, ByteBuffer>();
        idValues.put(id, buffer);
        PayloadWriter.putAll(apkFile, idValues);
    }

    public static void putAll(File apkFile, final Map<Integer, ByteBuffer> idValues) throws IOException, SignatureNotFoundException {
        PayloadWriter.handleApkSigningBlock(apkFile, new ApkSigningBlockHandler(){

            @Override
            public ApkSigningBlock handle(Map<Integer, ByteBuffer> originIdValues) {
                if (idValues != null && !idValues.isEmpty()) {
                    originIdValues.putAll(idValues);
                }
                ApkSigningBlock apkSigningBlock = new ApkSigningBlock();
                Set<Map.Entry<Integer, ByteBuffer>> entrySet = originIdValues.entrySet();
                for (Map.Entry<Integer, ByteBuffer> entry : entrySet) {
                    ApkSigningPayload payload = new ApkSigningPayload(entry.getKey(), entry.getValue());
                    apkSigningBlock.addPayload(payload);
                }
                return apkSigningBlock;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleApkSigningBlock(File apkFile, ApkSigningBlockHandler handler) throws IOException, SignatureNotFoundException {
        RandomAccessFile fIn = null;
        AbstractInterruptibleChannel fileChannel = null;
        try {
            fIn = new RandomAccessFile(apkFile, "rw");
            fileChannel = fIn.getChannel();
            boolean hasComment = ApkUtil.checkComment((FileChannel)fileChannel);
            if (hasComment) {
                throw new IOException("zip data already has an archive comment");
            }
            long centralDirStartOffset = ApkUtil.findCentralDirStartOffset((FileChannel)fileChannel);
            Pair<ByteBuffer, Long> apkSigningBlockAndOffset = ApkUtil.findApkSigningBlock((FileChannel)fileChannel, centralDirStartOffset);
            ByteBuffer apkSigningBlock2 = apkSigningBlockAndOffset.getFirst();
            long apkSigningBlockOffset = apkSigningBlockAndOffset.getSecond();
            Map<Integer, ByteBuffer> originIdValues = ApkUtil.findIdValues(apkSigningBlock2);
            ByteBuffer apkSignatureSchemeV2Block = originIdValues.get(1896449818);
            if (apkSignatureSchemeV2Block == null) {
                throw new IOException("No APK Signature Scheme v2 block in APK Signing Block");
            }
            ApkSigningBlock apkSigningBlock = handler.handle(originIdValues);
            if (apkSigningBlockOffset != 0L && centralDirStartOffset != 0L) {
                fIn.seek(centralDirStartOffset);
                byte[] centralDirBytes = new byte[(int)(((FileChannel)fileChannel).size() - centralDirStartOffset)];
                fIn.read(centralDirBytes);
                ((FileChannel)fileChannel).position(apkSigningBlockOffset);
                long length = apkSigningBlock.writeApkSigningBlock(fIn);
                fIn.write(centralDirBytes);
                fIn.setLength(fIn.getFilePointer());
                fIn.seek(((FileChannel)fileChannel).size() - 6L);
                ByteBuffer temp = ByteBuffer.allocate(4);
                temp.order(ByteOrder.LITTLE_ENDIAN);
                temp.putInt((int)(centralDirStartOffset + length + 8L - (centralDirStartOffset - apkSigningBlockOffset)));
                temp.flip();
                fIn.write(temp.array());
            }
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static interface ApkSigningBlockHandler {
        public ApkSigningBlock handle(Map<Integer, ByteBuffer> var1);
    }
}

