/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.meituan.android.walle.ChannelInfo;
import com.meituan.android.walle.PayloadReader;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class ChannelReader {
    public static final String CHANNEL_KEY = "channel";

    private ChannelReader() {
    }

    public static ChannelInfo get(File apkFile) {
        Map<String, String> result = ChannelReader.getMap(apkFile);
        if (result == null) {
            return null;
        }
        String channel = result.get(CHANNEL_KEY);
        result.remove(CHANNEL_KEY);
        return new ChannelInfo(channel, result);
    }

    public static Map<String, String> getMap(File apkFile) {
        try {
            String rawString = ChannelReader.getRaw(apkFile);
            if (rawString == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject(rawString);
            Iterator keys = jsonObject.keys();
            HashMap<String, String> result = new HashMap<String, String>();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                result.put(key, jsonObject.getString(key));
            }
            return result;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRaw(File apkFile) {
        byte[] bytes = PayloadReader.get(apkFile, 0x71777777);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

