/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.meituan.android.walle.Pair;
import com.meituan.android.walle.SignatureNotFoundException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.LinkedHashMap;
import java.util.Map;

final class ApkUtil {
    public static final long APK_SIG_BLOCK_MAGIC_HI = 3617552046287187010L;
    public static final long APK_SIG_BLOCK_MAGIC_LO = 2334950737559900225L;
    private static final int APK_SIG_BLOCK_MIN_SIZE = 32;
    public static final int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;
    public static final int APK_CHANNEL_BLOCK_ID = 0x71777777;
    public static final String DEFAULT_CHARSET = "UTF-8";

    private ApkUtil() {
    }

    public static boolean checkComment(FileChannel fileChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        fileChannel.position(fileChannel.size() - 22L);
        fileChannel.read(byteBuffer);
        return byteBuffer.get(0) != 80 || byteBuffer.get(1) != 75 || byteBuffer.get(2) != 5 || byteBuffer.get(3) != 6;
    }

    public static long findCentralDirStartOffset(FileChannel fileChannel) throws IOException {
        ByteBuffer zipEndOfCentralDirectory = ByteBuffer.allocate(4);
        zipEndOfCentralDirectory.order(ByteOrder.LITTLE_ENDIAN);
        fileChannel.position(fileChannel.size() - 6L);
        fileChannel.read(zipEndOfCentralDirectory);
        long centralDirStartOffset = zipEndOfCentralDirectory.getInt(0);
        return centralDirStartOffset;
    }

    public static Pair<ByteBuffer, Long> findApkSigningBlock(FileChannel fileChannel) throws IOException, SignatureNotFoundException {
        long centralDirOffset = ApkUtil.findCentralDirStartOffset(fileChannel);
        return ApkUtil.findApkSigningBlock(fileChannel, centralDirOffset);
    }

    public static Pair<ByteBuffer, Long> findApkSigningBlock(FileChannel fileChannel, long centralDirOffset) throws IOException, SignatureNotFoundException {
        if (centralDirOffset < 32L) {
            throw new SignatureNotFoundException("APK too small for APK Signing Block. ZIP Central Directory offset: " + centralDirOffset);
        }
        fileChannel.position(centralDirOffset - 24L);
        ByteBuffer footer = ByteBuffer.allocate(24);
        fileChannel.read(footer);
        footer.order(ByteOrder.LITTLE_ENDIAN);
        if (footer.getLong(8) != 2334950737559900225L || footer.getLong(16) != 3617552046287187010L) {
            throw new SignatureNotFoundException("No APK Signing Block before ZIP Central Directory");
        }
        long apkSigBlockSizeInFooter = footer.getLong(0);
        if (apkSigBlockSizeInFooter < (long)footer.capacity() || apkSigBlockSizeInFooter > 0x7FFFFFF7L) {
            throw new SignatureNotFoundException("APK Signing Block size out of range: " + apkSigBlockSizeInFooter);
        }
        int totalSize = (int)(apkSigBlockSizeInFooter + 8L);
        long apkSigBlockOffset = centralDirOffset - (long)totalSize;
        if (apkSigBlockOffset < 0L) {
            throw new SignatureNotFoundException("APK Signing Block offset out of range: " + apkSigBlockOffset);
        }
        fileChannel.position(apkSigBlockOffset);
        ByteBuffer apkSigBlock = ByteBuffer.allocate(totalSize);
        fileChannel.read(apkSigBlock);
        apkSigBlock.order(ByteOrder.LITTLE_ENDIAN);
        long apkSigBlockSizeInHeader = apkSigBlock.getLong(0);
        if (apkSigBlockSizeInHeader != apkSigBlockSizeInFooter) {
            throw new SignatureNotFoundException("APK Signing Block sizes in header and footer do not match: " + apkSigBlockSizeInHeader + " vs " + apkSigBlockSizeInFooter);
        }
        return Pair.of(apkSigBlock, apkSigBlockOffset);
    }

    public static Map<Integer, ByteBuffer> findIdValues(ByteBuffer apkSigningBlock) throws SignatureNotFoundException {
        ApkUtil.checkByteOrderLittleEndian(apkSigningBlock);
        ByteBuffer pairs = ApkUtil.sliceFromTo(apkSigningBlock, 8, apkSigningBlock.capacity() - 24);
        LinkedHashMap<Integer, ByteBuffer> idValues = new LinkedHashMap<Integer, ByteBuffer>();
        int entryCount = 0;
        while (pairs.hasRemaining()) {
            ++entryCount;
            if (pairs.remaining() < 8) {
                throw new SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + entryCount);
            }
            long lenLong = pairs.getLong();
            if (lenLong < 4L || lenLong > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + lenLong);
            }
            int len = (int)lenLong;
            int nextEntryPos = pairs.position() + len;
            if (len > pairs.remaining()) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + len + ", available: " + pairs.remaining());
            }
            int id = pairs.getInt();
            idValues.put(id, ApkUtil.getByteBuffer(pairs, len - 4));
            pairs.position(nextEntryPos);
        }
        return idValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer sliceFromTo(ByteBuffer source, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start: " + end + " < " + start);
        }
        int capacity = source.capacity();
        if (end > source.capacity()) {
            throw new IllegalArgumentException("end > capacity: " + end + " > " + capacity);
        }
        int originalLimit = source.limit();
        int originalPosition = source.position();
        try {
            source.position(0);
            source.limit(end);
            source.position(start);
            ByteBuffer result = source.slice();
            result.order(source.order());
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.position(0);
            source.limit(originalLimit);
            source.position(originalPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getByteBuffer(ByteBuffer source, int size) throws BufferUnderflowException {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        int originalLimit = source.limit();
        int position = source.position();
        int limit = position + size;
        if (limit < position || limit > originalLimit) {
            throw new BufferUnderflowException();
        }
        source.limit(limit);
        try {
            ByteBuffer result = source.slice();
            result.order(source.order());
            source.position(limit);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.limit(originalLimit);
        }
    }

    private static void checkByteOrderLittleEndian(ByteBuffer buffer) {
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }
}

